/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.bo.web;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.OrganizationAudit;
import org.kuali.kra.bo.OrganizationIndirectcost;
import org.kuali.kra.bo.OrganizationType;
import org.kuali.kra.bo.web.MaintenanceDocumentSeleniumHelper;
import org.kuali.kra.proposaldevelopment.bo.ActivityType;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;
import org.kuali.rice.kns.document.MaintenanceDocumentBase;

public class OrganizationMaintenanceDocumentSeleniumTest
extends KcSeleniumTestBase {
    private static final String DOCUMENT_TITLE = "Organization";
    private static final String MAINTENANCE_DOCUMENT_TITLE = "Kuali :: Organization Maintenance Document";
    private static final String ORGANIZATION_ID_ID = "organizationId";
    private static final String CONTACT_ADDRESS_ID_ID = "contactAddressId";
    private static final String ORGANIZATION_NAME_ID = "organizationName";
    private static final String ORGANIZATION_TYPES_ORGANIZATION_TYPE_CODE_ID = "organizationTypes.organizationTypeCode";
    private static final String ORGANIZATION_YNQS_ANSWER_ID = "organizationYnqs[%s].answer";
    private static final String ORGANIZATION_YNQS_EXPLANATION_ID = "organizationYnqs[%s].explanation";
    private static final String ORGANIZATION_YNQS_REVIEW_DATE_ID = "organizationYnqs[%s].reviewDate";
    private static final String ORGANIZATION_AUDITS_FISCAL_YEAR_ID = "organizationAudits.fiscalYear";
    private static final String ORGANIZATION_IDCS_IDC_NUMBER_ID = "organizationIdcs.idcNumber";
    private static final String ORGANIZATION_IDCS_APPLICABLE_INDIRECT_COST_RATE_ID = "organizationIdcs.applicableIndirectcostRate";
    private static final String ORGANIZATION_IDCS_END_DATE = "organizationIdcs.endDate";
    private static final String ORGANIZATION_IDCS_IDC_RATE_TYPE_CODE = "organizationIdcs.idcRateTypeCode";
    private static final String ORGANIZATION_IDCS_REQUESTED_DATE = "organizationIdcs.requestedDate";
    private static final String ORGANIZATION_IDCS_START_DATE = "organizationIdcs.startDate";
    private static final String CREATE_DOCUMENT_DESCRIPTION = "Organization - Test Create";
    private static final int CREATE_CONTACT_ADDRESS_ID = 1741;
    private static final String CREATE_ORGANIZATION_NAME = "Test Create Organization";
    private static final String EDIT_DOCUMENT_DESCRIPTION = "Organization - Test Edit";
    private static final int EDIT_CONTACT_ADDRESS_ID_1 = 1741;
    private static final int EDIT_CONTACT_ADDRESS_ID_2 = 13469;
    private static final String EDIT_ORGANIZATION_NAME = "Test Edit Organization";
    private static final String COPY_DOCUMENT_DESCRIPTION = "Organization - Test Copy";
    private static final int COPY_CONTACT_ADDRESS_ID_1 = 1741;
    private static final int COPY_CONTACT_ADDRESS_ID_2 = 13469;
    private static final String COPY_ORGANIZATION_NAME_1 = "Test Copy Organization (Before)";
    private static final String COPY_ORGANIZATION_NAME_2 = "Test Copy Organization (After)";
    private static final int DEFAULT_ORGANIZATION_TYPES_ORGANIZATION_TYPE_CODE = 1;
    private static final String DEFAULT_ORGANIZATION_YNQS_ANSWER_YES = "Y";
    private static final String DEFAULT_ORGANIZATION_YNQS_ANSWER_NO = "N";
    private static final String DEFAULT_ORGANIZATION_YNQS_EXPLANATION = "Test";
    private static final String DEFAULT_ORGANIZATION_YNQS_REVIEW_DATE = "01/01/2008";
    private static final String DEFAULT_ORGANIZATION_AUDITS_FISCAL_YEAR = "2008";
    private static final int DEFAULT_ORGANIZATION_IDCS_IDC_NUMBER = 1;
    private static final String DEFAULT_ORGANIZATION_IDCS_APPLICABLE_INDIRECT_COST_RATE = "1.0";
    private static final int DEFAULT_ORGANIZATION_IDCS_IDC_RATE_TYPE_CODE = 1;
    private static final String DEFAULT_ORGANIZATION_IDCS_END_DATE = "01/01/2008";
    private static final String DEFAULT_ORGANIZATION_IDCS_REQUESTED_DATE = "01/01/2008";
    private static final String DEFAULT_ORGANIZATION_IDCS_START_DATE = "01/01/2008";
    private MaintenanceDocumentSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = MaintenanceDocumentSeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testCreateOrganization() throws Exception {
        String organizationId = this.getNewOrganizationId();
        String documentNumber = this.createNewMaintenanceDocument(CREATE_DOCUMENT_DESCRIPTION, organizationId, 1741, CREATE_ORGANIZATION_NAME, 11);
        this.verifyExistingMaintenanceDocument(documentNumber, organizationId, 1741, CREATE_ORGANIZATION_NAME);
    }

    @Test
    public void testEditOrganization() throws Exception {
        String organizationId = this.getNewOrganizationId();
        this.createNewMaintenanceDocument(EDIT_DOCUMENT_DESCRIPTION, organizationId, 1741, EDIT_ORGANIZATION_NAME, 11);
        LinkedHashMap<String, String> searchValues = new LinkedHashMap<String, String>();
        searchValues.put(ORGANIZATION_ID_ID, organizationId);
        String documentNumber = this.helper.editMaintenanceDocument(DOCUMENT_TITLE, Organization.class.getName(), searchValues, MAINTENANCE_DOCUMENT_TITLE);
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put(CONTACT_ADDRESS_ID_ID, String.valueOf(13469));
        this.helper.populateMaintenanceDocument(EDIT_DOCUMENT_DESCRIPTION, fieldValues);
        this.helper.routeDocument();
        this.helper.assertRoute();
        this.verifyExistingMaintenanceDocument(documentNumber, organizationId, 13469, EDIT_ORGANIZATION_NAME);
    }

    @Test
    public void testCopyOrganization() throws Exception {
        String organizationId1 = this.getNewOrganizationId();
        this.createNewMaintenanceDocument(COPY_DOCUMENT_DESCRIPTION, organizationId1, 1741, COPY_ORGANIZATION_NAME_1, 11);
        LinkedHashMap<String, String> searchValues = new LinkedHashMap<String, String>();
        searchValues.put(ORGANIZATION_ID_ID, organizationId1);
        String documentNumber = this.helper.copyMaintenanceDocument(DOCUMENT_TITLE, ActivityType.class.getName(), searchValues, MAINTENANCE_DOCUMENT_TITLE);
        String organizationId2 = this.getNewOrganizationId();
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put(ORGANIZATION_ID_ID, organizationId2);
        fieldValues.put(CONTACT_ADDRESS_ID_ID, String.valueOf(13469));
        fieldValues.put(ORGANIZATION_NAME_ID, COPY_ORGANIZATION_NAME_2);
        this.helper.populateMaintenanceDocument(COPY_DOCUMENT_DESCRIPTION, fieldValues);
        this.helper.routeDocument();
        this.helper.assertRoute();
        this.verifyExistingMaintenanceDocument(documentNumber, organizationId2, 13469, COPY_ORGANIZATION_NAME_2);
    }

    private String createNewMaintenanceDocument(String documentDescription, String organizationId, int contactAddressId, String organizationName, int numberYnqs) {
        String documentNumber = this.helper.createMaintenanceDocument(DOCUMENT_TITLE, Organization.class.getName(), MAINTENANCE_DOCUMENT_TITLE);
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put(ORGANIZATION_ID_ID, organizationId);
        fieldValues.put(CONTACT_ADDRESS_ID_ID, String.valueOf(contactAddressId));
        fieldValues.put(ORGANIZATION_NAME_ID, organizationName);
        for (int i = 0; i <= numberYnqs; ++i) {
            fieldValues.put(String.format(ORGANIZATION_YNQS_ANSWER_ID, i), i % 2 == 0 ? DEFAULT_ORGANIZATION_YNQS_ANSWER_YES : DEFAULT_ORGANIZATION_YNQS_ANSWER_NO);
            fieldValues.put(String.format(ORGANIZATION_YNQS_EXPLANATION_ID, i), DEFAULT_ORGANIZATION_YNQS_EXPLANATION);
            fieldValues.put(String.format(ORGANIZATION_YNQS_REVIEW_DATE_ID, i), "01/01/2008");
        }
        ArrayList<Map<String, String>> collectionFieldValues = new ArrayList<Map<String, String>>();
        LinkedHashMap<String, String> organizationTypeFieldValues = new LinkedHashMap<String, String>();
        organizationTypeFieldValues.put(ORGANIZATION_TYPES_ORGANIZATION_TYPE_CODE_ID, String.valueOf(1));
        collectionFieldValues.add(organizationTypeFieldValues);
        LinkedHashMap<String, String> organizationAuditsFieldValues = new LinkedHashMap<String, String>();
        organizationAuditsFieldValues.put(ORGANIZATION_AUDITS_FISCAL_YEAR_ID, DEFAULT_ORGANIZATION_AUDITS_FISCAL_YEAR);
        collectionFieldValues.add(organizationAuditsFieldValues);
        LinkedHashMap<String, String> organizationIdcsFieldValues = new LinkedHashMap<String, String>();
        organizationIdcsFieldValues.put(ORGANIZATION_IDCS_IDC_NUMBER_ID, String.valueOf(1));
        organizationIdcsFieldValues.put(ORGANIZATION_IDCS_APPLICABLE_INDIRECT_COST_RATE_ID, DEFAULT_ORGANIZATION_IDCS_APPLICABLE_INDIRECT_COST_RATE);
        organizationIdcsFieldValues.put(ORGANIZATION_IDCS_END_DATE, "01/01/2008");
        organizationIdcsFieldValues.put(ORGANIZATION_IDCS_IDC_RATE_TYPE_CODE, String.valueOf(1));
        organizationIdcsFieldValues.put(ORGANIZATION_IDCS_REQUESTED_DATE, "01/01/2008");
        organizationIdcsFieldValues.put(ORGANIZATION_IDCS_START_DATE, "01/01/2008");
        collectionFieldValues.add(organizationIdcsFieldValues);
        this.helper.populateMaintenanceDocument(documentDescription, fieldValues, collectionFieldValues);
        this.helper.click("methodToCall.addLine.organizationTypes");
        this.helper.click("methodToCall.addLine.organizationAudits");
        this.helper.click("methodToCall.addLine.organizationIdcs");
        this.helper.routeDocument();
        this.helper.assertRoute();
        return documentNumber;
    }

    private void verifyExistingMaintenanceDocument(String documentNumber, String organizationId, int contactAddressId, String organizationName) throws Exception {
        MaintenanceDocumentBase document = (MaintenanceDocumentBase)this.getDocumentService().getByDocumentHeaderId(documentNumber);
        OrganizationMaintenanceDocumentSeleniumTest.assertNotNull((Object)document.getDocumentNumber());
        OrganizationMaintenanceDocumentSeleniumTest.assertNotNull((Object)document.getDocumentHeader());
        OrganizationMaintenanceDocumentSeleniumTest.assertEquals((Object)documentNumber, (Object)document.getDocumentHeader().getDocumentNumber());
        Organization organization = (Organization)document.getNewMaintainableObject().getDataObject();
        OrganizationMaintenanceDocumentSeleniumTest.assertEquals((Object)organizationId, (Object)organization.getOrganizationId());
        OrganizationMaintenanceDocumentSeleniumTest.assertEquals((Object)contactAddressId, (Object)organization.getContactAddressId());
        OrganizationMaintenanceDocumentSeleniumTest.assertEquals((Object)organizationName, (Object)organization.getOrganizationName());
        OrganizationMaintenanceDocumentSeleniumTest.assertEquals((Object)1, (Object)((OrganizationType)organization.getOrganizationTypes().get(0)).getOrganizationTypeCode());
        OrganizationMaintenanceDocumentSeleniumTest.assertEquals((Object)DEFAULT_ORGANIZATION_AUDITS_FISCAL_YEAR, (Object)((OrganizationAudit)organization.getOrganizationAudits().get(0)).getFiscalYear());
        OrganizationMaintenanceDocumentSeleniumTest.assertEquals((Object)1, (Object)((OrganizationIndirectcost)organization.getOrganizationIdcs().get(0)).getIdcNumber());
    }

    private String getNewOrganizationId() {
        int maxOrganizationId = 1;
        Collection organizations = this.getBusinessObjectService().findAll(Organization.class);
        for (Organization organization : organizations) {
            int activityTypeCode = NumberUtils.toInt((String)organization.getOrganizationId(), (int)1);
            if (activityTypeCode <= maxOrganizationId) continue;
            maxOrganizationId = activityTypeCode;
        }
        return String.format("%06d", maxOrganizationId + 1);
    }
}

