/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.bo.web;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.SponsorFormTemplate;
import org.kuali.kra.bo.SponsorForms;
import org.kuali.kra.bo.web.MaintenanceDocumentSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;
import org.kuali.rice.kns.document.MaintenanceDocumentBase;

public class SponsorFormMaintenanceDocumentSeleniumTest
extends KcSeleniumTestBase {
    private static final String SPONSOR_FORM_DOCUMENT_TITLE = "Sponsor Forms";
    private static final String SPONSOR_FORM_MAINTENANCE_DOCUMENT_TITLE = "Kuali :: Sponsor Form";
    private static final String SPONSOR_FORM_TEMPLATE_DOCUMENT_TITLE = "Sponsor Form Templates";
    private static final String SPONSOR_FORM_TEMPLATE_MAINTENANCE_DOCUMENT_TITLE = "Kuali :: Sponsor Form Template";
    private static final String PACKAGE_NAME_ID = "packageName";
    private static final String PACKAGE_NUMBER_ID = "packageNumber";
    private static final String SPONSOR_CODE_ID = "sponsorCode";
    private static final String SPONSOR_FORM_ID_ID = "sponsorFormId";
    private static final String PAGE_DESCRIPTION_ID = "pageDescription";
    private static final String PAGE_NUMBER_ID = "pageNumber";
    private static final String CREATE_SPONSOR_FORM_DOCUMENT_DESCRIPTION = "Sponsor Form - Test Create";
    private static final String CREATE_SPONSOR_FORM_SPONSOR_CODE = "000100";
    private static final String EDIT_SPONSOR_FORM_DOCUMENT_DESCRIPTION = "Sponsor Form - Test Edit";
    private static final String EDIT_SPONSOR_FORM_SPONSOR_CODE_1 = "000100";
    private static final String EDIT_SPONSOR_FORM_SPONSOR_CODE_2 = "000101";
    private static final String COPY_SPONSOR_FORM_DOCUMENT_DESCRIPTION = "Sponsor Form - Test Copy";
    private static final String COPY_SPONSOR_FORM_SPONSOR_CODE_1 = "000100";
    private static final String COPY_SPONSOR_FORM_SPONSOR_CODE_2 = "000101";
    private static final String CREATE_SPONSOR_FORM_TEMPLATE_DOCUMENT_DESCRIPTION = "Sponsor Form Template - Test Create";
    private static final String CREATE_SPONSOR_FORM_TEMPLATE_PAGE_DESCRIPTION = "Test Create Sponsor Form Template";
    private static final String EDIT_SPONSOR_FORM_TEMPLATE_DOCUMENT_DESCRIPTION = "Sponsor Form Template - Test Edit";
    private static final String EDIT_SPONSOR_FORM_TEMPLATE_PAGE_DESCRIPTION_1 = "Test Edit Sponsor Form Template (Before)";
    private static final String EDIT_SPONSOR_FORM_TEMPLATE_PAGE_DESCRIPTION_2 = "Test Edit Sponsor Form Template (After)";
    private static final String COPY_SPONSOR_FORM_TEMPLATE_DOCUMENT_DESCRIPTION = "Sponsor Form - Test Copy";
    private static final String COPY_SPONSOR_FORM_TEMPLATE_PAGE_DESCRIPTION = "Test Copy Sponsor Form Template";
    private static final String DEFAULT_PACKAGE_NAME = "Test Sponsor Form";
    private static final String DEFAULT_SPONSOR_CODE = "000100";
    private MaintenanceDocumentSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = MaintenanceDocumentSeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testCreateSponsorForm() throws Exception {
        int packageNumber = this.getNewPackageNumber();
        String documentNumber = this.createNewSponsorFormMaintenanceDocument(CREATE_SPONSOR_FORM_DOCUMENT_DESCRIPTION, packageNumber, "000100");
        this.verifyExistingSponsorFormMaintenanceDocument(documentNumber, packageNumber, "000100");
    }

    @Test
    public void testEditSponsorForm() throws Exception {
        int packageNumber = this.getNewPackageNumber();
        this.createNewSponsorFormMaintenanceDocument(EDIT_SPONSOR_FORM_DOCUMENT_DESCRIPTION, packageNumber, "000100");
        LinkedHashMap<String, String> searchValues = new LinkedHashMap<String, String>();
        searchValues.put(PACKAGE_NAME_ID, DEFAULT_PACKAGE_NAME);
        searchValues.put(PACKAGE_NUMBER_ID, String.valueOf(packageNumber));
        String documentNumber = this.helper.editMaintenanceDocument(SPONSOR_FORM_DOCUMENT_TITLE, SponsorForms.class.getName(), searchValues, SPONSOR_FORM_MAINTENANCE_DOCUMENT_TITLE);
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put(SPONSOR_CODE_ID, "000101");
        this.helper.populateMaintenanceDocument(EDIT_SPONSOR_FORM_DOCUMENT_DESCRIPTION, fieldValues);
        this.helper.routeDocument();
        this.helper.assertRoute();
        this.verifyExistingSponsorFormMaintenanceDocument(documentNumber, packageNumber, "000101");
    }

    @Test
    public void testCopySponsorForm() throws Exception {
        int packageNumber1 = this.getNewPackageNumber();
        this.createNewSponsorFormMaintenanceDocument("Sponsor Form - Test Copy", packageNumber1, "000100");
        LinkedHashMap<String, String> searchValues = new LinkedHashMap<String, String>();
        searchValues.put(PACKAGE_NAME_ID, DEFAULT_PACKAGE_NAME);
        searchValues.put(PACKAGE_NUMBER_ID, String.valueOf(packageNumber1));
        String documentNumber = this.helper.copyMaintenanceDocument(SPONSOR_FORM_DOCUMENT_TITLE, SponsorForms.class.getName(), searchValues, SPONSOR_FORM_MAINTENANCE_DOCUMENT_TITLE);
        int packageNumber2 = this.getNewPackageNumber();
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put(PACKAGE_NAME_ID, DEFAULT_PACKAGE_NAME);
        fieldValues.put(PACKAGE_NUMBER_ID, String.valueOf(packageNumber2));
        fieldValues.put(SPONSOR_CODE_ID, "000101");
        this.helper.populateMaintenanceDocument("Sponsor Form - Test Copy", fieldValues);
        this.helper.routeDocument();
        this.helper.assertRoute();
        this.verifyExistingSponsorFormMaintenanceDocument(documentNumber, packageNumber2, "000101");
    }

    @Test
    public void testCreateSponsorFormTemplate() throws Exception {
        long sponsorFormId = this.createNewSponsorFormForSponsorFormTemplate();
        int pageNumber = this.getNewPageNumber(sponsorFormId);
        String documentNumber = this.createNewSponsorFormTemplateMaintenanceDocument(CREATE_SPONSOR_FORM_TEMPLATE_DOCUMENT_DESCRIPTION, sponsorFormId, CREATE_SPONSOR_FORM_TEMPLATE_PAGE_DESCRIPTION, pageNumber);
        this.verifyExistingSponsorFormTemplateMaintenanceDocument(documentNumber, sponsorFormId, CREATE_SPONSOR_FORM_TEMPLATE_PAGE_DESCRIPTION, pageNumber);
    }

    @Test
    public void testEditSponsorFormTemplate() throws Exception {
        long sponsorFormId = this.createNewSponsorFormForSponsorFormTemplate();
        int pageNumber = this.getNewPageNumber(sponsorFormId);
        this.createNewSponsorFormTemplateMaintenanceDocument(EDIT_SPONSOR_FORM_TEMPLATE_DOCUMENT_DESCRIPTION, sponsorFormId, EDIT_SPONSOR_FORM_TEMPLATE_PAGE_DESCRIPTION_1, pageNumber);
        LinkedHashMap<String, String> searchValues = new LinkedHashMap<String, String>();
        searchValues.put(SPONSOR_FORM_ID_ID, String.valueOf(sponsorFormId));
        String documentNumber = this.helper.editMaintenanceDocument(SPONSOR_FORM_TEMPLATE_DOCUMENT_TITLE, SponsorFormTemplate.class.getName(), searchValues, SPONSOR_FORM_TEMPLATE_MAINTENANCE_DOCUMENT_TITLE);
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put(PAGE_DESCRIPTION_ID, EDIT_SPONSOR_FORM_TEMPLATE_PAGE_DESCRIPTION_2);
        this.helper.populateMaintenanceDocument(EDIT_SPONSOR_FORM_TEMPLATE_DOCUMENT_DESCRIPTION, fieldValues);
        this.helper.routeDocument();
        this.helper.assertRoute();
        this.verifyExistingSponsorFormTemplateMaintenanceDocument(documentNumber, sponsorFormId, EDIT_SPONSOR_FORM_TEMPLATE_PAGE_DESCRIPTION_2, pageNumber);
    }

    @Test
    public void testCopySponsorFormTemplate() throws Exception {
        long sponsorFormId = this.createNewSponsorFormForSponsorFormTemplate();
        int pageNumber1 = this.getNewPageNumber(sponsorFormId);
        this.createNewSponsorFormTemplateMaintenanceDocument("Sponsor Form - Test Copy", sponsorFormId, COPY_SPONSOR_FORM_TEMPLATE_PAGE_DESCRIPTION, pageNumber1);
        LinkedHashMap<String, String> searchValues = new LinkedHashMap<String, String>();
        searchValues.put(SPONSOR_FORM_ID_ID, String.valueOf(sponsorFormId));
        String documentNumber = this.helper.copyMaintenanceDocument(SPONSOR_FORM_TEMPLATE_DOCUMENT_TITLE, SponsorFormTemplate.class.getName(), searchValues, SPONSOR_FORM_TEMPLATE_MAINTENANCE_DOCUMENT_TITLE);
        int pageNumber2 = this.getNewPageNumber(sponsorFormId);
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put(PAGE_DESCRIPTION_ID, COPY_SPONSOR_FORM_TEMPLATE_PAGE_DESCRIPTION);
        fieldValues.put(PAGE_NUMBER_ID, String.valueOf(pageNumber2));
        this.helper.populateMaintenanceDocument("Sponsor Form - Test Copy", fieldValues);
        this.helper.routeDocument();
        this.helper.assertRoute();
        this.verifyExistingSponsorFormTemplateMaintenanceDocument(documentNumber, sponsorFormId, COPY_SPONSOR_FORM_TEMPLATE_PAGE_DESCRIPTION, pageNumber2);
    }

    private String createNewSponsorFormMaintenanceDocument(String documentDescription, int packageNumber, String sponsorCode) {
        String documentNumber = this.helper.createMaintenanceDocument(SPONSOR_FORM_DOCUMENT_TITLE, SponsorForms.class.getName(), SPONSOR_FORM_MAINTENANCE_DOCUMENT_TITLE);
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put(PACKAGE_NAME_ID, DEFAULT_PACKAGE_NAME);
        fieldValues.put(PACKAGE_NUMBER_ID, String.valueOf(packageNumber));
        fieldValues.put(SPONSOR_CODE_ID, sponsorCode);
        this.helper.populateMaintenanceDocument(documentDescription, fieldValues);
        this.helper.routeDocument();
        this.helper.assertRoute();
        return documentNumber;
    }

    private String createNewSponsorFormTemplateMaintenanceDocument(String documentDescription, long sponsorFormId, String pageDescription, int pageNumber) {
        String documentNumber = this.helper.createMaintenanceDocument(SPONSOR_FORM_TEMPLATE_DOCUMENT_TITLE, SponsorFormTemplate.class.getName(), SPONSOR_FORM_TEMPLATE_MAINTENANCE_DOCUMENT_TITLE);
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put(SPONSOR_FORM_ID_ID, String.valueOf(sponsorFormId));
        fieldValues.put(PAGE_DESCRIPTION_ID, pageDescription);
        fieldValues.put(PAGE_NUMBER_ID, String.valueOf(pageNumber));
        this.helper.populateMaintenanceDocument(documentDescription, fieldValues);
        this.helper.routeDocument();
        this.helper.assertRoute();
        return documentNumber;
    }

    private long createNewSponsorFormForSponsorFormTemplate() {
        int packageNumber = this.getNewPackageNumber();
        this.createNewSponsorFormMaintenanceDocument(CREATE_SPONSOR_FORM_DOCUMENT_DESCRIPTION, packageNumber, "000100");
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put(PACKAGE_NAME_ID, DEFAULT_PACKAGE_NAME);
        fieldValues.put(PACKAGE_NUMBER_ID, String.valueOf(packageNumber));
        ArrayList sponsorForms = new ArrayList(this.getBusinessObjectService().findMatching(SponsorForms.class, fieldValues));
        return ((SponsorForms)sponsorForms.get(0)).getSponsorFormId();
    }

    private void verifyExistingSponsorFormMaintenanceDocument(String documentNumber, int packageNumber, String sponsorCode) throws Exception {
        MaintenanceDocumentBase document = (MaintenanceDocumentBase)this.getDocumentService().getByDocumentHeaderId(documentNumber);
        SponsorFormMaintenanceDocumentSeleniumTest.assertNotNull((Object)document.getDocumentNumber());
        SponsorFormMaintenanceDocumentSeleniumTest.assertNotNull((Object)document.getDocumentHeader());
        SponsorFormMaintenanceDocumentSeleniumTest.assertEquals((Object)documentNumber, (Object)document.getDocumentHeader().getDocumentNumber());
        SponsorForms sponsorForm = (SponsorForms)document.getNewMaintainableObject().getDataObject();
        SponsorFormMaintenanceDocumentSeleniumTest.assertEquals((Object)DEFAULT_PACKAGE_NAME, (Object)sponsorForm.getPackageName());
        SponsorFormMaintenanceDocumentSeleniumTest.assertEquals((Object)packageNumber, (Object)sponsorForm.getPackageNumber());
        SponsorFormMaintenanceDocumentSeleniumTest.assertEquals((Object)sponsorCode, (Object)sponsorForm.getSponsorCode());
    }

    private void verifyExistingSponsorFormTemplateMaintenanceDocument(String documentNumber, long sponsorFormId, String pageDescription, int pageNumber) throws Exception {
        MaintenanceDocumentBase document = (MaintenanceDocumentBase)this.getDocumentService().getByDocumentHeaderId(documentNumber);
        SponsorFormMaintenanceDocumentSeleniumTest.assertNotNull((Object)document.getDocumentNumber());
        SponsorFormMaintenanceDocumentSeleniumTest.assertNotNull((Object)document.getDocumentHeader());
        SponsorFormMaintenanceDocumentSeleniumTest.assertEquals((Object)documentNumber, (Object)document.getDocumentHeader().getDocumentNumber());
        SponsorFormTemplate sponsorFormTemplate = (SponsorFormTemplate)document.getNewMaintainableObject().getDataObject();
        SponsorFormMaintenanceDocumentSeleniumTest.assertEquals((Object)sponsorFormId, (Object)sponsorFormTemplate.getSponsorFormId());
        SponsorFormMaintenanceDocumentSeleniumTest.assertEquals((Object)pageDescription, (Object)sponsorFormTemplate.getPageDescription());
        SponsorFormMaintenanceDocumentSeleniumTest.assertEquals((Object)pageNumber, (Object)sponsorFormTemplate.getPageNumber());
    }

    private int getNewPackageNumber() {
        int maxPackageNumber = 1;
        Collection sponsorForms = this.getBusinessObjectService().findAll(SponsorForms.class);
        for (SponsorForms sponsorForm : sponsorForms) {
            int packageNumber = sponsorForm.getPackageNumber();
            if (packageNumber <= maxPackageNumber) continue;
            maxPackageNumber = packageNumber;
        }
        return maxPackageNumber + 1;
    }

    private int getNewPageNumber(long sponsorFormId) {
        int maxPageNumber = 1;
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put(SPONSOR_FORM_ID_ID, String.valueOf(sponsorFormId));
        Collection sponsorFormTemplates = this.getBusinessObjectService().findMatching(SponsorFormTemplate.class, fieldValues);
        for (SponsorFormTemplate sponsorFormTemplate : sponsorFormTemplates) {
            int activityTypeCode = sponsorFormTemplate.getPageNumber();
            if (activityTypeCode <= maxPageNumber) continue;
            maxPageNumber = activityTypeCode;
        }
        return maxPageNumber + 1;
    }
}

