/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.bo;

import java.sql.Date;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.bo.BudgetDistributionAndIncomeTest;
import org.kuali.kra.budget.core.Budget;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;

public class BudgetCostShareTest
extends BudgetDistributionAndIncomeTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testCalculatingTotalCostSharing() {
        this.createAndAddBudgetPeriod().setCostSharingAmount(FY_2007_Q3_AMT);
        Assert.assertEquals((Object)FY_2007_Q3_AMT, (Object)this.budgetDocument.getAvailableCostSharing());
        this.createAndAddBudgetPeriod().setCostSharingAmount(FY_2007_Q4_AMT);
        Assert.assertEquals((Object)FY_2007_Q3_AMT.add((AbstractKualiDecimal)FY_2007_Q4_AMT), (Object)this.budgetDocument.getAvailableCostSharing());
        this.createAndAddBudgetPeriod().setCostSharingAmount(FY_2008_Q1_AMT);
        Assert.assertEquals((Object)((BudgetDecimal)FY_2007_Q3_AMT.add((AbstractKualiDecimal)FY_2007_Q4_AMT)).add((AbstractKualiDecimal)FY_2008_Q1_AMT), (Object)this.budgetDocument.getAvailableCostSharing());
        Assert.assertTrue((boolean)this.budgetDocument.isCostSharingAvailable());
    }

    @Test
    public void testGettingFiscalYearCostShareTotals() {
        this.createBudgetPeriodsForThreeFiscalYears();
        List fiscalYearCostShareTotals = this.budgetDocument.getFiscalYearCostShareTotals();
        Assert.assertEquals((long)3L, (long)fiscalYearCostShareTotals.size());
        Budget.FiscalYearSummary fiscalYearSummary = (Budget.FiscalYearSummary)fiscalYearCostShareTotals.get(0);
        Assert.assertEquals((long)2007L, (long)fiscalYearSummary.getFiscalYear());
        Assert.assertEquals((Object)this.getDate(2007, 0, 1), (Object)fiscalYearSummary.getAssignedBudgetPeriod().getStartDate());
        Assert.assertEquals((Object)FY_2007_Q3_AMT.add((AbstractKualiDecimal)FY_2007_Q4_AMT), (Object)fiscalYearSummary.getCostShare());
        fiscalYearSummary = (Budget.FiscalYearSummary)fiscalYearCostShareTotals.get(1);
        Assert.assertEquals((long)2008L, (long)fiscalYearSummary.getFiscalYear());
        Assert.assertEquals((Object)this.getDate(2007, 6, 1), (Object)fiscalYearSummary.getAssignedBudgetPeriod().getStartDate());
        Assert.assertEquals((Object)FY_2008_Q1_AMT.add((AbstractKualiDecimal)FY_2008_Q2_AMT), (Object)fiscalYearSummary.getCostShare());
        fiscalYearSummary = (Budget.FiscalYearSummary)fiscalYearCostShareTotals.get(2);
        Assert.assertEquals((long)2009L, (long)fiscalYearSummary.getFiscalYear());
        Assert.assertEquals((Object)this.getDate(2008, 9, 1), (Object)fiscalYearSummary.getAssignedBudgetPeriod().getStartDate());
        Assert.assertEquals((Object)FY_2009_Q1_AMT.add((AbstractKualiDecimal)FY_2009_Q2_AMT), (Object)fiscalYearSummary.getCostShare());
    }

    @Test
    public void testIfCostSharingIsAvailable_BudgetPeriodPresentWithNonZeroCostSharing() {
        Assert.assertFalse((boolean)this.budgetDocument.isCostSharingAvailable());
        this.createAndAddBudgetPeriod().setCostSharingAmount(FY_2007_Q3_AMT);
        Assert.assertTrue((boolean)this.budgetDocument.isCostSharingAvailable());
    }

    @Test
    public void testCorrectBudgetPeriodAssignedForFiscalYear() {
        this.createAndAddBudgetPeriod(this.getDate(2007, 10, 1), this.getDate(2007, 11, 30)).setCostSharingAmount(FY_2007_Q3_AMT);
        this.createAndAddBudgetPeriod(this.getDate(2007, 6, 1), this.getDate(2007, 8, 30)).setCostSharingAmount(FY_2008_Q1_AMT);
        this.createAndAddBudgetPeriod(this.getDate(2007, 3, 1), this.getDate(2007, 5, 30)).setCostSharingAmount(FY_2007_Q4_AMT);
        Date startDate = this.getDate(2007, 0, 1);
        this.createAndAddBudgetPeriod(startDate, this.getDate(2007, 2, 30)).setCostSharingAmount(FY_2007_Q3_AMT);
        List fiscalYearCostShareTotals = this.budgetDocument.getFiscalYearCostShareTotals();
        Budget.FiscalYearSummary fiscalYearSummary = (Budget.FiscalYearSummary)fiscalYearCostShareTotals.get(0);
        Assert.assertEquals((Object)startDate, (Object)fiscalYearSummary.getAssignedBudgetPeriod().getStartDate());
    }

    @Test
    public void testFindingCostSharingForFiscalYear() throws Exception {
        this.createBudgetPeriodsForThreeFiscalYears();
        Assert.assertEquals((Object)FY_2007_Q3_AMT.add((AbstractKualiDecimal)FY_2007_Q4_AMT), (Object)this.budgetDocument.findCostSharingForFiscalYear(Integer.valueOf(2007)));
        Assert.assertEquals((Object)FY_2008_Q1_AMT.add((AbstractKualiDecimal)FY_2008_Q2_AMT), (Object)this.budgetDocument.findCostSharingForFiscalYear(Integer.valueOf(2008)));
        Assert.assertEquals((Object)FY_2009_Q1_AMT.add((AbstractKualiDecimal)FY_2009_Q2_AMT), (Object)this.budgetDocument.findCostSharingForFiscalYear(Integer.valueOf(2009)));
        Assert.assertEquals((Object)BudgetDecimal.ZERO, (Object)this.budgetDocument.findCostSharingForFiscalYear(Integer.valueOf(2000)));
    }

    @Test
    public void testIfCostSharingIsAvailable_BudgetPeriodPresentWithZeroCostSharing() {
        this.createAndAddBudgetPeriod().setCostSharingAmount(BudgetDecimal.ZERO);
        Assert.assertFalse((boolean)this.budgetDocument.isCostSharingAvailable());
    }

    @Test
    public void testIfCostSharingIsAvailable_BudgetPeriodPresentButNoCostSharing() {
        Assert.assertFalse((boolean)this.budgetDocument.isCostSharingAvailable());
    }

    @Test
    public void testIfCostSharingIsAvailable_NoBudgetPeriods() {
        this.budgetDocument.getBudgetPeriods().clear();
        Assert.assertFalse((boolean)this.budgetDocument.isCostSharingAvailable());
    }

    @Test
    public void testIfCostSharingIsAvailable_BudgetPeriodsPresentWithCostSharingInOne() {
        this.createAndAddBudgetPeriod().setCostSharingAmount(BudgetDecimal.ZERO);
        this.createAndAddBudgetPeriod().setCostSharingAmount(FY_2007_Q3_AMT);
        this.createAndAddBudgetPeriod().setCostSharingAmount(BudgetDecimal.ZERO);
        Assert.assertTrue((boolean)this.budgetDocument.isCostSharingAvailable());
    }

    @Test
    public void testCostSharingIsApplicable() {
        Assert.assertTrue((boolean)this.budgetDocument.isCostSharingApplicable());
    }

    @Test
    public void testCostSharingIsNotApplicable() {
        this.budgetDocument = new BudgetDistributionAndIncomeTest.BudgetDocument_CostShareAndUnrecoveredFandANotApplicable(this);
        this.createAndAddBudgetPeriod().setCostSharingAmount(FY_2007_Q3_AMT);
        this.createAndAddBudgetPeriod().setCostSharingAmount(FY_2007_Q4_AMT);
        this.createAndAddBudgetPeriod().setCostSharingAmount(FY_2008_Q1_AMT);
        Assert.assertFalse((boolean)this.budgetDocument.isCostSharingApplicable());
    }
}

