/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.bo;

import java.sql.Date;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.distributionincome.BudgetDistributionAndIncomeComponent;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.service.ProposalDevelopmentService;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class BudgetDistributionAndIncomeIntegrationTest
extends KcUnitTestBase {
    protected static final BudgetDecimal AMOUNT_1 = new BudgetDecimal(1000.0);
    protected static final BudgetDecimal AMOUNT_2 = new BudgetDecimal(2000.0);
    protected static final BudgetDecimal AMOUNT_3 = new BudgetDecimal(3000.0);
    protected static final int FY_2008 = 2008;
    protected static final int FY_2009 = 2009;
    protected static final int FY_2010 = 2010;
    protected static final String SOURCE_ACCOUNT_1 = "12345A";
    protected static final String SOURCE_ACCOUNT_2 = "12345B";
    protected static final String SOURCE_ACCOUNT_3 = "12345C";
    protected BudgetDocument budgetDocument;
    protected ProposalDevelopmentDocument proposalDocument;
    protected ProposalDevelopmentService proposalDevelopmentService;

    protected abstract void addBudgetDistributionAndIncomeComponent(BudgetDistributionAndIncomeComponent var1);

    protected abstract BudgetDistributionAndIncomeComponent createBudgetDistributionAndIncomeComponent();

    protected abstract BudgetDistributionAndIncomeComponent[] createBudgetDistributionAndIncomeComponentCollection();

    protected abstract List<? extends BudgetDistributionAndIncomeComponent> getBudgetDistributionAndIncomeComponents(BudgetDocument var1);

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        this.proposalDevelopmentService = (ProposalDevelopmentService)KraServiceLocator.getService(ProposalDevelopmentService.class);
        this.initProposalDocument();
        this.initBudgetDocument();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        GlobalVariables.setUserSession(null);
        this.budgetDocument = null;
        super.tearDown();
    }

    @Test
    public void testDelete_FromMultipleInstances() throws Exception {
        BudgetDistributionAndIncomeComponent[] components = this.createBudgetDistributionAndIncomeComponentCollection();
        this.saveBudgetDistributionAndIncomeComponentCollection(components);
        for (int i = components.length - 1; i >= 0; --i) {
            BudgetDistributionAndIncomeIntegrationTest.assertNotNull((Object)this.getBudgetDistributionAndIncomeComponents(this.budgetDocument).remove(i));
            this.getDocumentService().saveDocument((Document)this.budgetDocument);
            BudgetDocument savedDocument = (BudgetDocument)this.getDocumentService().getByDocumentHeaderId(this.budgetDocument.getDocumentNumber());
            BudgetDistributionAndIncomeIntegrationTest.assertEquals((long)i, (long)this.getBudgetDistributionAndIncomeComponents(savedDocument).size());
        }
    }

    @Test
    public void testDelete_SingleInstance() throws Exception {
        this.initializeAndSaveSingleInstance();
        BudgetDocument savedDocument = this.loadDocumentAndCheckSingleComponentSaved();
        this.getBudgetDistributionAndIncomeComponents(savedDocument).remove(0);
        this.getDocumentService().saveDocument((Document)savedDocument);
        savedDocument = (BudgetDocument)this.getDocumentService().getByDocumentHeaderId(this.budgetDocument.getDocumentNumber());
        BudgetDistributionAndIncomeIntegrationTest.assertEquals((long)0L, (long)this.getBudgetDistributionAndIncomeComponents(savedDocument).size());
    }

    @Test
    public void testSave_MultipleInstances() throws Exception {
        BudgetDistributionAndIncomeComponent[] components = this.createBudgetDistributionAndIncomeComponentCollection();
        BudgetDocument savedDocument = this.saveBudgetDistributionAndIncomeComponentCollection(components);
        BudgetDistributionAndIncomeIntegrationTest.assertNotNull((Object)savedDocument);
        BudgetDistributionAndIncomeIntegrationTest.assertEquals((long)components.length, (long)this.getBudgetDistributionAndIncomeComponents(savedDocument).size());
    }

    @Test
    public void testSave_SingleInstance() throws Exception {
        this.initializeAndSaveSingleInstance();
        this.loadDocumentAndCheckSingleComponentSaved();
    }

    protected Date getNowDate() {
        return new Date(System.currentTimeMillis());
    }

    private BudgetPeriod createBudgetPeriod(Integer budgetPeriodNumber) {
        BudgetPeriod budgetPeriod = new BudgetPeriod();
        budgetPeriod.setBudgetPeriod(budgetPeriodNumber);
        budgetPeriod.setStartDate(this.getNowDate());
        budgetPeriod.setEndDate(this.getNowDate());
        return budgetPeriod;
    }

    private void initBudgetDocument() throws Exception {
        this.budgetDocument = (BudgetDocument)this.getDocumentService().getNewDocument("BudgetDocument");
        Budget budget = this.budgetDocument.getBudget();
        budget.add(this.createBudgetPeriod(1));
        budget.add(this.createBudgetPeriod(2));
        this.budgetDocument.getDocumentHeader().setDocumentDescription("Budget Document");
        budget.setBudgetVersionNumber(Integer.valueOf(1));
        budget.setStartDate(this.getNowDate());
        budget.setEndDate(this.getNowDate());
        budget.setOhRateClassCode("1");
        budget.setUrRateClassCode("2");
        budget.setModularBudgetFlag(Boolean.valueOf(false));
        this.getDocumentService().saveDocument((Document)this.budgetDocument);
        this.budgetDocument = (BudgetDocument)this.getDocumentService().getByDocumentHeaderId(this.budgetDocument.getDocumentNumber());
    }

    private void initializeAndSaveSingleInstance() throws WorkflowException, Exception {
        BudgetDistributionAndIncomeComponent component = this.createBudgetDistributionAndIncomeComponent();
        this.addBudgetDistributionAndIncomeComponent(component);
        this.getDocumentService().saveDocument((Document)this.budgetDocument);
    }

    private void initProposalDocument() throws Exception {
        this.proposalDocument = (ProposalDevelopmentDocument)this.getDocumentService().getNewDocument("ProposalDevelopmentDocument");
        this.proposalDocument.getDocumentHeader().setDocumentDescription("ProposalDevelopmentDocumentTest test doc");
        this.proposalDocument.getDevelopmentProposal().setSponsorCode("005770");
        this.proposalDocument.getDevelopmentProposal().setTitle("project title");
        this.proposalDocument.getDevelopmentProposal().setRequestedStartDateInitial(this.getNowDate());
        this.proposalDocument.getDevelopmentProposal().setRequestedEndDateInitial(this.getNowDate());
        this.proposalDocument.getDevelopmentProposal().setActivityTypeCode("1");
        this.proposalDocument.getDevelopmentProposal().setProposalTypeCode("1");
        this.proposalDocument.getDevelopmentProposal().setOwnedByUnitNumber("000001");
        this.proposalDevelopmentService.initializeUnitOrganizationLocation(this.proposalDocument);
        this.proposalDevelopmentService.initializeProposalSiteNumbers(this.proposalDocument);
        this.getDocumentService().saveDocument((Document)this.proposalDocument);
        this.proposalDocument = (ProposalDevelopmentDocument)this.getDocumentService().getByDocumentHeaderId(this.proposalDocument.getDocumentNumber());
    }

    private BudgetDocument loadDocumentAndCheckSingleComponentSaved() throws WorkflowException, Exception {
        BudgetDocument savedDocument = (BudgetDocument)this.getDocumentService().getByDocumentHeaderId(this.budgetDocument.getDocumentNumber());
        BudgetDistributionAndIncomeIntegrationTest.assertNotNull((Object)savedDocument);
        BudgetDistributionAndIncomeIntegrationTest.assertEquals((long)1L, (long)this.getBudgetDistributionAndIncomeComponents(savedDocument).size());
        return savedDocument;
    }

    private BudgetDocument saveBudgetDistributionAndIncomeComponentCollection(BudgetDistributionAndIncomeComponent[] components) throws Exception {
        for (BudgetDistributionAndIncomeComponent component : components) {
            this.addBudgetDistributionAndIncomeComponent(component);
        }
        this.getDocumentService().saveDocument((Document)this.budgetDocument);
        return (BudgetDocument)this.getDocumentService().getByDocumentHeaderId(this.budgetDocument.getDocumentNumber());
    }
}

