/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.bo;

import java.sql.Date;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.junit.After;
import org.junit.Before;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.distributionincome.BudgetDistributionAndIncomeService;
import org.kuali.kra.budget.distributionincome.BudgetDistributionAndIncomeServiceImpl;
import org.kuali.kra.budget.parameters.BudgetPeriod;

public abstract class BudgetDistributionAndIncomeTest {
    protected static final BudgetDecimal FY_2007_Q3_AMT = new BudgetDecimal(100.0);
    protected static final BudgetDecimal FY_2007_Q4_AMT = BudgetDecimal.ZERO;
    protected static final BudgetDecimal FY_2008_Q1_AMT = new BudgetDecimal(200.0);
    protected static final BudgetDecimal FY_2008_Q2_AMT = new BudgetDecimal(300.0);
    protected static final BudgetDecimal FY_2009_Q1_AMT = new BudgetDecimal(400.0);
    protected static final BudgetDecimal FY_2009_Q2_AMT = new BudgetDecimal(500.0);
    protected static final int DAY_1 = 1;
    protected static final int DAY_2 = 2;
    protected static final int DAY_30 = 30;
    protected static final int YEAR_2000 = 2000;
    protected static final int YEAR_2007 = 2007;
    protected static final int YEAR_2008 = 2008;
    protected static final int YEAR_2009 = 2009;
    protected BudgetDecimal[] costShareAmounts = new BudgetDecimal[]{FY_2007_Q3_AMT, FY_2007_Q4_AMT, FY_2008_Q1_AMT, FY_2008_Q2_AMT, FY_2009_Q1_AMT, FY_2009_Q2_AMT};
    protected BudgetDecimal[] unrecoveredFandAAmounts = new BudgetDecimal[]{FY_2007_Q3_AMT, FY_2007_Q4_AMT, FY_2008_Q1_AMT, FY_2008_Q2_AMT, FY_2009_Q1_AMT, FY_2009_Q2_AMT};
    protected Budget budgetDocument;
    protected Calendar calendar;
    protected BudgetDistributionAndIncomeService budgetDistributionAndIncomeService;
    private Date fiscalYearStartArtifact;

    @Before
    public void setUp() throws Exception {
        this.calendar = GregorianCalendar.getInstance();
        this.fiscalYearStartArtifact = this.getDate(2000, 6, 1);
        this.budgetDocument = new BudgetDocument_CostShareAndUnrecoveredFandAApplicable();
        this.budgetDistributionAndIncomeService = new BudgetDistributionAndIncomeServiceImpl();
    }

    @After
    public void tearDown() throws Exception {
        this.budgetDocument = null;
        this.calendar = null;
        this.budgetDistributionAndIncomeService = null;
    }

    protected BudgetPeriod createAndAddBudgetPeriod(Date startDate, Date endDate) {
        BudgetPeriod budgetPeriod = new BudgetPeriod();
        budgetPeriod.setStartDate(startDate);
        budgetPeriod.setEndDate(endDate);
        this.budgetDocument.add(budgetPeriod);
        return budgetPeriod;
    }

    protected Date getDate(int year, int month, int date) {
        this.calendar.set(year, month, date);
        return new Date(this.calendar.getTimeInMillis());
    }

    protected BudgetPeriod createAndAddBudgetPeriod() {
        BudgetPeriod budgetPeriod = new BudgetPeriod();
        this.budgetDocument.add(budgetPeriod);
        return budgetPeriod;
    }

    protected void createBudgetPeriodsForThreeFiscalYears() {
        this.createAndAddBudgetPeriod(this.getDate(2007, 0, 1), this.getDate(2007, 2, 30));
        this.createAndAddBudgetPeriod(this.getDate(2007, 3, 1), this.getDate(2007, 5, 30));
        this.createAndAddBudgetPeriod(this.getDate(2007, 6, 1), this.getDate(2007, 8, 30));
        this.createAndAddBudgetPeriod(this.getDate(2007, 9, 1), this.getDate(2007, 11, 30));
        this.createAndAddBudgetPeriod(this.getDate(2008, 9, 1), this.getDate(2008, 11, 30));
        this.createAndAddBudgetPeriod(this.getDate(2008, 9, 2), this.getDate(2009, 5, 30));
        int i = 0;
        for (BudgetPeriod bp : this.budgetDocument.getBudgetPeriods()) {
            bp.setCostSharingAmount(this.costShareAmounts[i]);
            bp.setUnderrecoveryAmount(this.unrecoveredFandAAmounts[i]);
            ++i;
        }
    }

    public class BudgetDocument_CostShareAndUnrecoveredFandANotApplicable
    extends Budget_TestRoot {
        private static final long serialVersionUID = 1L;

        protected Boolean loadCostSharingApplicability() {
            return Boolean.FALSE;
        }

        public Date loadFiscalYearStart() {
            return BudgetDistributionAndIncomeTest.this.fiscalYearStartArtifact;
        }

        protected Boolean loadUnrecoveredFandAApplicability() {
            return Boolean.FALSE;
        }
    }

    public class BudgetDocument_CostShareAndUnrecoveredFandAApplicable
    extends Budget_TestRoot {
        private static final long serialVersionUID = 1L;

        protected Boolean loadCostSharingApplicability() {
            return Boolean.TRUE;
        }

        public Date loadFiscalYearStart() {
            return BudgetDistributionAndIncomeTest.this.fiscalYearStartArtifact;
        }

        protected Boolean loadUnrecoveredFandAApplicability() {
            return Boolean.TRUE;
        }

        protected void setCostShareApplicability(Boolean value) {
        }
    }

    public class Budget_TestRoot
    extends Budget {
        private Integer nextVal = 1;

        public Integer getHackedDocumentNextValue(String key) {
            Integer n = this.nextVal;
            Integer n2 = this.nextVal = Integer.valueOf(this.nextVal + 1);
            return n;
        }
    }
}

