/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.bo;

import java.sql.Date;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.budget.parameters.BudgetPeriod;

public class BudgetPeriodTest {
    private static final int DAY_1 = 1;
    private static final int DAY_30 = 30;
    private static final int YEAR_2000 = 2000;
    private static final int YEAR_2007 = 2007;
    private static final int YEAR_2008 = 2008;
    private static final int YEAR_2009 = 2009;
    private static final int YEAR_2010 = 2010;
    private Calendar calendar;
    private BudgetPeriod budgetPeriod;
    private Date fiscalYearStart;

    @Test
    public void testFindingFiscalYear_PriorCalendarYearBeforeFiscalCutoff() throws Exception {
        this.budgetPeriod.setStartDate(this.getDate(2007, 0, 1));
        this.budgetPeriod.setEndDate(this.getDate(2007, 2, 30));
        Assert.assertEquals((long)2007L, (long)this.budgetPeriod.calculateFiscalYear(this.fiscalYearStart));
    }

    @Test
    public void testFindingFiscalYear_SameCalendarYearBeforeFiscalCutoff() throws Exception {
        this.budgetPeriod.setStartDate(this.getDate(2007, 2, 1));
        this.budgetPeriod.setEndDate(this.getDate(2007, 5, 30));
        Assert.assertEquals((long)2007L, (long)this.budgetPeriod.calculateFiscalYear(this.fiscalYearStart));
    }

    @Test
    public void testFindingFiscalYear_AtFiscalYearBeginning() throws Exception {
        this.budgetPeriod.setStartDate(this.getDate(2008, 6, 1));
        this.budgetPeriod.setEndDate(this.getDate(2008, 11, 30));
        Assert.assertEquals((long)2009L, (long)this.budgetPeriod.calculateFiscalYear(this.fiscalYearStart));
    }

    @Test
    public void testFindingFiscalYear_NextCalendarYearBeforeFiscalCutoff() throws Exception {
        this.budgetPeriod.setStartDate(this.getDate(2009, 5, 1));
        this.budgetPeriod.setEndDate(this.getDate(2009, 5, 30));
        Assert.assertEquals((long)2009L, (long)this.budgetPeriod.calculateFiscalYear(this.fiscalYearStart));
    }

    @Test
    public void testFindingFiscalYear_NextCalendarYearAfterFiscalCutoff() throws Exception {
        this.budgetPeriod.setStartDate(this.getDate(2009, 6, 1));
        this.budgetPeriod.setEndDate(this.getDate(2009, 6, 30));
        Assert.assertEquals((long)2010L, (long)this.budgetPeriod.calculateFiscalYear(this.fiscalYearStart));
    }

    @Test
    public void testFindingFiscalYear_PeriodSpansFiscalYearBoundary() throws Exception {
        this.budgetPeriod.setStartDate(this.getDate(2008, 5, 1));
        this.budgetPeriod.setEndDate(this.getDate(2008, 6, 30));
        Assert.assertEquals((long)2008L, (long)this.budgetPeriod.calculateFiscalYear(this.fiscalYearStart));
    }

    @Test
    public void testFindingFiscalYear_NullFiscalYearStartDate() throws Exception {
        Assert.assertEquals((long)0L, (long)this.budgetPeriod.calculateFiscalYear(null));
    }

    @Test
    public void testFindingFiscalYear_NullStartDate() throws Exception {
        this.budgetPeriod.setStartDate(null);
        Assert.assertEquals((long)0L, (long)this.budgetPeriod.calculateFiscalYear(this.fiscalYearStart));
    }

    @Test
    public void testIfBudgetPeriodIsReadOnly() throws Exception {
        this.budgetPeriod.setBudgetPeriod(Integer.valueOf(1));
        this.budgetPeriod.getBudgetLineItems().clear();
        Assert.assertFalse((boolean)this.budgetPeriod.isReadOnly());
        this.budgetPeriod.setBudgetPeriod(Integer.valueOf(1));
        this.budgetPeriod.getBudgetLineItems().add(this.budgetPeriod.getNewBudgetLineItem());
        Assert.assertTrue((boolean)this.budgetPeriod.isReadOnly());
        this.budgetPeriod.setBudgetPeriod(Integer.valueOf(2));
        this.budgetPeriod.getBudgetLineItems().clear();
        Assert.assertFalse((boolean)this.budgetPeriod.isReadOnly());
        this.budgetPeriod.setBudgetPeriod(Integer.valueOf(2));
        this.budgetPeriod.getBudgetLineItems().add(this.budgetPeriod.getNewBudgetLineItem());
        Assert.assertTrue((boolean)this.budgetPeriod.isReadOnly());
    }

    @Before
    public void setUp() {
        this.calendar = GregorianCalendar.getInstance();
        this.budgetPeriod = new BudgetPeriod();
        this.fiscalYearStart = this.getDate(2000, 6, 1);
    }

    @After
    public void tearDown() {
        this.fiscalYearStart = null;
        this.budgetPeriod = null;
        this.calendar = null;
    }

    private Date getDate(int year, int month, int date) {
        this.calendar.set(year, month, date);
        return new Date(this.calendar.getTimeInMillis());
    }
}

