/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.bo;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.distributionincome.BudgetProjectIncome;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.util.DateUtils;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class BudgetProjectIncomeTest {
    private static final double _1K = 1000.0;
    private static final double _2K = 2000.0;
    private static final double _3K = 3000.0;
    private static final double _4K = 4000.0;
    private static final double _500 = 500.0;
    private Budget document;
    private int nextValue = 1;

    @Before
    public void setUp() throws Exception {
        this.initializeDocument();
        this.document.add(this.createBudgetProjectIncome(this.document.getBudgetPeriod(0), 1000.0));
        this.document.add(this.createBudgetProjectIncome(this.document.getBudgetPeriod(1), 2000.0));
        this.document.add(this.createBudgetProjectIncome(this.document.getBudgetPeriod(2), 3000.0));
        this.document.add(this.createBudgetProjectIncome(this.document.getBudgetPeriod(2), 500.0));
        this.document.add(this.createBudgetProjectIncome(this.document.getBudgetPeriod(3), 4000.0));
        this.document.add(this.createBudgetProjectIncome(this.document.getBudgetPeriod(3), 500.0));
        this.document.add(this.createBudgetProjectIncome(this.document.getBudgetPeriod(3), 1000.0));
    }

    @After
    public void tearDown() throws Exception {
        this.document = null;
    }

    @Test
    public void testTotalingProjectIncomesForBudgetDocument() throws Exception {
        Assert.assertEquals((double)12000.0, (double)this.document.getProjectIncomeTotal().doubleValue(), (double)0.01);
        double total = 0.0;
        for (BudgetPeriod bp : this.document.getBudgetPeriods()) {
            total += this.extractPeriodTotal(bp);
        }
        Assert.assertEquals((double)total, (double)this.document.getProjectIncomeTotal().doubleValue(), (double)0.01);
    }

    @Test
    public void testTotalingProjectIncomesForPeriod() throws Exception {
        Assert.assertEquals((long)7L, (long)this.document.getBudgetProjectIncomes().size());
        Assert.assertEquals((long)4L, (long)this.document.getProjectIncomePeriodTotalsForEachBudgetPeriod().size());
        Assert.assertEquals((double)1000.0, (double)this.extractPeriodTotal(this.document.getBudgetPeriod(0)), (double)0.01);
        Assert.assertEquals((double)2000.0, (double)this.extractPeriodTotal(this.document.getBudgetPeriod(1)), (double)0.01);
        Assert.assertEquals((double)3500.0, (double)this.extractPeriodTotal(this.document.getBudgetPeriod(2)), (double)0.01);
        Assert.assertEquals((double)5500.0, (double)this.extractPeriodTotal(this.document.getBudgetPeriod(3)), (double)0.01);
    }

    private BudgetProjectIncome createBudgetProjectIncome(BudgetPeriod budgetPeriod, double amount) {
        BudgetProjectIncome budgetProjectIncome = new BudgetProjectIncome();
        budgetProjectIncome.setBudgetPeriodNumber(budgetPeriod.getBudgetPeriod());
        budgetProjectIncome.setProjectIncome(new KualiDecimal(amount));
        return budgetProjectIncome;
    }

    private double extractPeriodTotal(BudgetPeriod budgetPeriod) {
        return ((KualiDecimal)this.document.getProjectIncomePeriodTotalsForEachBudgetPeriod().get(budgetPeriod.getBudgetPeriod() - 1)).doubleValue();
    }

    private void initializeDocument() {
        this.document = new Budget(){

            public Integer getHackedDocumentNextValue(String propertyName) {
                return BudgetProjectIncomeTest.this.nextValue++;
            }
        };
        this.document.add(this.createBudgetPeriod(1, 2007));
        this.document.add(this.createBudgetPeriod(2, 2008));
        this.document.add(this.createBudgetPeriod(3, 2009));
        this.document.add(this.createBudgetPeriod(4, 2010));
    }

    private BudgetPeriod createBudgetPeriod(int budgetPeriodNumber, int year) {
        BudgetPeriod budgetPeriod = new BudgetPeriod();
        budgetPeriod.setBudgetPeriod(Integer.valueOf(budgetPeriodNumber));
        budgetPeriod.setStartDate(DateUtils.newDate((Integer)year, (Integer)0, (Integer)1, (Integer)0, (Integer)0, (Integer)0));
        budgetPeriod.setEndDate(DateUtils.newDate((Integer)year, (Integer)11, (Integer)31, (Integer)23, (Integer)59, (Integer)59));
        return budgetPeriod;
    }
}

