/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.bo;

import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.bo.BudgetDistributionAndIncomeTest;
import org.kuali.kra.budget.core.Budget;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;

public class BudgetUnrecoveredFandATest
extends BudgetDistributionAndIncomeTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testCalculatingTotalUnrecoveredFandA() {
        this.createAndAddBudgetPeriod().setUnderrecoveryAmount(FY_2007_Q3_AMT);
        Assert.assertEquals((Object)FY_2007_Q3_AMT, (Object)this.budgetDocument.getAvailableUnrecoveredFandA());
        this.createAndAddBudgetPeriod().setUnderrecoveryAmount(FY_2007_Q4_AMT);
        Assert.assertEquals((Object)FY_2007_Q3_AMT.add((AbstractKualiDecimal)FY_2007_Q4_AMT), (Object)this.budgetDocument.getAvailableUnrecoveredFandA());
        this.createAndAddBudgetPeriod().setUnderrecoveryAmount(FY_2008_Q1_AMT);
        Assert.assertEquals((Object)((BudgetDecimal)FY_2007_Q3_AMT.add((AbstractKualiDecimal)FY_2007_Q4_AMT)).add((AbstractKualiDecimal)FY_2008_Q1_AMT), (Object)this.budgetDocument.getAvailableUnrecoveredFandA());
        Assert.assertTrue((boolean)this.budgetDocument.isUnrecoveredFandAAvailable());
    }

    @Test
    public void testIfUnrecoveredFandAApplicable_UnrecoveredAmountsPresentAndApplicable() {
        this.createAndAddBudgetPeriod().setUnderrecoveryAmount(FY_2007_Q3_AMT);
        this.createAndAddBudgetPeriod().setUnderrecoveryAmount(BudgetDecimal.ZERO);
        this.createAndAddBudgetPeriod().setUnderrecoveryAmount(FY_2008_Q1_AMT);
        Assert.assertTrue((boolean)this.budgetDocument.isUnrecoveredFandAApplicable());
    }

    @Test
    public void testIfUnrecoveredFandAApplicable_UnrecoveredAmountsPresentAndNotApplicable() {
        this.budgetDocument = new BudgetDistributionAndIncomeTest.BudgetDocument_CostShareAndUnrecoveredFandANotApplicable();
        this.createAndAddBudgetPeriod().setUnderrecoveryAmount(FY_2007_Q3_AMT);
        this.createAndAddBudgetPeriod().setUnderrecoveryAmount(FY_2007_Q4_AMT);
        this.createAndAddBudgetPeriod().setUnderrecoveryAmount(FY_2008_Q1_AMT);
        Assert.assertFalse((boolean)this.budgetDocument.isUnrecoveredFandAApplicable());
    }

    @Test
    public void testIfUnrecoveredFandAIsAvailable_BudgetPeriodPresentWithNonZeroUnrecovery() {
        Assert.assertFalse((boolean)this.budgetDocument.isUnrecoveredFandAAvailable());
        this.createAndAddBudgetPeriod().setUnderrecoveryAmount(FY_2007_Q3_AMT);
        Assert.assertTrue((boolean)this.budgetDocument.isUnrecoveredFandAAvailable());
    }

    @Test
    public void testIfUnrecoveredFandAIsAvailable_BudgetPeriodPresentButNoUnrecoveredFandA() {
        Assert.assertFalse((boolean)this.budgetDocument.isUnrecoveredFandAAvailable());
    }

    @Test
    public void testFindingUnrecoveredFandAForFiscalYear() throws Exception {
        this.createBudgetPeriodsForThreeFiscalYears();
        Assert.assertEquals((Object)FY_2007_Q3_AMT.add((AbstractKualiDecimal)FY_2007_Q4_AMT), (Object)this.budgetDocument.findUnrecoveredFandAForFiscalYear(Integer.valueOf(2007)));
        Assert.assertEquals((Object)FY_2008_Q1_AMT.add((AbstractKualiDecimal)FY_2008_Q2_AMT), (Object)this.budgetDocument.findUnrecoveredFandAForFiscalYear(Integer.valueOf(2008)));
        Assert.assertEquals((Object)FY_2009_Q1_AMT.add((AbstractKualiDecimal)FY_2009_Q2_AMT), (Object)this.budgetDocument.findUnrecoveredFandAForFiscalYear(Integer.valueOf(2009)));
        Assert.assertEquals((Object)BudgetDecimal.ZERO, (Object)this.budgetDocument.findUnrecoveredFandAForFiscalYear(Integer.valueOf(2000)));
    }

    @Test
    public void testGettingFiscalYearUnrecoveredFandATotals() {
        this.createBudgetPeriodsForThreeFiscalYears();
        List fiscalYearUnrecoveredFandATotals = this.budgetDocument.getFiscalYearUnrecoveredFandATotals();
        Assert.assertEquals((long)3L, (long)fiscalYearUnrecoveredFandATotals.size());
        Budget.FiscalYearSummary fiscalYearSummary = (Budget.FiscalYearSummary)fiscalYearUnrecoveredFandATotals.get(0);
        Assert.assertEquals((long)2007L, (long)fiscalYearSummary.getFiscalYear());
        Assert.assertEquals((Object)this.getDate(2007, 0, 1), (Object)fiscalYearSummary.getAssignedBudgetPeriod().getStartDate());
        Assert.assertEquals((Object)FY_2007_Q3_AMT.add((AbstractKualiDecimal)FY_2007_Q4_AMT), (Object)fiscalYearSummary.getUnrecoveredFandA());
        fiscalYearSummary = (Budget.FiscalYearSummary)fiscalYearUnrecoveredFandATotals.get(1);
        Assert.assertEquals((long)2008L, (long)fiscalYearSummary.getFiscalYear());
        Assert.assertEquals((Object)this.getDate(2007, 6, 1), (Object)fiscalYearSummary.getAssignedBudgetPeriod().getStartDate());
        Assert.assertEquals((Object)FY_2008_Q1_AMT.add((AbstractKualiDecimal)FY_2008_Q2_AMT), (Object)fiscalYearSummary.getUnrecoveredFandA());
        fiscalYearSummary = (Budget.FiscalYearSummary)fiscalYearUnrecoveredFandATotals.get(2);
        Assert.assertEquals((long)2009L, (long)fiscalYearSummary.getFiscalYear());
        Assert.assertEquals((Object)this.getDate(2008, 9, 1), (Object)fiscalYearSummary.getAssignedBudgetPeriod().getStartDate());
        Assert.assertEquals((Object)FY_2009_Q1_AMT.add((AbstractKualiDecimal)FY_2009_Q2_AMT), (Object)fiscalYearSummary.getUnrecoveredFandA());
    }
}

