/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.calculator;

import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.calculator.Boundary;
import org.kuali.kra.budget.calculator.BreakUpInterval;
import org.kuali.kra.budget.calculator.BreakupIntervalService;
import org.kuali.kra.budget.calculator.QueryList;
import org.kuali.kra.budget.calculator.RateAndCost;
import org.kuali.kra.budget.rates.BudgetLaRate;
import org.kuali.kra.budget.rates.BudgetRate;
import org.kuali.kra.budget.rates.RateClass;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;

public class BreakupIntervalServiceTest
extends KcUnitTestBase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testCalculate() {
        BreakUpInterval bi = this.createBreakupInterval();
        ((BreakupIntervalService)KraServiceLocator.getService(BreakupIntervalService.class)).calculate(bi);
        QueryList rateAndCosts = bi.getRateAndCosts();
        RateAndCost rateAndCost1 = (RateAndCost)rateAndCosts.get(0);
        this.validateResults(rateAndCost1, 3375.0, 675.0, 6750.0, 1350.0);
        RateAndCost rateAndCost2 = (RateAndCost)rateAndCosts.get(1);
        this.validateResults(rateAndCost2, 1250.0, 250.0, 5000.0, 1000.0);
        RateAndCost rateAndCost3 = (RateAndCost)rateAndCosts.get(2);
        this.validateResults(rateAndCost3, 500.0, 100.0, 5000.0, 1000.0);
        RateAndCost rateAndCost4 = (RateAndCost)rateAndCosts.get(3);
        this.validateResults(rateAndCost4, 250.0, 50.0, 5000.0, 1000.0);
        RateAndCost rateAndCost5 = (RateAndCost)rateAndCosts.get(6);
        this.validateResults(rateAndCost5, 7.5, 1.5, 250.0, 50.0);
        RateAndCost rateAndCost6 = (RateAndCost)rateAndCosts.get(7);
        this.validateResults(rateAndCost6, 5.0, 1.0, 250.0, 50.0);
    }

    private void validateResults(RateAndCost rateAndCost, double calculatedCost, double calculatedCostSharing, double baseAmount, double baseCostSharing) {
        BreakupIntervalServiceTest.assertEquals((Object)rateAndCost.getCalculatedCost(), (Object)new BudgetDecimal(calculatedCost));
        BreakupIntervalServiceTest.assertEquals((Object)rateAndCost.getCalculatedCostSharing(), (Object)new BudgetDecimal(calculatedCostSharing));
        BreakupIntervalServiceTest.assertEquals((Object)rateAndCost.getBaseAmount(), (Object)new BudgetDecimal(baseAmount));
        BreakupIntervalServiceTest.assertEquals((Object)rateAndCost.getBaseCostSharingAmount(), (Object)new BudgetDecimal(baseCostSharing));
    }

    @Test
    public void testCalculateWithApplyFlag() {
        BreakUpInterval bi = this.createBreakupInterval();
        RateAndCost rc = (RateAndCost)bi.getRateAndCosts().get(1);
        rc.setApplyRateFlag(Boolean.valueOf(false));
        ((RateAndCost)bi.getRateAndCosts().get(2)).setApplyRateFlag(Boolean.valueOf(false));
        ((BreakupIntervalService)KraServiceLocator.getService(BreakupIntervalService.class)).calculate(bi);
        QueryList rateAndCosts = bi.getRateAndCosts();
        RateAndCost rateAndCost1 = (RateAndCost)rateAndCosts.get(0);
        this.validateResults(rateAndCost1, 2500.0, 500.0, 5000.0, 1000.0);
        RateAndCost rateAndCost2 = (RateAndCost)rateAndCosts.get(1);
        this.validateResults(rateAndCost2, 0.0, 0.0, 0.0, 0.0);
        RateAndCost rateAndCost3 = (RateAndCost)rateAndCosts.get(2);
        this.validateResults(rateAndCost3, 0.0, 0.0, 0.0, 0.0);
        RateAndCost rateAndCost4 = (RateAndCost)rateAndCosts.get(3);
        this.validateResults(rateAndCost4, 250.0, 50.0, 5000.0, 1000.0);
        RateAndCost rateAndCost5 = (RateAndCost)rateAndCosts.get(6);
        this.validateResults(rateAndCost5, 7.5, 1.5, 250.0, 50.0);
        RateAndCost rateAndCost6 = (RateAndCost)rateAndCosts.get(7);
        this.validateResults(rateAndCost6, 5.0, 1.0, 250.0, 50.0);
    }

    @Test
    public void testCalculateOverrecovery() {
        BreakUpInterval bi1 = this.createBreakupInterval();
        bi1.setURRatesBean(this.getBudgetRate("1", 40.0, 1L, "2011", 40.0, true, "1", "2", "O", "07/01/2009", "000001"));
        ((BreakupIntervalService)KraServiceLocator.getService(BreakupIntervalService.class)).calculate(bi1);
        BreakupIntervalServiceTest.assertEquals((Object)bi1.getUnderRecovery(), (Object)new BudgetDecimal(-810.0));
    }

    @Test
    public void testCalculateUnderrecoveryWithApplyFlag() {
        BreakUpInterval bi = this.createBreakupInterval();
        RateAndCost ohRateItem = (RateAndCost)bi.getRateAndCosts().get(0);
        ohRateItem.setApplyRateFlag(Boolean.valueOf(false));
        ((BreakupIntervalService)KraServiceLocator.getService(BreakupIntervalService.class)).calculate(bi);
        BreakupIntervalServiceTest.assertEquals((Object)bi.getUnderRecovery(), (Object)new BudgetDecimal(4050.0));
    }

    private BreakUpInterval createBreakupInterval() {
        BreakUpInterval bi1 = new BreakUpInterval();
        bi1.setApplicableAmt(new BudgetDecimal(5000));
        bi1.setApplicableAmtCostSharing(new BudgetDecimal(1000));
        bi1.setBoundary(new Boundary(this.getDate("01/01/2010"), this.getDate("06/30/2010")));
        bi1.setBudgetPeriod(1);
        bi1.setBudgetId(Long.valueOf(1L));
        bi1.setBudgetProposalLaRates(this.getBudgetLArates());
        bi1.setBudgetProposalRates(this.getBudgetRates());
        bi1.setLineItemNumber(1);
        bi1.setRateAndCosts(this.createRateAndCosts());
        bi1.setRateNumber(1);
        return bi1;
    }

    private RateAndCost getRateCost(String rateClassCode, String rateTypeCode, String rateClassType, double rate) {
        RateAndCost rateCost = new RateAndCost();
        rateCost.setApplyRateFlag(Boolean.valueOf(true));
        rateCost.setRateClassType(rateClassType);
        rateCost.setRateClassCode(rateClassCode);
        rateCost.setRateTypeCode(rateTypeCode);
        rateCost.setAppliedRate(new BudgetDecimal(rate));
        rateCost.setCalculatedCost(BudgetDecimal.ZERO);
        rateCost.setCalculatedCostSharing(BudgetDecimal.ZERO);
        return rateCost;
    }

    private QueryList<RateAndCost> createRateAndCosts() {
        QueryList rateAndCosts = new QueryList();
        RateAndCost rc1 = this.getRateCost("1", "1", "O", 50.0);
        rateAndCosts.add((Object)rc1);
        RateAndCost rc2 = this.getRateCost("5", "1", "E", 25.0);
        rateAndCosts.add((Object)rc2);
        RateAndCost rc3 = this.getRateCost("8", "1", "V", 10.0);
        rateAndCosts.add((Object)rc3);
        RateAndCost rc4 = this.getRateCost("10", "1", "Y", 5.0);
        rateAndCosts.add((Object)rc4);
        RateAndCost rc5 = this.getRateCost("11", "1", "L", 5.0);
        rateAndCosts.add((Object)rc5);
        RateAndCost rc6 = this.getRateCost("12", "1", "L", 5.0);
        rateAndCosts.add((Object)rc6);
        RateAndCost rc7 = this.getRateCost("5", "3", "E", 3.0);
        rateAndCosts.add((Object)rc7);
        RateAndCost rc8 = this.getRateCost("8", "2", "V", 2.0);
        rateAndCosts.add((Object)rc8);
        return rateAndCosts;
    }

    private QueryList<BudgetRate> getBudgetRates() {
        QueryList rates = new QueryList();
        BudgetRate brO1 = this.getBudgetRate("1", 50.0, 1L, "2010", 50.0, true, "1", "1", "O", "07/01/2009", "000001");
        BudgetRate brO2 = this.getBudgetRate("1", 45.0, 1L, "2010", 45.0, true, "2", "1", "O", "07/01/2009", "000001");
        BudgetRate brO3 = this.getBudgetRate("1", 40.0, 1L, "2010", 40.0, true, "3", "1", "O", "07/01/2009", "000001");
        BudgetRate brE = this.getBudgetRate("1", 25.0, 1L, "2010", 25.0, true, "5", "1", "E", "07/01/2009", "000001");
        BudgetRate brV = this.getBudgetRate("1", 10.0, 1L, "2010", 10.0, true, "8", "1", "V", "07/01/2009", "000001");
        BudgetRate brELA = this.getBudgetRate("1", 3.0, 1L, "2010", 3.0, true, "5", "3", "E", "07/01/2009", "000001");
        BudgetRate brVLA = this.getBudgetRate("1", 2.0, 1L, "2010", 2.0, true, "8", "2", "V", "07/01/2009", "000001");
        BudgetRate brOt = this.getBudgetRate("1", 8.0, 1L, "2010", 8.0, true, "9", "1", "X", "07/01/2009", "000001");
        rates.add((Object)brO1);
        rates.add((Object)brO2);
        rates.add((Object)brO3);
        rates.add((Object)brE);
        rates.add((Object)brV);
        rates.add((Object)brOt);
        rates.add((Object)brELA);
        rates.add((Object)brVLA);
        return rates;
    }

    private QueryList<BudgetLaRate> getBudgetLArates() {
        QueryList rates = new QueryList();
        BudgetLaRate br7 = this.getBudgetLaRate(5.0, 1L, "2010", 5.0, true, "10", "1", "Y", "07/01/2009", "000001");
        BudgetLaRate br8 = this.getBudgetLaRate(5.0, 1L, "2010", 5.0, true, "11", "1", "L", "07/01/2009", "000001");
        BudgetLaRate br9 = this.getBudgetLaRate(5.0, 1L, "2010", 5.0, true, "12", "1", "L", "07/01/2009", "000001");
        rates.add((Object)br7);
        rates.add((Object)br8);
        rates.add((Object)br9);
        return rates;
    }

    private BudgetRate getBudgetRate(String actCode, double rate, Long bgtId, String year, double instRate, boolean campFlag, String rcCode, String rtCode, String rct, String stDate, String unitNumber) {
        BudgetRate br1 = new BudgetRate();
        br1.setActivityTypeCode(actCode);
        br1.setApplicableRate(new BudgetDecimal(rate));
        br1.setBudgetId(bgtId);
        br1.setFiscalYear(year);
        br1.setInstituteRate(new BudgetDecimal(instRate));
        br1.setOnOffCampusFlag(Boolean.valueOf(campFlag));
        br1.setRateClassCode(rcCode);
        br1.setRateTypeCode(rtCode);
        br1.setRateClass(this.getRateClass(rcCode, rct));
        br1.setStartDate(new Date(this.getDate(stDate).getTime()));
        br1.setUnitNumber(unitNumber);
        return br1;
    }

    private RateClass getRateClass(String rateClassCode, String rateClassType) {
        RateClass rc = new RateClass();
        rc.setRateClassCode(rateClassCode);
        rc.setRateClassType(rateClassType);
        return rc;
    }

    private BudgetLaRate getBudgetLaRate(double rate, Long bgtId, String year, double instRate, boolean campFlag, String rcCode, String rtCode, String rct, String stDate, String unitNumber) {
        BudgetLaRate br1 = new BudgetLaRate();
        br1.setApplicableRate(new BudgetDecimal(rate));
        br1.setBudgetId(bgtId);
        br1.setFiscalYear(year);
        br1.setInstituteRate(new BudgetDecimal(instRate));
        br1.setOnOffCampusFlag(Boolean.valueOf(campFlag));
        br1.setRateClassCode(rcCode);
        br1.setRateTypeCode(rtCode);
        br1.setRateClass(this.getRateClass(rcCode, rct));
        br1.setStartDate(new Date(this.getDate(stDate).getTime()));
        br1.setUnitNumber(unitNumber);
        return br1;
    }

    private java.util.Date getDate(String dateString) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        try {
            return sdf.parse(dateString);
        }
        catch (ParseException e) {
            BreakupIntervalServiceTest.fail((String)(dateString + " is not parsable"));
            return null;
        }
    }
}

