/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.document;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.distributionincome.BudgetCostShare;
import org.kuali.kra.budget.distributionincome.BudgetProjectIncome;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetDocumentRule;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.costshare.CostShareService;
import org.kuali.kra.costshare.CostShareServiceTest;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.coreservice.api.parameter.Parameter;
import org.kuali.rice.coreservice.api.parameter.ParameterContract;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.DocumentService;

public class BudgetDocumentRuleTest
extends KcUnitTestBase {
    BudgetDocument<DevelopmentProposal> budgetDoc;
    BudgetDocumentRule budgetDocRule;
    DocumentService docService;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.docService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
        this.budgetDoc = (BudgetDocument)this.docService.getNewDocument(BudgetDocument.class);
        this.budgetDocRule = new BudgetDocumentRule();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testBudgetProjectIncomeBusinessRule() throws Exception {
        ParameterService ps = (ParameterService)KraServiceLocator.getService(ParameterService.class);
        Parameter parameter = ps.getParameter(CostShareServiceTest.class, "CostShareProjectPeriodNameLabel");
        Parameter.Builder parameterForUpdate = Parameter.Builder.create((ParameterContract)parameter);
        parameterForUpdate.setValue("Fiscal Year");
        ps.updateParameter(parameterForUpdate.build());
        CostShareService costShareService = (CostShareService)KraServiceLocator.getService(CostShareService.class);
        costShareService.getCostShareLabel();
        this.budgetDocRule.setCostShareService(costShareService);
        BudgetDocumentRuleTest.assertTrue((boolean)this.budgetDocRule.processBudgetProjectIncomeBusinessRule(this.budgetDoc));
        for (int i = 0; i < 5; ++i) {
            BudgetCostShare tempCostShare = new BudgetCostShare();
            Integer projectPeriod = 2010 + (i + 1);
            tempCostShare.setProjectPeriod(projectPeriod);
            tempCostShare.setShareAmount(new BudgetDecimal(10000.0));
            this.budgetDoc.getBudget().getBudgetCostShares().add(tempCostShare);
        }
        BudgetDocumentRuleTest.assertEquals((long)5L, (long)this.budgetDoc.getBudget().getBudgetCostShares().size());
        BudgetPeriod budgetPeriod = new BudgetPeriod();
        this.budgetDoc.getBudget().add(budgetPeriod);
        BudgetDocumentRuleTest.assertTrue((boolean)this.budgetDocRule.processBudgetProjectIncomeBusinessRule(this.budgetDoc));
        ((BudgetCostShare)this.budgetDoc.getBudget().getBudgetCostShares().get(0)).setProjectPeriod(null);
        BudgetDocumentRuleTest.assertFalse((boolean)this.budgetDocRule.processBudgetProjectIncomeBusinessRule(this.budgetDoc));
        ((BudgetCostShare)this.budgetDoc.getBudget().getBudgetCostShares().get(0)).setProjectPeriod(Integer.valueOf(1984));
        BudgetDocumentRuleTest.assertTrue((boolean)this.budgetDocRule.processBudgetProjectIncomeBusinessRule(this.budgetDoc));
        ((BudgetCostShare)this.budgetDoc.getBudget().getBudgetCostShares().get(1)).setSourceAccount("abcd1234");
        BudgetDocumentRuleTest.assertTrue((boolean)this.budgetDocRule.processBudgetProjectIncomeBusinessRule(this.budgetDoc));
        ((BudgetCostShare)this.budgetDoc.getBudget().getBudgetCostShares().get(0)).setProjectPeriod(Integer.valueOf(2010));
        BudgetDocumentRuleTest.assertTrue((boolean)this.budgetDocRule.processBudgetProjectIncomeBusinessRule(this.budgetDoc));
        ((BudgetCostShare)this.budgetDoc.getBudget().getBudgetCostShares().get(1)).setProjectPeriod(Integer.valueOf(2010));
        BudgetDocumentRuleTest.assertTrue((boolean)this.budgetDocRule.processBudgetProjectIncomeBusinessRule(this.budgetDoc));
        ((BudgetCostShare)this.budgetDoc.getBudget().getBudgetCostShares().get(1)).setSourceAccount(null);
        BudgetDocumentRuleTest.assertFalse((boolean)this.budgetDocRule.processBudgetProjectIncomeBusinessRule(this.budgetDoc));
        this.budgetDoc.getBudget().getBudgetCostShares().clear();
    }

    @Test
    public void testProjectIncomeValidation() {
        BudgetDocumentRuleTest.assertTrue((boolean)this.budgetDocRule.processBudgetProjectIncomeBusinessRule(this.budgetDoc));
        BudgetProjectIncome projectIncome = new BudgetProjectIncome();
        projectIncome.setProjectIncome(new KualiDecimal(5.0));
        this.budgetDoc.getBudget().getBudgetProjectIncomes().add(projectIncome);
        BudgetDocumentRuleTest.assertTrue((boolean)this.budgetDocRule.processBudgetProjectIncomeBusinessRule(this.budgetDoc));
        this.budgetDoc.getBudget().getBudgetProjectIncome(0).setProjectIncome(new KualiDecimal(0.0));
        BudgetDocumentRuleTest.assertFalse((boolean)this.budgetDocRule.processBudgetProjectIncomeBusinessRule(this.budgetDoc));
        this.budgetDoc.getBudget().getBudgetProjectIncome(0).setProjectIncome(null);
        BudgetDocumentRuleTest.assertFalse((boolean)this.budgetDocRule.processBudgetProjectIncomeBusinessRule(this.budgetDoc));
    }
}

