/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.personnel;

import java.sql.Date;
import java.util.Calendar;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.PersonAppointment;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.budget.personnel.BudgetPerson;
import org.kuali.kra.budget.personnel.BudgetPersonService;
import org.kuali.kra.budget.personnel.BudgetPersonServiceImpl;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;

public class BudgetPersonServiceTest
extends KcUnitTestBase {
    protected static final String testAppointmentPersonId = "10000000033";
    protected static final String testOtherPersonId = "10000000034";
    protected BudgetPersonServiceImpl budgetPersonService;
    protected KcPersonService kcPersonService;
    protected Budget budget;
    protected Date startDate;
    protected Date endDate;

    @Override
    @Before
    public void setUp() throws Exception {
        this.kcPersonService = (KcPersonService)KraServiceLocator.getService(KcPersonService.class);
        this.budgetPersonService = (BudgetPersonServiceImpl)KraServiceLocator.getService(BudgetPersonService.class);
        this.budget = new Budget(){
            int nextVal = 1;

            public Integer getHackedDocumentNextValue(String documentComponentIdKey) {
                return this.nextVal++;
            }
        };
        this.budget.setBudgetDocument(new BudgetDocument());
        ProposalDevelopmentDocument parentDoc = new ProposalDevelopmentDocument();
        this.budget.getBudgetDocument().setParentDocument((BudgetParentDocument)parentDoc);
        this.startDate = this.createDate(2010, 1, 1);
        this.endDate = this.createDate(2010, 12, 30);
        this.budget.setStartDate(this.startDate);
        this.budget.setEndDate(this.endDate);
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testAddBudgetPersonWithAppointments() throws Exception {
        BudgetPersonServiceTest.assertTrue((boolean)this.budget.getBudgetPersons().isEmpty());
        BudgetPerson testPerson = new BudgetPerson();
        KcPerson person = this.kcPersonService.getKcPersonByPersonId(testAppointmentPersonId);
        testPerson.setPersonId(testAppointmentPersonId);
        this.budgetPersonService.addBudgetPerson(this.budget, testPerson);
        BudgetPersonServiceTest.assertFalse((boolean)person.getExtendedAttributes().getPersonAppointments().isEmpty());
        BudgetPersonServiceTest.assertTrue((person.getExtendedAttributes().getPersonAppointments().size() == this.budget.getBudgetPersons().size() ? 1 : 0) != 0);
    }

    @Test
    public void testAddBudgetPerson() throws Exception {
        BudgetPersonServiceTest.assertTrue((boolean)this.budget.getBudgetPersons().isEmpty());
        BudgetPerson testPerson = new BudgetPerson();
        testPerson.setPersonId(testOtherPersonId);
        this.budgetPersonService.addBudgetPerson(this.budget, testPerson);
        BudgetPersonServiceTest.assertTrue((this.budget.getBudgetPersons().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testIsAppointmentApplicableToBudget() {
        PersonAppointment appointment = new PersonAppointment();
        appointment.setStartDate(this.createDate(2000, 1, 1));
        BudgetPersonServiceTest.assertTrue((boolean)this.budgetPersonService.isAppointmentApplicableToBudget(this.budget, appointment));
        appointment.setEndDate(this.createDate(2009, 1, 1));
        BudgetPersonServiceTest.assertFalse((boolean)this.budgetPersonService.isAppointmentApplicableToBudget(this.budget, appointment));
        appointment.setEndDate(this.createDate(2020, 1, 1));
        BudgetPersonServiceTest.assertTrue((boolean)this.budgetPersonService.isAppointmentApplicableToBudget(this.budget, appointment));
        appointment.setStartDate(this.createDate(2019, 1, 1));
        BudgetPersonServiceTest.assertFalse((boolean)this.budgetPersonService.isAppointmentApplicableToBudget(this.budget, appointment));
    }

    public Date createDate(int year, int month, int date) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, date);
        return new Date(cal.getTime().getTime());
    }
}

