/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.rules;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetDocumentContainer;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public abstract class AddBudgetDistributionAndIncomeTest {
    protected BudgetDocument document;

    protected abstract void addArtifactToDocument(Object var1);

    protected abstract Object generateReferenceArtifact();

    protected abstract Object generateDifferentArtifact();

    protected abstract Object generateEmptyArtifact();

    protected abstract Object generateRuleEvent(Object var1);

    protected abstract boolean processRules(Object var1);

    @Before
    public void setUp() {
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        this.document = new MockBudgetDocument();
        KNSGlobalVariables.setKualiForm((KualiForm)new MockBudgetForm(this.document));
        this.addArtifactToDocument(this.generateReferenceArtifact());
    }

    @After
    public void tearDown() {
        GlobalVariables.clear();
        this.document = null;
        KNSGlobalVariables.setKualiForm(null);
    }

    @Test
    public void testAdding_AllNulls() throws Exception {
        Object ruleEvent = this.generateRuleEvent(this.generateEmptyArtifact());
        Assert.assertTrue((boolean)this.processRules(ruleEvent));
    }

    @Test
    public void testAdding_DuplicateElement() throws Exception {
        Object ruleEvent = this.generateRuleEvent(this.generateReferenceArtifact());
        Assert.assertFalse((boolean)this.processRules(ruleEvent));
    }

    @Test
    public void testAdding_NotDuplicateElement() throws Exception {
        Object ruleEvent = this.generateRuleEvent(this.generateDifferentArtifact());
        Assert.assertTrue((boolean)this.processRules(ruleEvent));
    }

    private class MockBudgetForm
    extends KualiForm
    implements BudgetDocumentContainer {
        private BudgetDocument document;

        public MockBudgetForm(BudgetDocument document) {
            this.document = document;
        }

        public BudgetDocument getBudgetDocument() {
            return this.document;
        }

        public void setDocument(BudgetDocument document) {
            this.document = document;
        }
    }

    private class MockBudgetDocument
    extends BudgetDocument {
        private MockBudgetDocument() {
        }

        public void refreshReferenceObject(String referenceObjectName) {
        }
    }
}

