/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.rules;

import java.util.Properties;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.budget.distributionincome.AddBudgetProjectIncomeEvent;
import org.kuali.kra.budget.distributionincome.AddBudgetProjectIncomeRule;
import org.kuali.kra.budget.distributionincome.BudgetProjectIncome;
import org.kuali.kra.budget.distributionincome.BudgetProjectIncomeRuleImpl;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.springframework.util.AutoPopulatingList;

public class AddBudgetProjectIncomeRuleTest {
    private static final KualiDecimal PROJECT_INCOME_AMOUNT = new KualiDecimal(100.0);
    private static final int BUDGET_PERIOD_NO = 1;
    private AddBudgetProjectIncomeRule addBudgetProjectIncomeRule;
    private BudgetProjectIncome budgetProjectIncome;
    private AddBudgetProjectIncomeEvent addBudgetIncomeEvent;

    @Test
    public void testValidatingRequiredFields_NoneSet() throws Exception {
        Assert.assertFalse((boolean)this.addBudgetProjectIncomeRule.processAddBudgetProjectIncomeBusinessRules(this.addBudgetIncomeEvent));
        Assert.assertEquals((long)3L, (long)GlobalVariables.getMessageMap().getErrorMessages().keySet().size());
    }

    @Test
    public void testValidatingRequiredFields_DescriptionFilledWithWhiteSpace() throws Exception {
        this.budgetProjectIncome.setBudgetPeriodNumber(Integer.valueOf(1));
        this.budgetProjectIncome.setProjectIncome(PROJECT_INCOME_AMOUNT);
        this.budgetProjectIncome.setDescription("  ");
        Assert.assertFalse((boolean)this.addBudgetProjectIncomeRule.processAddBudgetProjectIncomeBusinessRules(this.addBudgetIncomeEvent));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorMessages().keySet().size());
    }

    @Test
    public void testValidatingRequiredFields_AllRequiredFieldsFilled() throws Exception {
        this.budgetProjectIncome.setBudgetPeriodNumber(Integer.valueOf(1));
        this.budgetProjectIncome.setProjectIncome(PROJECT_INCOME_AMOUNT);
        this.budgetProjectIncome.setDescription("Description");
        Assert.assertTrue((boolean)this.addBudgetProjectIncomeRule.processAddBudgetProjectIncomeBusinessRules(this.addBudgetIncomeEvent));
        Assert.assertEquals((long)0L, (long)GlobalVariables.getMessageMap().getErrorMessages().keySet().size());
    }

    @Test
    public void testValidatingProjectIncomeField_Zero() throws Exception {
        this.budgetProjectIncome.setBudgetPeriodNumber(Integer.valueOf(1));
        this.budgetProjectIncome.setProjectIncome(KualiDecimal.ZERO);
        this.budgetProjectIncome.setDescription("Description");
        Assert.assertFalse((boolean)this.addBudgetProjectIncomeRule.processAddBudgetProjectIncomeBusinessRules(this.addBudgetIncomeEvent));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorMessages().keySet().size());
        ErrorMessage errMsg = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("newBudgetProjectIncome.projectIncome")).get(0);
        Assert.assertEquals((Object)"error.projectIncome.negativeOrZero", (Object)errMsg.getErrorKey());
        Assert.assertEquals((Object)"Income amount must be greater than zero (0.00)", (Object)this.getErrorForkey("error.projectIncome.negativeOrZero"));
    }

    private String getErrorForkey(String key) throws Exception {
        Properties props = new Properties();
        props.load(this.getClass().getClassLoader().getResourceAsStream("ApplicationResources.properties"));
        return props.getProperty(key);
    }

    @Test
    public void testValidatingRequiredFields_BudgetPeriodAndProjectIncomeSet() throws Exception {
        this.budgetProjectIncome.setBudgetPeriodNumber(Integer.valueOf(1));
        this.budgetProjectIncome.setProjectIncome(PROJECT_INCOME_AMOUNT);
        Assert.assertFalse((boolean)this.addBudgetProjectIncomeRule.processAddBudgetProjectIncomeBusinessRules(this.addBudgetIncomeEvent));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorMessages().keySet().size());
    }

    @Test
    public void testValidatingRequiredFields_BudgetPeriodSet() throws Exception {
        this.budgetProjectIncome.setBudgetPeriodNumber(Integer.valueOf(1));
        Assert.assertFalse((boolean)this.addBudgetProjectIncomeRule.processAddBudgetProjectIncomeBusinessRules(this.addBudgetIncomeEvent));
        Assert.assertEquals((long)2L, (long)GlobalVariables.getMessageMap().getErrorMessages().keySet().size());
    }

    @Before
    public void setUp() {
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        this.budgetProjectIncome = new BudgetProjectIncome();
        this.addBudgetIncomeEvent = new AddBudgetProjectIncomeEvent(null, null, null, this.budgetProjectIncome);
        this.addBudgetProjectIncomeRule = new BudgetProjectIncomeRuleImpl();
    }

    @After
    public void tearDown() {
        GlobalVariables.clear();
        this.addBudgetProjectIncomeRule = null;
        this.budgetProjectIncome = null;
        this.addBudgetIncomeEvent = null;
    }
}

