/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.rules;

import java.util.ArrayList;
import java.util.Collections;
import junit.framework.Assert;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetService;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.personnel.BudgetPerson;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.budget.personnel.BudgetPersonnelRule;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class BudgetPersonnelRuleTest {
    private Mockery context;

    @Before
    public void setupJMock() {
        this.context = new JUnit4Mockery();
    }

    @Before
    public void setupErrorMap() {
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
    }

    @Test(expected=NullPointerException.class)
    public void testNullBusinessObjectService() {
        new BudgetPersonnelRule(null, (ParameterService)this.context.mock(ParameterService.class), (BudgetService)this.context.mock(BudgetService.class));
    }

    @Test(expected=NullPointerException.class)
    public void testNullKualiConfigurationService() {
        new BudgetPersonnelRule((BusinessObjectService)this.context.mock(BusinessObjectService.class), null, (BudgetService)this.context.mock(BudgetService.class));
    }

    @Test(expected=NullPointerException.class)
    public void testNullBudgetService() {
        new BudgetPersonnelRule((BusinessObjectService)this.context.mock(BusinessObjectService.class), (ParameterService)this.context.mock(ParameterService.class), null);
    }

    @Test(expected=NullPointerException.class)
    public void testProcessCheckForJobCodeChangeNullDoc() {
        BudgetPersonnelRule rule = new BudgetPersonnelRule((BusinessObjectService)this.context.mock(BusinessObjectService.class), (ParameterService)this.context.mock(ParameterService.class), (BudgetService)this.context.mock(BudgetService.class));
        rule.processCheckForJobCodeChange(null, 1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testProcessCheckForJobCodeChangeInvalidPeriod() {
        BudgetPersonnelRule rule = new BudgetPersonnelRule((BusinessObjectService)this.context.mock(BusinessObjectService.class), (ParameterService)this.context.mock(ParameterService.class), (BudgetService)this.context.mock(BudgetService.class));
        rule.processCheckForJobCodeChange(new BudgetDocument(), 0);
    }

    @Test
    public void testJobCodeNullDetails() {
        final BudgetService budgetService = (BudgetService)this.context.mock(BudgetService.class);
        BudgetPersonnelRule rule = new BudgetPersonnelRule((BusinessObjectService)this.context.mock(BusinessObjectService.class), (ParameterService)this.context.mock(ParameterService.class), budgetService);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BudgetService)this.oneOf(budgetService)).getApplicableCostElements(Long.valueOf(1L), "1");
                this.will(1.returnValue(Collections.emptyList()));
            }
        });
        BudgetDocument doc = this.getBudgetDoc();
        doc.getBudget().getBudgetPerson(0).setJobCode(null);
        rule.processCheckForJobCodeChange(doc, 1);
        this.context.assertIsSatisfied();
        Assert.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorMessages().size());
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().getErrorMessages().containsKey("document.budgetPersons[0].jobCode"));
    }

    @Test
    public void testJobCodeNullNoDetails() {
        final BudgetService budgetService = (BudgetService)this.context.mock(BudgetService.class);
        BudgetPersonnelRule rule = new BudgetPersonnelRule((BusinessObjectService)this.context.mock(BusinessObjectService.class), (ParameterService)this.context.mock(ParameterService.class), budgetService);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BudgetService)this.oneOf(budgetService)).getApplicableCostElements(Long.valueOf(1L), "1");
                this.will(2.returnValue(Collections.emptyList()));
            }
        });
        BudgetDocument doc = this.getBudgetDoc();
        doc.getBudget().getBudgetPerson(0).setJobCode("Foo");
        rule.processCheckForJobCodeChange(doc, 1);
        this.context.assertIsSatisfied();
        Assert.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorMessages().size());
    }

    private BudgetDocument getBudgetDoc() {
        BudgetDocument bdoc = new BudgetDocument();
        Budget budget = bdoc.getBudget();
        ArrayList<BudgetPeriod> periods = new ArrayList<BudgetPeriod>();
        BudgetPeriod period = new BudgetPeriod();
        ArrayList<BudgetLineItem> lineItems = new ArrayList<BudgetLineItem>();
        BudgetLineItem lineItem = budget.getNewBudgetLineItem();
        lineItem.setLineItemSequence(Integer.valueOf(1));
        ArrayList<BudgetPersonnelDetails> lineItemDetails = new ArrayList<BudgetPersonnelDetails>();
        BudgetPersonnelDetails details = lineItem.getNewBudgetPersonnelLineItem();
        details.setLineItemSequence(Integer.valueOf(1));
        details.setPersonSequenceNumber(Integer.valueOf(1));
        lineItemDetails.add(details);
        lineItem.setBudgetPersonnelDetailsList(lineItemDetails);
        lineItems.add(lineItem);
        period.setBudgetLineItems(lineItems);
        periods.add(period);
        ArrayList<3> persons = new ArrayList<3>();
        BudgetPerson person = new BudgetPerson(){
            private String jc;

            public void setJobCode(String jobCode) {
                this.jc = jobCode;
            }

            public String getJobCode() {
                return this.jc;
            }
        };
        person.setPersonSequenceNumber(Integer.valueOf(1));
        person.setBudgetId(Long.valueOf(1L));
        persons.add(person);
        budget.setBudgetPeriods(periods);
        budget.setBudgetPersons(persons);
        bdoc.setParentDocumentKey("1234");
        budget.setBudgetVersionNumber(Integer.valueOf(1));
        return bdoc;
    }
}

