/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.rules;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.distributionincome.BudgetUnrecoveredFandA;
import org.kuali.kra.budget.distributionincome.BudgetUnrecoveredFandARuleImpl;
import org.kuali.kra.budget.distributionincome.BudgetValidationUnrecoveredFandAEvent;
import org.kuali.kra.budget.distributionincome.BudgetValidationUnrecoveredFandARule;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class BudgetValidationUnrecoveredFandARuleTest {
    private static final BudgetDecimal AMOUNT = new BudgetDecimal(100.0);
    private static final BudgetDecimal APPLICABLE_RATE = new BudgetDecimal(19.87);
    private final String ON_CAMPUS = "Y";
    private static final int BUDGET_FISCAL_YEAR = 2008;
    private static final String SOURCE_ACCOUNT = "12345A";
    private BudgetUnrecoveredFandA unrecoveredFandA;
    private BudgetValidationUnrecoveredFandARule unrecoveredFandARule;

    @Before
    public void setUp() {
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        this.unrecoveredFandARule = new BudgetUnrecoveredFandARuleImpl();
    }

    @After
    public void tearDown() {
        GlobalVariables.clear();
        this.unrecoveredFandARule = null;
    }

    @Test
    public void testValidatingRequiredFields_AllRequiredFieldsFilled() throws Exception {
        this.unrecoveredFandA = new BudgetUnrecoveredFandA(Integer.valueOf(2008), AMOUNT, APPLICABLE_RATE, "Y", SOURCE_ACCOUNT);
        Assert.assertTrue((boolean)this.unrecoveredFandARule.processBudgetValidationUnrecoveredFandABusinessRules(this.getEvent(this.unrecoveredFandA)));
        Assert.assertEquals((long)0L, (long)GlobalVariables.getMessageMap().getErrorMessages().keySet().size());
    }

    @Test
    public void testValidatingRequiredFields_FiscalYearMissing() throws Exception {
        this.unrecoveredFandA = new BudgetUnrecoveredFandA(null, AMOUNT, APPLICABLE_RATE, "Y", SOURCE_ACCOUNT);
        Assert.assertFalse((boolean)this.unrecoveredFandARule.processBudgetValidationUnrecoveredFandABusinessRules(this.getEvent(this.unrecoveredFandA)));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorMessages().keySet().size());
    }

    @Test
    public void testValidatingRequiredFields_NoneSet() throws Exception {
        this.unrecoveredFandA = new BudgetUnrecoveredFandA();
        Assert.assertFalse((boolean)this.unrecoveredFandARule.processBudgetValidationUnrecoveredFandABusinessRules(this.getEvent(this.unrecoveredFandA)));
        Assert.assertEquals((long)4L, (long)GlobalVariables.getMessageMap().getErrorMessages().keySet().size());
    }

    @Test
    public void testValidatingRequiredFields_AmountMissing() throws Exception {
        this.unrecoveredFandA = new BudgetUnrecoveredFandA(Integer.valueOf(2008), null, APPLICABLE_RATE, "Y", SOURCE_ACCOUNT);
        Assert.assertTrue((boolean)this.unrecoveredFandARule.processBudgetValidationUnrecoveredFandABusinessRules(this.getEvent(this.unrecoveredFandA)));
        Assert.assertEquals((long)0L, (long)GlobalVariables.getMessageMap().getErrorMessages().keySet().size());
    }

    @Test
    public void testValidatingRequiredFields_CampusMissing() throws Exception {
        this.unrecoveredFandA = new BudgetUnrecoveredFandA(Integer.valueOf(2008), AMOUNT, APPLICABLE_RATE, null, SOURCE_ACCOUNT);
        Assert.assertFalse((boolean)this.unrecoveredFandARule.processBudgetValidationUnrecoveredFandABusinessRules(this.getEvent(this.unrecoveredFandA)));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorMessages().keySet().size());
    }

    @Test
    public void testValidatingRequiredFields_ApplicableRateMissing() throws Exception {
        this.unrecoveredFandA = new BudgetUnrecoveredFandA(Integer.valueOf(2008), AMOUNT, null, "Y", SOURCE_ACCOUNT);
        Assert.assertFalse((boolean)this.unrecoveredFandARule.processBudgetValidationUnrecoveredFandABusinessRules(this.getEvent(this.unrecoveredFandA)));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorMessages().keySet().size());
    }

    @Test
    public void testValidatingRequiredFields_SourceAccountMissing() throws Exception {
        this.unrecoveredFandA = new BudgetUnrecoveredFandA(Integer.valueOf(2008), AMOUNT, APPLICABLE_RATE, "Y", null);
        Assert.assertFalse((boolean)this.unrecoveredFandARule.processBudgetValidationUnrecoveredFandABusinessRules(this.getEvent(this.unrecoveredFandA)));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorMessages().keySet().size());
    }

    private BudgetValidationUnrecoveredFandAEvent getEvent(BudgetUnrecoveredFandA unrecoveredFandA) {
        return new BudgetValidationUnrecoveredFandAEvent(null, null, null, unrecoveredFandA);
    }
}

