/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.rules;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.InstituteRate;
import org.kuali.kra.budget.rates.InstituteRateMaintenanceDocumentRule;
import org.kuali.kra.maintenance.MaintenanceRuleTestBase;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.util.AutoPopulatingList;

public class InstituteRateMaintenanceDocumentRuleTest
extends MaintenanceRuleTestBase {
    private InstituteRateMaintenanceDocumentRule rule = null;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rule = new InstituteRateMaintenanceDocumentRule();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.rule = null;
        super.tearDown();
    }

    @Test
    public void testOK() throws Exception {
        InstituteRate instituteRate = new InstituteRate();
        instituteRate.setRateClassCode("1");
        instituteRate.setRateTypeCode("1");
        instituteRate.setUnitNumber("000001");
        instituteRate.setActivityTypeCode("1");
        MaintenanceDocument instituteRateDocument = this.newMaintDoc((PersistableBusinessObject)instituteRate);
        InstituteRateMaintenanceDocumentRuleTest.assertTrue((boolean)this.rule.processCustomRouteDocumentBusinessRules(instituteRateDocument));
        InstituteRateMaintenanceDocumentRuleTest.assertTrue((boolean)this.rule.processCustomApproveDocumentBusinessRules(instituteRateDocument));
    }

    @Test
    public void testRateTypeNotExist() throws Exception {
        InstituteRate instituteRate = new InstituteRate();
        instituteRate.setRateClassCode("10");
        instituteRate.setRateTypeCode("2");
        instituteRate.setUnitNumber("000001");
        instituteRate.setActivityTypeCode("1");
        MaintenanceDocument instituteRateDocument = this.newMaintDoc((PersistableBusinessObject)instituteRate);
        InstituteRateMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomRouteDocumentBusinessRules(instituteRateDocument));
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages("document.newMaintainableObject.rateTypeCode");
        InstituteRateMaintenanceDocumentRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        ErrorMessage message = (ErrorMessage)errors.get(0);
        InstituteRateMaintenanceDocumentRuleTest.assertEquals((Object)message.getErrorKey(), (Object)"error.rateType.not.exist");
        InstituteRateMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomApproveDocumentBusinessRules(instituteRateDocument));
        errors = GlobalVariables.getMessageMap().getMessages("document.newMaintainableObject.rateTypeCode");
        InstituteRateMaintenanceDocumentRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        message = (ErrorMessage)errors.get(0);
        InstituteRateMaintenanceDocumentRuleTest.assertEquals((Object)message.getErrorKey(), (Object)"error.rateType.not.exist");
    }

    @Test
    public void testUnitNumberNotExist() throws Exception {
        InstituteRate instituteRate = new InstituteRate();
        instituteRate.setRateClassCode("10");
        instituteRate.setRateTypeCode("1");
        instituteRate.setUnitNumber("00000x");
        instituteRate.setActivityTypeCode("1");
        MaintenanceDocument instituteRateDocument = this.newMaintDoc((PersistableBusinessObject)instituteRate);
        InstituteRateMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomRouteDocumentBusinessRules(instituteRateDocument));
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages("document.newMaintainableObject.unitNumber");
        InstituteRateMaintenanceDocumentRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        ErrorMessage message = (ErrorMessage)errors.get(0);
        InstituteRateMaintenanceDocumentRuleTest.assertEquals((Object)message.getErrorKey(), (Object)"error.existence");
        InstituteRateMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomApproveDocumentBusinessRules(instituteRateDocument));
        errors = GlobalVariables.getMessageMap().getMessages("document.newMaintainableObject.unitNumber");
        InstituteRateMaintenanceDocumentRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        message = (ErrorMessage)errors.get(0);
        InstituteRateMaintenanceDocumentRuleTest.assertEquals((Object)message.getErrorKey(), (Object)"error.existence");
    }

    @Test
    public void testActivityTypeNotExist() throws Exception {
        InstituteRate instituteRate = new InstituteRate();
        instituteRate.setRateClassCode("10");
        instituteRate.setRateTypeCode("1");
        instituteRate.setUnitNumber("000001");
        instituteRate.setActivityTypeCode("x");
        MaintenanceDocument instituteRateDocument = this.newMaintDoc((PersistableBusinessObject)instituteRate);
        InstituteRateMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomRouteDocumentBusinessRules(instituteRateDocument));
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages("document.newMaintainableObject.activityTypeCode");
        InstituteRateMaintenanceDocumentRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        ErrorMessage message = (ErrorMessage)errors.get(0);
        InstituteRateMaintenanceDocumentRuleTest.assertEquals((Object)message.getErrorKey(), (Object)"error.existence");
        InstituteRateMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomApproveDocumentBusinessRules(instituteRateDocument));
        errors = GlobalVariables.getMessageMap().getMessages("document.newMaintainableObject.activityTypeCode");
        InstituteRateMaintenanceDocumentRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        message = (ErrorMessage)errors.get(0);
        InstituteRateMaintenanceDocumentRuleTest.assertEquals((Object)message.getErrorKey(), (Object)"error.existence");
    }
}

