/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.rules;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.hamcrest.Matcher;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.kuali.kra.bo.AbstractInstituteRate;
import org.kuali.kra.bo.InstituteLaRate;
import org.kuali.kra.bo.InstituteRate;
import org.kuali.kra.budget.rates.InstituteRateRateTypeRateClassRuleImpl;
import org.kuali.kra.budget.rates.RateClass;
import org.kuali.kra.budget.rates.RateType;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class InstituteRateRateTypeRateClassRuleTest {
    private Mockery context;

    @Before
    public void setupMockery() {
        this.context = new JUnit4Mockery();
    }

    @Before
    public void setupErrorMap() {
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
    }

    @Test(expected=NullPointerException.class)
    public void testNullBusinessObjectService() {
        new InstituteRateRateTypeRateClassRuleImpl(null, (ParameterService)this.context.mock(ParameterService.class));
    }

    @Test(expected=NullPointerException.class)
    public void testNullConfigService() {
        new InstituteRateRateTypeRateClassRuleImpl((BusinessObjectService)this.context.mock(BusinessObjectService.class), null);
    }

    @Test(expected=NullPointerException.class)
    public void testNullDocument() {
        InstituteRateRateTypeRateClassRuleImpl rule = new InstituteRateRateTypeRateClassRuleImpl((BusinessObjectService)this.context.mock(BusinessObjectService.class), (ParameterService)this.context.mock(ParameterService.class));
        rule.validateRateTypeAndRateClass(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnsupportedDocumentGetValidRateTypes() throws Throwable {
        InstituteRateRateTypeRateClassRuleImpl rule = new InstituteRateRateTypeRateClassRuleImpl((BusinessObjectService)this.context.mock(BusinessObjectService.class), (ParameterService)this.context.mock(ParameterService.class));
        Method m = rule.getClass().getDeclaredMethod("getValidRateClassTypes", AbstractInstituteRate.class);
        m.setAccessible(true);
        try {
            m.invoke((Object)rule, new AbstractInstituteRate(){});
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    @Test
    public void testNoRateClassCheckCorrectRateClass() throws Throwable {
        InstituteRateRateTypeRateClassRuleImpl rule = new InstituteRateRateTypeRateClassRuleImpl((BusinessObjectService)this.context.mock(BusinessObjectService.class), (ParameterService)this.context.mock(ParameterService.class));
        Method m = rule.getClass().getDeclaredMethod("checkCorrectRateClass", AbstractInstituteRate.class);
        m.setAccessible(true);
        InstituteRate instituteRate = new InstituteRate();
        instituteRate.setRateClassCode(null);
        Assert.assertTrue((String)"Should have been valid", (boolean)((Boolean)m.invoke((Object)rule, instituteRate)));
        this.context.assertIsSatisfied();
    }

    @Test
    public void testNoRateTypeCheckCorrectRateType() throws Throwable {
        InstituteRateRateTypeRateClassRuleImpl rule = new InstituteRateRateTypeRateClassRuleImpl((BusinessObjectService)this.context.mock(BusinessObjectService.class), (ParameterService)this.context.mock(ParameterService.class));
        Method m = rule.getClass().getDeclaredMethod("checkCorrectRateType", AbstractInstituteRate.class);
        m.setAccessible(true);
        InstituteRate instituteRate = new InstituteRate();
        instituteRate.setRateTypeCode(null);
        Assert.assertTrue((String)"Should have been valid", (boolean)((Boolean)m.invoke((Object)rule, instituteRate)));
        this.context.assertIsSatisfied();
    }

    @Test
    public void testLaRatesValidTypes() throws Throwable {
        final ParameterService pService = (ParameterService)this.context.mock(ParameterService.class);
        InstituteRateRateTypeRateClassRuleImpl rule = new InstituteRateRateTypeRateClassRuleImpl((BusinessObjectService)this.context.mock(BusinessObjectService.class), pService);
        Method m = rule.getClass().getDeclaredMethod("getValidRateClassTypes", AbstractInstituteRate.class);
        m.setAccessible(true);
        InstituteLaRate instituteLaRate = new InstituteLaRate();
        final ArrayList<String> validTypes = new ArrayList<String>();
        validTypes.add("foo");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ParameterService)this.oneOf(pService)).getParameterValuesAsString("KC-B", "All", "instituteLaRateClassTypes");
                this.will(2.returnValue((Object)validTypes));
            }
        });
        Collection validRates = (Collection)m.invoke((Object)rule, instituteLaRate);
        Assert.assertThat((Object)validRates, (Matcher)JUnitMatchers.hasItem((Object)"foo"));
        this.context.assertIsSatisfied();
    }

    @Test
    public void testRatesValidTypes() throws Throwable {
        final ParameterService pService = (ParameterService)this.context.mock(ParameterService.class);
        InstituteRateRateTypeRateClassRuleImpl rule = new InstituteRateRateTypeRateClassRuleImpl((BusinessObjectService)this.context.mock(BusinessObjectService.class), pService);
        Method m = rule.getClass().getDeclaredMethod("getValidRateClassTypes", AbstractInstituteRate.class);
        m.setAccessible(true);
        InstituteRate instituteRate = new InstituteRate();
        final ArrayList<String> validTypes = new ArrayList<String>();
        validTypes.add("foo");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ParameterService)this.oneOf(pService)).getParameterValuesAsString("KC-B", "All", "instituteRateClassTypes");
                this.will(3.returnValue((Object)validTypes));
            }
        });
        Collection validRates = (Collection)m.invoke((Object)rule, instituteRate);
        Assert.assertThat((Object)validRates, (Matcher)JUnitMatchers.hasItem((Object)"foo"));
        this.context.assertIsSatisfied();
    }

    @Test
    public void testInvalidRateTypeForRateType() throws Throwable {
        final ParameterService pService = (ParameterService)this.context.mock(ParameterService.class);
        final BusinessObjectService boService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        InstituteRateRateTypeRateClassRuleImpl rule = new InstituteRateRateTypeRateClassRuleImpl(boService, pService);
        Method m = rule.getClass().getDeclaredMethod("checkCorrectRateType", AbstractInstituteRate.class);
        m.setAccessible(true);
        InstituteRate instituteRate = new InstituteRate();
        instituteRate.setRateTypeCode("foo");
        final ArrayList<String> validTypes = new ArrayList<String>();
        validTypes.add("abc");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ParameterService)this.oneOf(pService)).getParameterValuesAsString("KC-B", "All", "instituteRateClassTypes");
                this.will(4.returnValue((Object)validTypes));
                ArrayList<RateType> rateTypes = new ArrayList<RateType>();
                RateType type = new RateType();
                RateClass rClass = new RateClass();
                rClass.setRateClassType("cdf");
                type.setRateClass(rClass);
                rateTypes.add(type);
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("rateTypeCode", "foo");
                ((BusinessObjectService)this.oneOf(boService)).findMatching(RateType.class, fieldValues);
                this.will(4.returnValue(rateTypes));
            }
        });
        Assert.assertFalse((String)"Should not be valid", (boolean)((Boolean)m.invoke((Object)rule, instituteRate)));
        Assert.assertEquals((String)("should be errors " + GlobalVariables.getMessageMap()), (long)1L, (long)GlobalVariables.getMessageMap().getErrorMessages().size());
        this.context.assertIsSatisfied();
    }

    @Test
    public void testInvalidRateClassForRateType() throws Throwable {
        final ParameterService pService = (ParameterService)this.context.mock(ParameterService.class);
        final BusinessObjectService boService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        InstituteRateRateTypeRateClassRuleImpl rule = new InstituteRateRateTypeRateClassRuleImpl(boService, pService);
        Method m = rule.getClass().getDeclaredMethod("checkCorrectRateClass", AbstractInstituteRate.class);
        m.setAccessible(true);
        InstituteRate instituteRate = new InstituteRate();
        instituteRate.setRateClassCode("foo");
        final ArrayList<String> validTypes = new ArrayList<String>();
        validTypes.add("abc");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ParameterService)this.oneOf(pService)).getParameterValuesAsString("KC-B", "All", "instituteRateClassTypes");
                this.will(5.returnValue((Object)validTypes));
                ArrayList<RateType> rateTypes = new ArrayList<RateType>();
                RateType type = new RateType();
                RateClass rClass = new RateClass();
                rClass.setRateClassType("cdf");
                type.setRateClass(rClass);
                rateTypes.add(type);
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("rateClassCode", "foo");
                ((BusinessObjectService)this.oneOf(boService)).findMatching(RateType.class, fieldValues);
                this.will(5.returnValue(rateTypes));
            }
        });
        Assert.assertFalse((String)"Should not be valid", (boolean)((Boolean)m.invoke((Object)rule, instituteRate)));
        Assert.assertEquals((String)("should be errors " + GlobalVariables.getMessageMap()), (long)1L, (long)GlobalVariables.getMessageMap().getErrorMessages().size());
        this.context.assertIsSatisfied();
    }

    @Test
    public void testValidRateClassForRateType() throws Throwable {
        final ParameterService pService = (ParameterService)this.context.mock(ParameterService.class);
        final BusinessObjectService boService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        InstituteRateRateTypeRateClassRuleImpl rule = new InstituteRateRateTypeRateClassRuleImpl(boService, pService);
        Method m = rule.getClass().getDeclaredMethod("checkCorrectRateClass", AbstractInstituteRate.class);
        m.setAccessible(true);
        InstituteRate instituteRate = new InstituteRate();
        instituteRate.setRateClassCode("foo");
        final ArrayList<String> validTypes = new ArrayList<String>();
        validTypes.add("abc");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ParameterService)this.oneOf(pService)).getParameterValuesAsString("KC-B", "All", "instituteRateClassTypes");
                this.will(6.returnValue((Object)validTypes));
                ArrayList<RateType> rateTypes = new ArrayList<RateType>();
                RateType type = new RateType();
                RateClass rClass = new RateClass();
                rClass.setRateClassType("abc");
                type.setRateClass(rClass);
                rateTypes.add(type);
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("rateClassCode", "foo");
                ((BusinessObjectService)this.oneOf(boService)).findMatching(RateType.class, fieldValues);
                this.will(6.returnValue(rateTypes));
            }
        });
        Assert.assertTrue((String)"Should not be valid", (boolean)((Boolean)m.invoke((Object)rule, instituteRate)));
        Assert.assertEquals((String)("should be no errors " + GlobalVariables.getMessageMap()), (long)0L, (long)GlobalVariables.getMessageMap().getErrorMessages().size());
        this.context.assertIsSatisfied();
    }

    @Test
    public void testValidRateTypeForRateType() throws Throwable {
        final ParameterService pService = (ParameterService)this.context.mock(ParameterService.class);
        final BusinessObjectService boService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        InstituteRateRateTypeRateClassRuleImpl rule = new InstituteRateRateTypeRateClassRuleImpl(boService, pService);
        Method m = rule.getClass().getDeclaredMethod("checkCorrectRateType", AbstractInstituteRate.class);
        m.setAccessible(true);
        InstituteRate instituteRate = new InstituteRate();
        instituteRate.setRateTypeCode("foo");
        final ArrayList<String> validTypes = new ArrayList<String>();
        validTypes.add("abc");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ParameterService)this.oneOf(pService)).getParameterValuesAsString("KC-B", "All", "instituteRateClassTypes");
                this.will(7.returnValue((Object)validTypes));
                ArrayList<RateType> rateTypes = new ArrayList<RateType>();
                RateType type = new RateType();
                RateClass rClass = new RateClass();
                rClass.setRateClassType("abc");
                type.setRateClass(rClass);
                rateTypes.add(type);
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("rateTypeCode", "foo");
                ((BusinessObjectService)this.oneOf(boService)).findMatching(RateType.class, fieldValues);
                this.will(7.returnValue(rateTypes));
            }
        });
        Assert.assertTrue((String)"Should not be valid", (boolean)((Boolean)m.invoke((Object)rule, instituteRate)));
        Assert.assertEquals((String)("should be no errors " + GlobalVariables.getMessageMap()), (long)0L, (long)GlobalVariables.getMessageMap().getErrorMessages().size());
        this.context.assertIsSatisfied();
    }
}

