/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.rules;

import java.sql.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.OrganizationYnq;
import org.kuali.kra.bo.Ynq;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.maintenance.MaintenanceRuleTestBase;
import org.kuali.kra.rules.OrganizationMaintenanceDocumentRule;
import org.kuali.kra.service.YnqService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.util.GlobalVariables;

public class OrganizationMaintenanceDocumentRuleTest
extends MaintenanceRuleTestBase {
    private OrganizationMaintenanceDocumentRule rule = null;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rule = new OrganizationMaintenanceDocumentRule();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.rule = null;
        super.tearDown();
    }

    @Test
    public void testOK() throws Exception {
        Organization organization = new Organization();
        organization.setOrganizationId("00999");
        organization.setOrganizationName("test");
        organization.setContactAddressId(new Integer(1741));
        organization.setOrganizationYnqs(this.setupOrganizationYnq(organization, "test", ((DateTimeService)KraServiceLocator.getService(DateTimeService.class)).getCurrentSqlDate()));
        MaintenanceDocument organizationDocument = this.newMaintDoc((PersistableBusinessObject)organization);
        OrganizationMaintenanceDocumentRuleTest.assertTrue((boolean)this.rule.processCustomRouteDocumentBusinessRules(organizationDocument));
        OrganizationMaintenanceDocumentRuleTest.assertTrue((boolean)this.rule.processCustomApproveDocumentBusinessRules(organizationDocument));
    }

    @Test
    public void testMissingReviewDate() throws Exception {
        Organization organization = new Organization();
        organization.setOrganizationId("00999");
        organization.setOrganizationName("test");
        organization.setContactAddressId(new Integer(1741));
        organization.setOrganizationYnqs(this.setupOrganizationYnq(organization, "test", null));
        MaintenanceDocument organizationDocument = this.newMaintDoc((PersistableBusinessObject)organization);
        OrganizationMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomRouteDocumentBusinessRules(organizationDocument));
        OrganizationMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomApproveDocumentBusinessRules(organizationDocument));
    }

    @Test
    public void testMissingExplanation() throws Exception {
        Organization organization = new Organization();
        organization.setOrganizationId("00999");
        organization.setOrganizationName("test");
        organization.setContactAddressId(new Integer(1741));
        organization.setOrganizationYnqs(this.setupOrganizationYnq(organization, "", ((DateTimeService)KraServiceLocator.getService(DateTimeService.class)).getCurrentSqlDate()));
        MaintenanceDocument organizationDocument = this.newMaintDoc((PersistableBusinessObject)organization);
        OrganizationMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomRouteDocumentBusinessRules(organizationDocument));
        OrganizationMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomApproveDocumentBusinessRules(organizationDocument));
    }

    private List<OrganizationYnq> setupOrganizationYnq(Organization organization, String explanation, Date reviewDate) {
        List ynqs = ((YnqService)KraServiceLocator.getService(YnqService.class)).getYnq("O");
        List organizationYnqs = organization.getOrganizationYnqs();
        for (Ynq ynq : ynqs) {
            OrganizationYnq organizationYnq = new OrganizationYnq();
            organizationYnq.setYnq(ynq);
            organizationYnq.setQuestionId(ynq.getQuestionId());
            organizationYnq.setAnswer("Y");
            organizationYnq.setExplanation(explanation);
            organizationYnq.setReviewDate(reviewDate);
            if (StringUtils.isNotBlank((String)organization.getOrganizationId())) {
                organizationYnq.setOrganizationId(organization.getOrganizationId());
            }
            organizationYnqs.add(organizationYnq);
        }
        return organizationYnqs;
    }
}

