/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.rules;

import java.util.Map;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.budget.calculator.ValidCalcType;
import org.kuali.kra.budget.nonpersonnel.ValidCalcTypeMaintenanceDocumentRule;
import org.kuali.kra.maintenance.MaintenanceRuleTestBase;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.util.AutoPopulatingList;

public class ValidCalcTypeMaintenanceDocumentRuleTest
extends MaintenanceRuleTestBase {
    private ValidCalcTypeMaintenanceDocumentRule rule = null;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rule = new ValidCalcTypeMaintenanceDocumentRule();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.rule = null;
        super.tearDown();
    }

    @Test
    public void testOK() throws Exception {
        ValidCalcType validCalcType = new ValidCalcType();
        validCalcType.setRateClassCode("10");
        validCalcType.setRateTypeCode("1");
        validCalcType.setRateClassType("X");
        validCalcType.setDependentRateClassType("Y");
        MaintenanceDocument validCalcTypeDocument = this.newMaintDoc((PersistableBusinessObject)validCalcType);
        ValidCalcTypeMaintenanceDocumentRuleTest.assertTrue((boolean)this.rule.processCustomRouteDocumentBusinessRules(validCalcTypeDocument));
        Map eMap = GlobalVariables.getMessageMap().getErrorMessages();
        ValidCalcTypeMaintenanceDocumentRuleTest.assertEquals((long)0L, (long)eMap.size());
        ValidCalcTypeMaintenanceDocumentRuleTest.assertTrue((boolean)this.rule.processCustomApproveDocumentBusinessRules(validCalcTypeDocument));
        ValidCalcTypeMaintenanceDocumentRuleTest.assertEquals((long)0L, (long)eMap.size());
    }

    @Test
    public void testOKNoDependentRateClassType() throws Exception {
        ValidCalcType validCalcType = new ValidCalcType();
        validCalcType.setRateClassCode("10");
        validCalcType.setRateTypeCode("1");
        validCalcType.setRateClassType("X");
        validCalcType.setDependentRateClassType(null);
        MaintenanceDocument validCalcTypeDocument = this.newMaintDoc((PersistableBusinessObject)validCalcType);
        ValidCalcTypeMaintenanceDocumentRuleTest.assertTrue((boolean)this.rule.processCustomRouteDocumentBusinessRules(validCalcTypeDocument));
        Map eMap = GlobalVariables.getMessageMap().getErrorMessages();
        ValidCalcTypeMaintenanceDocumentRuleTest.assertEquals((long)0L, (long)eMap.size());
        ValidCalcTypeMaintenanceDocumentRuleTest.assertTrue((boolean)this.rule.processCustomApproveDocumentBusinessRules(validCalcTypeDocument));
        ValidCalcTypeMaintenanceDocumentRuleTest.assertEquals((long)0L, (long)eMap.size());
    }

    @Test
    public void testRateTypeNotExist() throws Exception {
        ValidCalcType validCalcType = new ValidCalcType();
        validCalcType.setRateClassCode("10");
        validCalcType.setRateTypeCode("2");
        validCalcType.setRateClassType("X");
        validCalcType.setDependentRateClassType("Y");
        MaintenanceDocument validCalcTypeDocument = this.newMaintDoc((PersistableBusinessObject)validCalcType);
        ValidCalcTypeMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomRouteDocumentBusinessRules(validCalcTypeDocument));
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages("document.newMaintainableObject.rateTypeCode");
        ValidCalcTypeMaintenanceDocumentRuleTest.assertEquals((long)1L, (long)errors.size());
        ErrorMessage message = (ErrorMessage)errors.get(0);
        ValidCalcTypeMaintenanceDocumentRuleTest.assertEquals((Object)message.getErrorKey(), (Object)"error.rateType.not.exist");
        ValidCalcTypeMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomApproveDocumentBusinessRules(validCalcTypeDocument));
        errors = GlobalVariables.getMessageMap().getMessages("document.newMaintainableObject.rateTypeCode");
        ValidCalcTypeMaintenanceDocumentRuleTest.assertEquals((long)1L, (long)errors.size());
        message = (ErrorMessage)errors.get(0);
        ValidCalcTypeMaintenanceDocumentRuleTest.assertEquals((Object)message.getErrorKey(), (Object)"error.rateType.not.exist");
    }

    @Test
    public void testRateClassTypeNotExist() throws Exception {
        ValidCalcType validCalcType = new ValidCalcType();
        validCalcType.setRateClassCode("10");
        validCalcType.setRateTypeCode("1");
        validCalcType.setRateClassType("1");
        validCalcType.setDependentRateClassType("Y");
        MaintenanceDocument validCalcTypeDocument = this.newMaintDoc((PersistableBusinessObject)validCalcType);
        ValidCalcTypeMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomRouteDocumentBusinessRules(validCalcTypeDocument));
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages("document.newMaintainableObject.rateClassType");
        ValidCalcTypeMaintenanceDocumentRuleTest.assertEquals((long)1L, (long)errors.size());
        ErrorMessage message = (ErrorMessage)errors.get(0);
        ValidCalcTypeMaintenanceDocumentRuleTest.assertEquals((Object)message.getErrorKey(), (Object)"error.existence");
        ValidCalcTypeMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomApproveDocumentBusinessRules(validCalcTypeDocument));
        errors = GlobalVariables.getMessageMap().getMessages("document.newMaintainableObject.rateClassType");
        ValidCalcTypeMaintenanceDocumentRuleTest.assertEquals((long)1L, (long)errors.size());
        message = (ErrorMessage)errors.get(0);
        ValidCalcTypeMaintenanceDocumentRuleTest.assertEquals((Object)message.getErrorKey(), (Object)"error.existence");
    }

    @Test
    public void testDependentrateClassTypeNotExist() throws Exception {
        ValidCalcType validCalcType = new ValidCalcType();
        validCalcType.setRateClassCode("10");
        validCalcType.setRateTypeCode("1");
        validCalcType.setRateClassType("X");
        validCalcType.setDependentRateClassType("1");
        MaintenanceDocument validCalcTypeDocument = this.newMaintDoc((PersistableBusinessObject)validCalcType);
        ValidCalcTypeMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomRouteDocumentBusinessRules(validCalcTypeDocument));
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages("document.newMaintainableObject.dependentRateClassType");
        ValidCalcTypeMaintenanceDocumentRuleTest.assertEquals((long)1L, (long)errors.size());
        ErrorMessage message = (ErrorMessage)errors.get(0);
        ValidCalcTypeMaintenanceDocumentRuleTest.assertEquals((Object)message.getErrorKey(), (Object)"error.existence");
        ValidCalcTypeMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomApproveDocumentBusinessRules(validCalcTypeDocument));
        errors = GlobalVariables.getMessageMap().getMessages("document.newMaintainableObject.dependentRateClassType");
        ValidCalcTypeMaintenanceDocumentRuleTest.assertEquals((long)1L, (long)errors.size());
        message = (ErrorMessage)errors.get(0);
        ValidCalcTypeMaintenanceDocumentRuleTest.assertEquals((Object)message.getErrorKey(), (Object)"error.existence");
    }
}

