/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.rules;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.budget.nonpersonnel.ValidCeRateTypeMaintenanceDocumentRule;
import org.kuali.kra.budget.rates.ValidCeRateType;
import org.kuali.kra.maintenance.MaintenanceRuleTestBase;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.util.AutoPopulatingList;

public class ValidCeRateTypeMaintenanceDocumentRuleTest
extends MaintenanceRuleTestBase {
    private ValidCeRateTypeMaintenanceDocumentRule rule = null;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rule = new ValidCeRateTypeMaintenanceDocumentRule();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.rule = null;
        super.tearDown();
    }

    @Test
    public void testOK() throws Exception {
        ValidCeRateType validCeRateType = new ValidCeRateType();
        validCeRateType.setRateClassCode("10");
        validCeRateType.setRateTypeCode("1");
        validCeRateType.setCostElement("422311");
        MaintenanceDocument validCeRateTypeDocument = this.newMaintDoc((PersistableBusinessObject)validCeRateType);
        ValidCeRateTypeMaintenanceDocumentRuleTest.assertTrue((boolean)this.rule.processCustomRouteDocumentBusinessRules(validCeRateTypeDocument));
        ValidCeRateTypeMaintenanceDocumentRuleTest.assertTrue((boolean)this.rule.processCustomApproveDocumentBusinessRules(validCeRateTypeDocument));
    }

    @Test
    public void testRateTypeNotExist() throws Exception {
        ValidCeRateType validCeRateType = new ValidCeRateType();
        validCeRateType.setRateClassCode("10");
        validCeRateType.setRateTypeCode("2");
        validCeRateType.setCostElement("420111");
        MaintenanceDocument validCeRateTypeDocument = this.newMaintDoc((PersistableBusinessObject)validCeRateType);
        ValidCeRateTypeMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomRouteDocumentBusinessRules(validCeRateTypeDocument));
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages("document.newMaintainableObject.rateTypeCode");
        ValidCeRateTypeMaintenanceDocumentRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        ErrorMessage message = (ErrorMessage)errors.get(0);
        ValidCeRateTypeMaintenanceDocumentRuleTest.assertEquals((Object)message.getErrorKey(), (Object)"error.rateType.not.exist");
        ValidCeRateTypeMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomApproveDocumentBusinessRules(validCeRateTypeDocument));
        errors = GlobalVariables.getMessageMap().getMessages("document.newMaintainableObject.rateTypeCode");
        ValidCeRateTypeMaintenanceDocumentRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        message = (ErrorMessage)errors.get(0);
        ValidCeRateTypeMaintenanceDocumentRuleTest.assertEquals((Object)message.getErrorKey(), (Object)"error.rateType.not.exist");
    }

    @Test
    public void testCostElementNotExist() throws Exception {
        ValidCeRateType validCeRateType = new ValidCeRateType();
        validCeRateType.setRateClassCode("10");
        validCeRateType.setRateTypeCode("1");
        validCeRateType.setCostElement("1x");
        MaintenanceDocument validCeRateTypeDocument = this.newMaintDoc((PersistableBusinessObject)validCeRateType);
        ValidCeRateTypeMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomRouteDocumentBusinessRules(validCeRateTypeDocument));
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages("document.newMaintainableObject.costElement");
        ValidCeRateTypeMaintenanceDocumentRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        ErrorMessage message = (ErrorMessage)errors.get(0);
        ValidCeRateTypeMaintenanceDocumentRuleTest.assertEquals((Object)message.getErrorKey(), (Object)"error.existence");
        ValidCeRateTypeMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomApproveDocumentBusinessRules(validCeRateTypeDocument));
        errors = GlobalVariables.getMessageMap().getMessages("document.newMaintainableObject.costElement");
        ValidCeRateTypeMaintenanceDocumentRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        message = (ErrorMessage)errors.get(0);
        ValidCeRateTypeMaintenanceDocumentRuleTest.assertEquals((Object)message.getErrorKey(), (Object)"error.existence");
    }
}

