/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.service;

import java.util.Map;
import java.util.TreeMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.budget.BudgetException;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.CostElement;
import org.kuali.kra.budget.nonpersonnel.BudgetJustificationService;
import org.kuali.kra.budget.nonpersonnel.BudgetJustificationServiceImpl;
import org.kuali.kra.budget.nonpersonnel.BudgetJustificationWrapper;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.parameters.BudgetPeriod;

public class BudgetJustificationServiceTest {
    private Budget budgetDocument;
    private BudgetJustificationService budgetJustificationService;
    private BudgetJustificationWrapper budgetJustificationWrapper;
    private Map<String, CostElement> costElementMap;
    private String userId;

    @Before
    public void setUp() {
        this.initializeCostElementMap();
        this.initializeBudgetJustificationService();
        this.initializeBudgetDocument();
        this.budgetJustificationWrapper = new BudgetJustificationWrapper(null);
    }

    @After
    public void tearDown() {
        this.budgetDocument = null;
        this.budgetJustificationWrapper = null;
        this.budgetJustificationService = null;
    }

    @Test(expected=BudgetException.class)
    public void testJustificationConsolidation_NoLineItemJustifications() throws Exception {
        this.budgetJustificationService.consolidateExpenseJustifications(this.budgetDocument, this.budgetJustificationWrapper);
    }

    @Test
    public void testPreSave() throws Exception {
        this.initializeBudgetJustificationWrapper();
        String originalLastUpdateTime = this.budgetJustificationWrapper.getLastUpdateTime();
        String originalLastUpdateUser = this.budgetJustificationWrapper.getLastUpdateUser();
        this.budgetDocument.setBudgetJustification(this.budgetJustificationWrapper.toString());
        this.userId = "newUser";
        this.budgetJustificationService.preSave(this.budgetDocument, this.budgetJustificationWrapper);
        BudgetJustificationWrapper testWrapper = new BudgetJustificationWrapper(this.budgetDocument.getBudgetJustification());
        Assert.assertTrue((!testWrapper.getLastUpdateTime().equals(originalLastUpdateTime) ? 1 : 0) != 0);
        Assert.assertTrue((!testWrapper.getLastUpdateUser().equals(originalLastUpdateUser) ? 1 : 0) != 0);
        Assert.assertEquals((Object)"newUser", (Object)testWrapper.getLastUpdateUser());
    }

    @Test
    public void testJustificationConsolidation_WithStartingValue_WithNoLineItemJustifications() throws Exception {
        this.initializeBudgetJustificationWrapper();
        String startingValue = this.budgetJustificationWrapper.getJustificationText();
        this.budgetDocument.setBudgetJustification(this.budgetJustificationWrapper.toString());
        try {
            this.budgetJustificationService.consolidateExpenseJustifications(this.budgetDocument, this.budgetJustificationWrapper);
            Assert.assertEquals((Object)this.budgetJustificationWrapper.getJustificationText(), (Object)startingValue);
            Assert.assertTrue((String)("\nStarting text: " + startingValue + "\nConsolidated text:\n" + this.budgetJustificationWrapper.getJustificationText()), (boolean)this.budgetJustificationWrapper.getJustificationText().startsWith(startingValue));
        }
        catch (BudgetException budgetException) {
            // empty catch block
        }
    }

    @Test
    public void testJustificationConsolidation_WithStartingValue_WithLineItemJustifications() throws Exception {
        this.initializeBudgetJustificationWrapper();
        this.addTestLineItemsToBudgetPeriods();
        String startingValue = this.budgetJustificationWrapper.getJustificationText();
        this.budgetDocument.setBudgetJustification(this.budgetJustificationWrapper.toString());
        try {
            this.budgetJustificationService.consolidateExpenseJustifications(this.budgetDocument, this.budgetJustificationWrapper);
            Assert.assertTrue((this.budgetJustificationWrapper.getJustificationText().length() > startingValue.length() ? 1 : 0) != 0);
            Assert.assertTrue((String)("\nStarting text: " + startingValue + "\nConsolidated text:\n" + this.budgetJustificationWrapper.getJustificationText()), (boolean)this.budgetJustificationWrapper.getJustificationText().startsWith(startingValue));
        }
        catch (BudgetException budgetException) {
            // empty catch block
        }
    }

    private void addTestLineItemsToBudgetPeriods() {
        for (BudgetPeriod budgetPeriod : this.budgetDocument.getBudgetPeriods()) {
            int i = 1;
            for (String costElementCode : this.costElementMap.keySet()) {
                BudgetLineItem lineItem = budgetPeriod.getNewBudgetLineItem();
                lineItem.setBudgetPeriod(budgetPeriod.getBudgetPeriod());
                lineItem.setLineItemNumber(new Integer(i));
                lineItem.setLineItemSequence(new Integer(i));
                lineItem.setBudgetJustification(String.format("Line Item %d justification", i++));
                lineItem.setCostElement(costElementCode);
                budgetPeriod.getBudgetLineItems().add(lineItem);
            }
        }
    }

    @Test
    public void testJustificationConsolidation_WithStartingValue_NoLineItemJustifications() throws Exception {
        this.initializeBudgetJustificationWrapper();
        String startingValue = this.budgetJustificationWrapper.toString();
        this.budgetDocument.setBudgetJustification(startingValue);
        try {
            this.budgetJustificationService.consolidateExpenseJustifications(this.budgetDocument, this.budgetJustificationWrapper);
            Assert.assertEquals((Object)startingValue, (Object)this.budgetDocument.getBudgetJustification());
        }
        catch (BudgetException budgetException) {
            // empty catch block
        }
    }

    private void initializeBudgetDocument() {
        this.budgetDocument = new Budget();
        for (int i = 1; i <= 2; ++i) {
            BudgetPeriod budgetPeriod = new BudgetPeriod();
            budgetPeriod.setBudgetPeriod(Integer.valueOf(i));
            this.budgetDocument.getBudgetPeriods().add(budgetPeriod);
        }
    }

    private void initializeBudgetJustificationService() {
        this.budgetJustificationService = new BudgetJustificationServiceImpl(){

            protected Map<String, CostElement> loadCostElements() {
                return BudgetJustificationServiceTest.this.costElementMap;
            }

            protected String getLoggedInUserNetworkId() {
                return BudgetJustificationServiceTest.this.getUserId();
            }
        };
    }

    private void initializeBudgetJustificationWrapper() {
        this.budgetJustificationWrapper.setJustificationText("Starting text");
        this.budgetJustificationWrapper.setLastUpdateTime("01/01/2008 20:10");
        this.budgetJustificationWrapper.setLastUpdateUser("testUser");
    }

    private void initializeCostElementMap() {
        this.costElementMap = new TreeMap<String, CostElement>();
        for (int i = 0; i < 10; ++i) {
            CostElement ce = new CostElement();
            ce.setCostElement("ce" + i);
            ce.setDescription(String.format("Cost Element %d text", i));
            this.costElementMap.put(ce.getCostElement(), ce);
        }
    }

    private String getUserId() {
        return this.userId;
    }
}

