/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.service;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kuali.kra.bo.AbstractInstituteRate;
import org.kuali.kra.bo.InstituteLaRate;
import org.kuali.kra.bo.InstituteRate;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.personnel.BudgetPerson;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.budget.rates.AbstractBudgetRate;
import org.kuali.kra.budget.rates.BudgetLaRate;
import org.kuali.kra.budget.rates.BudgetRate;
import org.kuali.kra.budget.rates.BudgetRatesService;
import org.kuali.kra.budget.rates.BudgetRatesServiceImpl;
import org.kuali.kra.budget.rates.RateClass;
import org.kuali.kra.budget.rates.RateClassType;
import org.kuali.kra.budget.rates.RateType;
import org.kuali.kra.budget.summary.BudgetSummaryService;
import org.kuali.kra.proposaldevelopment.bo.ActivityType;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.service.impl.adapters.BusinessObjectServiceAdapter;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.kra.util.DateUtils;
import org.kuali.rice.krad.service.BusinessObjectService;

public class BudgetRatesServiceTest
extends KcUnitTestBase {
    private static final String TRACK_AFFECTED_PERIOD_1 = "|1|";
    private static final String TRACK_AFFECTED_PERIOD_2 = "|2|";
    private static final double DOUBLE_VALUE_ERROR_LIMIT = 0.01;
    private static final double TEST_INSTITUTE_LA_RATE = 2.5;
    private static final double TEST_INSTITUTE_RATE = 1.5;
    private static final double OLD_APPLICABLE_RATE = 5.75;
    private static final double INSTITUTE_RATE = 7.75;
    private static Map<String, ActivityType> activityTypes;
    private BudgetRatesService budgetRatesService;
    private BudgetDocument budgetDocument;
    private List<InstituteRate> instituteRates;
    private List<InstituteLaRate> instituteLaRates;
    private Date referenceStartDate = DateUtils.newDate((Integer)2006, (Integer)0, (Integer)1);
    private Date budgetPeriod1Start = DateUtils.newDate((Integer)2008, (Integer)6, (Integer)1);
    private Date budgetPeriod1End = DateUtils.newDate((Integer)2009, (Integer)5, (Integer)30);
    private Date budgetPeriod2Start = DateUtils.newDate((Integer)2009, (Integer)6, (Integer)1);
    private Date budgetPeriod2End = DateUtils.newDate((Integer)2010, (Integer)5, (Integer)30);
    private static final String RATE_CLASS_CODE_1 = "1";
    private static final String RATE_CLASS_CODE_2 = "2";
    private static final String RATE_CLASS_CODE_3 = "3";
    private static final String RATE_TYPE_CODE_1 = "1";
    private static final String RATE_TYPE_CODE_2 = "2";
    private static final String RATE_TYPE_CODE_3 = "3";
    private static final String UNIT_NO = "1";
    private static final String RESEARCH_ACTIVITY_CODE = "1";
    private static final String INSTRUCTION_ACTIVITY_CODE = "2";
    private static final String PUBLIC_SERVICE_ACTIVITY_CODE = "3";
    private static final String OTHER_ACTIVITY_CODE = "5";
    private static final String RESEARCH_ACTIVITY_DESCRIPTION = "Research";
    private static final String INSTRUCTION_ACTIVITY_DESCRIPTION = "Instruction";
    private static final String PUBLIC_SERVICE_ACTIVITY_DESCRIPTION = "Public Service";
    private List<RateClass> rateClasses;

    @Test
    public void testResetAllBudgetRates() throws Exception {
        this.setRates(this.budgetDocument.getBudget().getBudgetRates());
        this.setRates(this.budgetDocument.getBudget().getBudgetLaRates());
        this.budgetRatesService.resetAllBudgetRates(this.budgetDocument.getBudget());
        this.checkApplicableRateEqualsInstituteRate(this.budgetDocument.getBudget().getBudgetRates());
        this.checkApplicableRateEqualsInstituteRate(this.budgetDocument.getBudget().getBudgetLaRates());
    }

    @Test
    public void testResetBudgetRatesForRateClassType() throws Exception {
        this.setRates(this.budgetDocument.getBudget().getBudgetRates());
        this.setRates(this.budgetDocument.getBudget().getBudgetLaRates());
        this.budgetRatesService.resetBudgetRatesForRateClassType("3", this.budgetDocument.getBudget());
        this.checkApplicableRateEqualsInstituteRateForRateClass("3", this.budgetDocument.getBudget().getBudgetRates());
        this.checkApplicableRateEqualsInstituteRateForRateClass("3", this.budgetDocument.getBudget().getBudgetLaRates());
    }

    @Test
    public void testSyncAllBudgetRates_ChangingRatesNotProposalActivityType() throws Exception {
        this.changeInstituteRates();
        this.budgetRatesService.syncAllBudgetRates(this.budgetDocument);
        String activityTypeCode = this.budgetDocument.getParentDocument().getBudgetParent().getActivityTypeCode();
        Assert.assertEquals((long)this.countInstituteRatesForActivityTypeCode(activityTypeCode), (long)this.budgetDocument.getBudget().getBudgetRates().size());
        this.checkSyncedRates();
    }

    @Test
    public void testSyncAllBudgetRates_ChangeProposalActivityType() throws Exception {
        ((ProposalDevelopmentDocument)this.budgetDocument.getParentDocument()).getDevelopmentProposal().setActivityTypeCode("2");
        this.changeInstituteRates();
        this.budgetRatesService.syncAllBudgetRates(this.budgetDocument);
        String activityTypeCode = this.budgetDocument.getParentDocument().getBudgetParent().getActivityTypeCode();
        Assert.assertEquals((long)this.countInstituteRatesForActivityTypeCode(activityTypeCode), (long)this.budgetDocument.getBudget().getBudgetRates().size());
        this.checkSyncedRates();
    }

    @Test
    public void testSyncAllBudgetRates_ChangeProposalActivityType2Other() throws Exception {
        ((ProposalDevelopmentDocument)this.budgetDocument.getParentDocument()).getDevelopmentProposal().setActivityTypeCode(OTHER_ACTIVITY_CODE);
        this.changeInstituteRates();
        this.budgetRatesService.syncAllBudgetRates(this.budgetDocument);
        String activityTypeCode = this.budgetDocument.getParentDocument().getBudgetParent().getActivityTypeCode();
        Assert.assertEquals((long)this.countInstituteRatesForActivityTypeCode(activityTypeCode), (long)this.budgetDocument.getBudget().getBudgetRates().size());
        this.checkSyncedRates();
    }

    @Test
    public void testViewLocation() throws Exception {
        this.testViewLocation(this.budgetDocument.getBudget().getBudgetRates());
        this.testViewLocation(this.budgetDocument.getBudget().getBudgetLaRates());
    }

    @BeforeClass
    public static void init() {
        BudgetRatesServiceTest.initializeActivityTypes();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.budgetRatesService = new BudgetRatesServiceImpl();
        ((BudgetRatesServiceImpl)this.budgetRatesService).setBusinessObjectService((BusinessObjectService)new MockBusinessObjectService());
        this.initializeBudgetDocument();
        this.initializeBudgetProposalRates();
        this.initializeInstituteRates();
        this.initializeRateClasses();
    }

    private void initializeBudgetDocument() {
        this.budgetDocument = new BudgetDocument(){};
        Budget budget = this.budgetDocument.getBudget();
        budget.setBudgetVersionNumber(Integer.valueOf(1));
        budget.setBudgetDocument(this.budgetDocument);
        this.budgetDocument.setParentDocument((BudgetParentDocument)this.initializeProposalDevelopmentDocument());
        budget.setStartDate(this.budgetDocument.getParentDocument().getBudgetParent().getRequestedStartDateInitial());
        budget.setEndDate(this.budgetDocument.getParentDocument().getBudgetParent().getRequestedEndDateInitial());
        budget.add(this.generateBudgetPeriod(1, this.budgetPeriod1Start, this.budgetPeriod1End));
        budget.add(this.generateBudgetPeriod(2, this.budgetPeriod2Start, this.budgetPeriod2End));
    }

    private BudgetPeriod generateBudgetPeriod(int periodNo, Date start, Date end) {
        BudgetPeriod bp = new BudgetPeriod();
        bp.setStartDate(start);
        bp.setEndDate(end);
        bp.setBudgetPeriod(Integer.valueOf(periodNo));
        return bp;
    }

    private ProposalDevelopmentDocument initializeProposalDevelopmentDocument() {
        ProposalDevelopmentDocument proposal = new ProposalDevelopmentDocument();
        proposal.getDevelopmentProposal().setActivityTypeCode("1");
        proposal.getDevelopmentProposal().setActivityType(activityTypes.get("1"));
        proposal.getDevelopmentProposal().setOwnedByUnitNumber("1");
        Unit unit = new Unit();
        unit.setUnitNumber("1");
        proposal.getDevelopmentProposal().setOwnedByUnit(unit);
        proposal.getDevelopmentProposal().setRequestedStartDateInitial(this.budgetPeriod1Start);
        proposal.getDevelopmentProposal().setRequestedEndDateInitial(this.budgetPeriod2End);
        return proposal;
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.budgetRatesService = null;
        this.budgetDocument = null;
        this.instituteRates = null;
        this.instituteLaRates = null;
    }

    private static void initializeActivityTypes() {
        activityTypes = new TreeMap<String, ActivityType>();
        activityTypes.put("1", BudgetRatesServiceTest.generateMinimalActivityType("1", RESEARCH_ACTIVITY_DESCRIPTION));
        activityTypes.put("2", BudgetRatesServiceTest.generateMinimalActivityType("2", INSTRUCTION_ACTIVITY_DESCRIPTION));
        activityTypes.put("3", BudgetRatesServiceTest.generateMinimalActivityType("3", PUBLIC_SERVICE_ACTIVITY_DESCRIPTION));
    }

    private static ActivityType generateMinimalActivityType(String activityTypeCode, String description) {
        ActivityType activityType = new ActivityType();
        activityType.setActivityTypeCode(activityTypeCode);
        activityType.setDescription(description);
        return activityType;
    }

    private void changeInstituteRates() {
        for (AbstractInstituteRate abstractInstituteRate : this.instituteRates) {
            abstractInstituteRate.setInstituteRate(new BudgetDecimal(1.5));
        }
        for (AbstractInstituteRate abstractInstituteRate : this.instituteLaRates) {
            abstractInstituteRate.setInstituteRate(new BudgetDecimal(2.5));
        }
    }

    private void checkSyncedRates() {
        for (BudgetRate budgetRate : this.budgetDocument.getBudget().getBudgetRates()) {
            Assert.assertEquals((double)1.5, (double)budgetRate.getInstituteRate().doubleValue(), (double)0.01);
            Assert.assertEquals((double)1.5, (double)budgetRate.getApplicableRate().doubleValue(), (double)0.01);
        }
        for (BudgetLaRate budgetLaRate : this.budgetDocument.getBudget().getBudgetLaRates()) {
            Assert.assertEquals((double)2.5, (double)budgetLaRate.getInstituteRate().doubleValue(), (double)0.01);
            Assert.assertEquals((double)2.5, (double)budgetLaRate.getApplicableRate().doubleValue(), (double)0.01);
        }
    }

    private int countInstituteRatesForActivityTypeCode(String activityTypeCode) {
        int count = 0;
        for (InstituteRate rate : this.instituteRates) {
            if (!rate.getActivityTypeCode().equals(activityTypeCode)) continue;
            ++count;
        }
        return count;
    }

    private void initializeBudgetProposalRates() {
        Budget budget = this.budgetDocument.getBudget();
        budget.add(this.generateBudgetProposalRate("1", "1", "1", this.referenceStartDate, "N"));
        budget.add(this.generateBudgetProposalRate("1", "2", "1", this.referenceStartDate, "N"));
        budget.add(this.generateBudgetProposalRate("1", "2", "2", this.referenceStartDate, "N"));
        budget.add(this.generateBudgetProposalRate("1", "3", "1", this.referenceStartDate, "N"));
        budget.add(this.generateBudgetProposalRate("1", "3", "2", this.referenceStartDate, "N"));
        budget.add(this.generateBudgetProposalRate("1", "3", "3", this.referenceStartDate, "N"));
    }

    private void initializeRateClasses() {
        this.rateClasses = new ArrayList<RateClass>();
        this.rateClasses.add(this.generateRateClass("1", "1"));
        this.rateClasses.add(this.generateRateClass("2", "2"));
        this.rateClasses.add(this.generateRateClass("3", "3"));
        this.budgetDocument.getBudget().setRateClasses(this.rateClasses);
    }

    private RateClass generateRateClass(String rateClassType, String rateClassCode) {
        RateClass rateClass = new RateClass();
        rateClass.setRateClassType(rateClassType);
        rateClass.setRateClassCode(rateClassCode);
        return rateClass;
    }

    private void initializeInstituteRates() {
        this.instituteRates = new ArrayList<InstituteRate>();
        this.instituteLaRates = new ArrayList<InstituteLaRate>();
        this.generateInstituteRate("1", "1", "1");
        this.generateInstituteRate("1", "2", "1");
        this.generateInstituteRate("1", "2", "2");
        this.generateInstituteRate("1", "3", "1");
        this.generateInstituteRate("1", "3", "2");
        this.generateInstituteRate("1", "3", "3");
        this.generateInstituteRate("2", "1", "1");
        this.generateInstituteRate("2", "2", "2");
        this.generateInstituteRate("2", "3", "3");
        this.generateInstituteRate("3", "1", "1");
        this.generateInstituteRate("3", "1", "2");
        this.generateInstituteRate("3", "3", "3");
        this.generateInstituteRate("3", "2", "1");
        this.generateInstituteRate("3", "2", "2");
        this.generateInstituteRate("3", "2", "3");
        this.generateInstituteRate("3", "3", "1");
        this.generateInstituteRate("3", "3", "2");
        this.generateInstituteRate("3", "3", "3");
    }

    private BudgetDecimal generateDefaultRate(AbstractInstituteRate instituteRate) {
        return new BudgetDecimal(instituteRate.getRateClassCode() + "." + instituteRate.getRateTypeCode());
    }

    private void generateInstituteRate(String activityTypeCode, String rateClassCode, String rateTypeCode) {
        InstituteRate instituteRate = new InstituteRate();
        this.initializeInstitutionRate((AbstractInstituteRate)instituteRate, activityTypeCode, rateClassCode, rateTypeCode);
        this.instituteRates.add(instituteRate);
        InstituteLaRate instituteLaRate = new InstituteLaRate();
        this.initializeInstitutionRate((AbstractInstituteRate)instituteLaRate, activityTypeCode, rateClassCode, rateTypeCode);
        this.instituteLaRates.add(instituteLaRate);
    }

    private void initializeInstitutionRate(AbstractInstituteRate instituteRate, String activityTypeCode, String rateClassCode, String rateTypeCode) {
        instituteRate.setUnitNumber("1");
        if (instituteRate instanceof InstituteRate) {
            InstituteRate instRate = (InstituteRate)instituteRate;
            instRate.setActivityTypeCode(activityTypeCode);
            instRate.setActivityType(activityTypes.get(activityTypeCode));
        }
        instituteRate.setRateClassCode(rateClassCode);
        RateClass rateClass = new RateClass();
        RateClassType rateClassType = new RateClassType();
        rateClassType.setRateClassType("O");
        rateClassType.setPrefixActivityType(Boolean.valueOf(false));
        rateClassType.setSortId("1");
        rateClass.setRateClassType("O");
        rateClass.setRateClassTypeT(rateClassType);
        instituteRate.setRateClass(rateClass);
        instituteRate.setRateTypeCode(rateTypeCode);
        RateType rateType = new RateType();
        rateType.setDescription(rateTypeCode);
        instituteRate.setRateType(rateType);
        instituteRate.setStartDate(this.referenceStartDate);
        instituteRate.setOnOffCampusFlag(Boolean.valueOf(true));
        instituteRate.setInstituteRate(this.generateDefaultRate(instituteRate));
        instituteRate.setFiscalYear("2006");
    }

    private BudgetRate generateBudgetProposalRate(String activityTypeCode, String rateClassCode, String rateTypeCode, Date startDate, String onOffCampusFlag) {
        BudgetRate budgetRate = new BudgetRate();
        budgetRate.setActivityTypeCode(activityTypeCode);
        budgetRate.setRateClassCode(rateClassCode);
        budgetRate.setRateTypeCode(rateTypeCode);
        RateType rateType = new RateType();
        rateType.setDescription(rateTypeCode);
        budgetRate.setRateType(rateType);
        budgetRate.setStartDate(this.referenceStartDate);
        budgetRate.setOnOffCampusFlag(Boolean.valueOf("N".equals(onOffCampusFlag)));
        budgetRate.setFiscalYear("2008");
        return budgetRate;
    }

    private void checkApplicableRateEqualsInstituteRate(List rates) {
        List abstractBudgetRates = rates;
        for (AbstractBudgetRate budgetRate : abstractBudgetRates) {
            Assert.assertEquals((Object)budgetRate.getInstituteRate(), (Object)budgetRate.getApplicableRate());
        }
    }

    private void checkApplicableRateEqualsInstituteRateForRateClass(String rateClassType, List rates) {
        List abstractBudgetRates = rates;
        for (AbstractBudgetRate budgetRate : abstractBudgetRates) {
            if (budgetRate.getRateClass().getRateClassType().equals(rateClassType)) {
                Assert.assertEquals((Object)budgetRate.getInstituteRate(), (Object)budgetRate.getApplicableRate());
                continue;
            }
            Assert.assertEquals((double)5.75, (double)budgetRate.getApplicableRate().doubleValue(), (double)0.01);
        }
    }

    private void setRates(List rateList) {
        List abstractBudgetRates = rateList;
        for (AbstractBudgetRate budgetRate : abstractBudgetRates) {
            budgetRate.setApplicableRate(new BudgetDecimal(5.75));
            budgetRate.setInstituteRate(new BudgetDecimal(7.75));
            budgetRate.setRateClass(this.rateClasses.get(Integer.valueOf(budgetRate.getRateClassCode()) - 1));
            budgetRate.setRateClassCode(this.rateClasses.get(Integer.valueOf(budgetRate.getRateClassCode()) - 1).getRateClassCode());
        }
    }

    private void testViewLocation(List budgetRates) throws Exception {
        List abstractBudgetRates = budgetRates;
        this.testViewLocation_DisplayLocation(abstractBudgetRates, TRACK_AFFECTED_PERIOD_1, 2, false);
        this.testViewLocation_DisplayLocation(abstractBudgetRates, TRACK_AFFECTED_PERIOD_2, 2, true);
    }

    private void testViewLocation_DisplayLocation(List<AbstractBudgetRate> abstractBudgetRates, String trackAffectedPeriod, Integer budgetPeriod, boolean expectedResults) throws Exception {
        for (AbstractBudgetRate rate : abstractBudgetRates) {
            rate.setTrackAffectedPeriod(trackAffectedPeriod);
        }
        this.budgetRatesService.viewLocation("N", budgetPeriod, this.budgetDocument.getBudget());
        for (AbstractBudgetRate rate : abstractBudgetRates) {
            Assert.assertEquals((Object)expectedResults, (Object)rate.isDisplayLocation());
        }
    }

    public class MockBudgetSummaryService
    implements BudgetSummaryService {
        public void addBudgetPeriod(Budget budgetDocument, BudgetPeriod newBudgetPeriod) {
        }

        public boolean budgetLineItemExists(Budget budgetDocument, Integer budgetPeriod) {
            return false;
        }

        public void calculateBudget(Budget budgetDocument) {
        }

        public void deleteBudgetPeriod(Budget budgetDocument, int delPeriod) {
        }

        public void generateAllPeriods(Budget budgetDocument) {
        }

        public Collection<BudgetLineItem> getBudgetLineItemForPeriod(Budget budgetDocument, int budgetPeriodNumber) {
            return null;
        }

        public Collection<BudgetPersonnelDetails> getBudgetPersonnelDetailsForPeriod(Budget budgetDocument, int budgetPeriodNumber) {
            return null;
        }

        public void updateOnOffCampusFlag(Budget budgetDocument, String onOffCampusFlag) {
        }

        public void adjustStartEndDatesForLineItems(Budget budgetDocument) {
        }

        public void setupOldStartEndDate(Budget budgetDocument, boolean resetAll) {
        }

        public void setupOldStartEndDate(List<BudgetLineItem> budgetLineItems) {
        }

        public List<Date> getNewStartEndDates(List<Date> startEndDates, int gap, int duration, Date prevDate, boolean leapDayInPeriod, boolean leapDayInGap) {
            return new ArrayList<Date>();
        }

        public boolean isLeapDaysInPeriod(Date sDate, Date eDate) {
            return false;
        }

        public String getOnOffCampusFlagDescription(String onOffCampusFlag) {
            return "";
        }

        public void defaultBudgetPeriods(Budget budgetDocument) {
        }

        public String defaultWarningMessage(Budget budgetDocument) {
            return "";
        }

        public void generateBudgetPeriods(Budget budget, List<BudgetPeriod> budgetPeriods) {
        }
    }

    public class MockBusinessObjectService
    extends BusinessObjectServiceAdapter {
        public Collection findMatching(Class clazz, Map fieldValues) {
            Collection results = clazz.equals(InstituteRate.class) ? this.findMatchingInstituteRates(fieldValues) : (clazz.equals(InstituteLaRate.class) ? this.findMatchingInstituteLaRates(fieldValues) : (clazz.equals(BudgetPerson.class) ? this.findMatchingBudgetPersons(fieldValues) : null));
            return results;
        }

        private Collection findMatchingInstituteRates(Map fieldValues) {
            String activityTypeCode = (String)fieldValues.get("activityTypeCode");
            String unitNumber = (String)fieldValues.get("unitNumber");
            ArrayList<InstituteRate> filteredInstituteRates = new ArrayList<InstituteRate>();
            for (InstituteRate testRate : BudgetRatesServiceTest.this.instituteRates) {
                if (!testRate.getUnitNumber().equals(unitNumber) || !testRate.getActivityTypeCode().equals(activityTypeCode) && activityTypeCode != null) continue;
                filteredInstituteRates.add(testRate);
            }
            return filteredInstituteRates;
        }

        private Collection findMatchingInstituteLaRates(Map fieldValues) {
            String unitNumber = (String)fieldValues.get("unitNumber");
            ArrayList<InstituteLaRate> filteredInstituteLaRates = new ArrayList<InstituteLaRate>();
            for (InstituteLaRate testRate : BudgetRatesServiceTest.this.instituteLaRates) {
                if (!testRate.getUnitNumber().equals(unitNumber)) continue;
                filteredInstituteLaRates.add(testRate);
            }
            return filteredInstituteLaRates;
        }

        private Collection findMatchingBudgetPersons(Map fieldValues) {
            Integer bvNumber = (Integer)fieldValues.get("budgetId");
            ArrayList<BudgetPerson> budgetPersons = new ArrayList<BudgetPerson>();
            for (BudgetPerson budgetPerson : budgetPersons) {
                if (!budgetPerson.getBudgetId().equals(bvNumber)) continue;
                budgetPersons.add(budgetPerson);
            }
            return budgetPersons;
        }
    }
}

