/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.service;

import java.sql.Date;
import java.util.UUID;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.budget.core.BudgetCommonService;
import org.kuali.kra.budget.core.BudgetService;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.proposaldevelopment.budget.service.ProposalBudgetService;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.service.ProposalDevelopmentService;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;

public class BudgetServiceTest
extends KcUnitTestBase {
    private BudgetService budgetService;
    private BudgetCommonService budgetCommonService;
    private ProposalDevelopmentService proposalDevelopmentService;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        this.budgetService = this.getService(BudgetService.class);
        this.budgetCommonService = (BudgetCommonService)this.getService(ProposalBudgetService.class);
        this.proposalDevelopmentService = this.getService(ProposalDevelopmentService.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        GlobalVariables.setUserSession(null);
        this.budgetService = null;
        super.tearDown();
    }

    @Test
    public void testGetNewBudgetVersion() throws Exception {
        ProposalDevelopmentDocument pdDocument = this.getPersistedProposalDevelopmentDocument();
        String testProposalNumber = pdDocument.getDevelopmentProposal().getProposalNumber();
        String testDocumentDescription = "Test New Budget Doc";
        UserSession currentSession = GlobalVariables.getUserSession();
        String kualiSessionId = currentSession.getKualiSessionId();
        if (kualiSessionId == null) {
            kualiSessionId = UUID.randomUUID().toString();
            currentSession.setKualiSessionId(kualiSessionId);
        }
        PessimisticLock lock = KRADServiceLocatorWeb.getPessimisticLockService().generateNewLock(pdDocument.getDocumentNumber(), pdDocument.getDocumentNumber() + "-BUDGET", currentSession.getPerson());
        pdDocument.addPessimisticLock(lock);
        BudgetDocument budgetDocument = this.budgetCommonService.getNewBudgetVersion((BudgetParentDocument)pdDocument, testDocumentDescription);
        BudgetServiceTest.assertTrue((boolean)budgetDocument.getDocumentHeader().getWorkflowDocument().isApproved());
        BudgetServiceTest.assertEquals((Object)((ProposalDevelopmentDocument)budgetDocument.getParentDocument()).getDevelopmentProposal().getProposalNumber(), (Object)testProposalNumber);
        BudgetServiceTest.assertEquals((Object)budgetDocument.getDocumentHeader().getDocumentDescription(), (Object)testDocumentDescription);
    }

    public void testCopyBudgetVersion() throws Exception {
        ProposalDevelopmentDocument pdDocument = this.getPersistedProposalDevelopmentDocument();
        String testProposalNumber = pdDocument.getDevelopmentProposal().getProposalNumber();
        String testDocumentDescription = "Test Copy Budget Doc";
        BudgetDocument budgetDocument = this.budgetCommonService.getNewBudgetVersion((BudgetParentDocument)pdDocument, testDocumentDescription);
        BudgetDocument copyBudgetDocument = this.budgetCommonService.copyBudgetVersion(budgetDocument);
        BudgetServiceTest.assertTrue((boolean)budgetDocument.getDocumentHeader().getWorkflowDocument().isApproved());
        BudgetServiceTest.assertEquals((Object)((ProposalDevelopmentDocument)copyBudgetDocument.getParentDocument()).getDevelopmentProposal().getProposalNumber(), (Object)testProposalNumber);
        BudgetServiceTest.assertEquals((Object)copyBudgetDocument.getDocumentHeader().getDocumentDescription(), (Object)testDocumentDescription);
    }

    protected ProposalDevelopmentDocument getPersistedProposalDevelopmentDocument() throws Exception {
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)this.getDocumentService().getNewDocument(ProposalDevelopmentDocument.class);
        pdDocument.getDocumentHeader().setDocumentDescription("Testing budget versions");
        pdDocument.getDevelopmentProposal().setActivityTypeCode("2");
        pdDocument.getDevelopmentProposal().setOwnedByUnitNumber("IN-CARD");
        pdDocument.getDevelopmentProposal().setProposalTypeCode("1");
        pdDocument.getDevelopmentProposal().setTitle("Testing budget versions");
        pdDocument.getDevelopmentProposal().setSponsorCode("005770");
        pdDocument.getDevelopmentProposal().setRequestedStartDateInitial(new Date(0L));
        pdDocument.getDevelopmentProposal().setRequestedEndDateInitial(new Date(0L));
        pdDocument.getDevelopmentProposal().setPrimeSponsorCode("000120");
        this.proposalDevelopmentService.initializeUnitOrganizationLocation(pdDocument);
        this.proposalDevelopmentService.initializeProposalSiteNumbers(pdDocument);
        this.getDocumentService().saveDocument((Document)pdDocument);
        pdDocument.getDevelopmentProposal().refreshReferenceObject("ownedByUnit");
        PersonService personService = this.getService(PersonService.class);
        Person user = personService.getPersonByPrincipalName("quickstart");
        this.getService(KraAuthorizationService.class).addRole(user.getPrincipalId(), "Aggregator", (Permissionable)pdDocument);
        return pdDocument;
    }
}

