/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.web;

import java.util.Collection;
import java.util.LinkedHashMap;
import org.apache.commons.lang.math.NumberUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.web.MaintenanceDocumentSeleniumHelper;
import org.kuali.kra.budget.core.BudgetCategory;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;
import org.kuali.rice.kns.document.MaintenanceDocumentBase;

public class BudgetCategoryMaintenanceDocumentSeleniumTest
extends KcSeleniumTestBase {
    private static final String DOCUMENT_TITLE = "Budget Category";
    private static final String MAINTENANCE_DOCUMENT_TITLE = "Kuali :: Budget Category Maintenance Document";
    private static final String BUDGET_CATEGORY_CODE_ID = "budgetCategoryCode";
    private static final String BUDGET_CATEGORY_TYPE_CODE_ID = "budgetCategoryTypeCode";
    private static final String DESCRIPTION_ID = "description";
    private static final String CREATE_DOCUMENT_DESCRIPTION = "Budget Category - Test Create";
    private static final String CREATE_DESCRIPTION = "Test Create Budget Category";
    private static final String EDIT_DOCUMENT_DESCRIPTION = "Budget Category - Test Edit";
    private static final String EDIT_DESCRIPTION_1 = "Test Edit Budget Category (Before)";
    private static final String EDIT_DESCRIPTION_2 = "Test Edit Budget Category (After)";
    private static final String COPY_DOCUMENT_DESCRIPTION = "Budget Category - Test Copy";
    private static final String COPY_DESCRIPTION_1 = "Test Copy Budget Category (Before)";
    private static final String COPY_DESCRIPTION_2 = "Test Copy Budget Category (After)";
    private static final String DEFAULT_BUDGET_CATEGORY_TYPE_CODE = "O";
    private MaintenanceDocumentSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = MaintenanceDocumentSeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testCreateBudgetCategory() throws Exception {
        String budgetCategoryCode = this.getNewBudgetCategoryCode();
        String documentNumber = this.createNewMaintenanceDocument(CREATE_DOCUMENT_DESCRIPTION, budgetCategoryCode, CREATE_DESCRIPTION);
        this.verifyExistingMaintenanceDocument(documentNumber, budgetCategoryCode, CREATE_DESCRIPTION);
    }

    @Test
    public void testEditBudgetCategory() throws Exception {
        String budgetCategoryCode = this.getNewBudgetCategoryCode();
        this.createNewMaintenanceDocument(EDIT_DOCUMENT_DESCRIPTION, budgetCategoryCode, EDIT_DESCRIPTION_1);
        LinkedHashMap<String, String> searchValues = new LinkedHashMap<String, String>();
        searchValues.put(BUDGET_CATEGORY_CODE_ID, budgetCategoryCode);
        String documentNumber = this.helper.editMaintenanceDocument(DOCUMENT_TITLE, BudgetCategory.class.getName(), searchValues, MAINTENANCE_DOCUMENT_TITLE);
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put(DESCRIPTION_ID, EDIT_DESCRIPTION_2);
        this.helper.populateMaintenanceDocument(EDIT_DOCUMENT_DESCRIPTION, fieldValues);
        this.helper.routeDocument();
        this.helper.assertRoute();
        this.verifyExistingMaintenanceDocument(documentNumber, budgetCategoryCode, EDIT_DESCRIPTION_2);
    }

    @Test
    public void testCopyBudgetCategory() throws Exception {
        String budgetCategoryCode1 = this.getNewBudgetCategoryCode();
        this.createNewMaintenanceDocument(COPY_DOCUMENT_DESCRIPTION, budgetCategoryCode1, COPY_DESCRIPTION_1);
        LinkedHashMap<String, String> searchValues = new LinkedHashMap<String, String>();
        searchValues.put(BUDGET_CATEGORY_CODE_ID, budgetCategoryCode1);
        String documentNumber = this.helper.copyMaintenanceDocument(DOCUMENT_TITLE, BudgetCategory.class.getName(), searchValues, MAINTENANCE_DOCUMENT_TITLE);
        String budgetCategoryCode2 = this.getNewBudgetCategoryCode();
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put(BUDGET_CATEGORY_CODE_ID, budgetCategoryCode2);
        fieldValues.put(DESCRIPTION_ID, COPY_DESCRIPTION_2);
        this.helper.populateMaintenanceDocument(COPY_DOCUMENT_DESCRIPTION, fieldValues);
        this.helper.routeDocument();
        this.helper.assertRoute();
        this.verifyExistingMaintenanceDocument(documentNumber, budgetCategoryCode2, COPY_DESCRIPTION_2);
    }

    private String createNewMaintenanceDocument(String documentDescription, String budgetCategoryCode, String description) {
        String documentNumber = this.helper.createMaintenanceDocument(DOCUMENT_TITLE, BudgetCategory.class.getName(), MAINTENANCE_DOCUMENT_TITLE);
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put(BUDGET_CATEGORY_CODE_ID, budgetCategoryCode);
        fieldValues.put(BUDGET_CATEGORY_TYPE_CODE_ID, DEFAULT_BUDGET_CATEGORY_TYPE_CODE);
        fieldValues.put(DESCRIPTION_ID, description);
        this.helper.populateMaintenanceDocument(documentDescription, fieldValues);
        this.helper.routeDocument();
        this.helper.assertRoute();
        return documentNumber;
    }

    private void verifyExistingMaintenanceDocument(String documentNumber, String budgetCategoryCode, String description) throws Exception {
        MaintenanceDocumentBase document = (MaintenanceDocumentBase)this.getDocumentService().getByDocumentHeaderId(documentNumber);
        BudgetCategoryMaintenanceDocumentSeleniumTest.assertNotNull((Object)document.getDocumentNumber());
        BudgetCategoryMaintenanceDocumentSeleniumTest.assertNotNull((Object)document.getDocumentHeader());
        BudgetCategoryMaintenanceDocumentSeleniumTest.assertEquals((Object)documentNumber, (Object)document.getDocumentHeader().getDocumentNumber());
        BudgetCategory budgetCategory = (BudgetCategory)document.getNewMaintainableObject().getDataObject();
        BudgetCategoryMaintenanceDocumentSeleniumTest.assertEquals((Object)budgetCategoryCode, (Object)budgetCategory.getBudgetCategoryCode());
        BudgetCategoryMaintenanceDocumentSeleniumTest.assertEquals((Object)DEFAULT_BUDGET_CATEGORY_TYPE_CODE, (Object)budgetCategory.getBudgetCategoryTypeCode());
        BudgetCategoryMaintenanceDocumentSeleniumTest.assertEquals((Object)description, (Object)budgetCategory.getDescription());
    }

    private String getNewBudgetCategoryCode() {
        int maxBudgetCategoryCode = 1;
        Collection budgetCategories = this.getBusinessObjectService().findAll(BudgetCategory.class);
        for (BudgetCategory budgetCategory : budgetCategories) {
            int budgetCategoryCode = NumberUtils.toInt((String)budgetCategory.getBudgetCategoryCode(), (int)1);
            if (budgetCategoryCode <= maxBudgetCategoryCode) continue;
            maxBudgetCategoryCode = budgetCategoryCode;
        }
        return String.valueOf(maxBudgetCategoryCode + 1);
    }
}

