/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.web;

import java.util.HashMap;
import java.util.Map;
import org.kuali.kra.test.infrastructure.KcSeleniumHelper;
import org.openqa.selenium.WebDriver;

public class BudgetSeleniumHelper
extends KcSeleniumHelper {
    private static final String VERSIONS_LINK_NAME = "versions";
    private static final String PARAMETERS_LINK_NAME = "parameters";
    private static final String RATES_LINK_NAME = "rates";
    private static final String SUMMARY_LINK_NAME = "summaryTotals";
    private static final String PERSONNEL_LINK_NAME = "personnel";
    private static final String NON_PERSONNEL_LINK_NAME = "expenses";
    private static final String DISTRIBUTION_AND_INCOME_LINK_NAME = "distributionAndIncome";
    private static final String MODULAR_BUDGET_LINK_NAME = "modularBudget";
    private static final String ACTIONS_LINK_NAME = "budgetActions";
    private static final String LIST_PREFIX = "document.budget.";
    private static final String BUDGET_RATES_PREFIX = "budgetRates";
    private static final String APPLICABLE_RATE_ID = "applicableRate";
    private static final String BUDGET_PERIOD_PREFIX = "document.budget.budgetPeriod";
    private static final String NEW_LINE_ITEM_PREFIX = "newBudgetLineItems";
    private static final String NEW_PERSON_TAG = "newBudgetPersons";
    private static final String PERSON_ID_ID = "personId";
    private static final String NEW_ROLODEX_TAG = "newBudgetRolodexes";
    private static final String ROLODEX_ID_ID = "rolodexId";
    private static final String BUDGET_PERSON_LIST_PREFIX = "document.budget.budgetPersons";
    private static final String PERSON_JOB_CODE_ID = "jobCode";
    private static final String PERSON_SALARY_ID = "calculationBase";
    private static final String NEW_PERSON_ID = "newBudgetPersonnelDetails.personSequenceNumber";
    private static final String COST_ELEMENT_ID = "costElement";
    private static final String NEW_COST_ELEMENT_ID = "newBudgetLineItems[0].costElement";
    private static final String BUDGET_LINE_ITEM_PREFIX = "budgetLineItem";
    private static final String PERSONNEL_DETAILS_PREFIX = "budgetPersonnelDetailsList";
    private static final String PERCENT_EFFORT_ID = "percentEffort";
    private static final String PERCENT_CHARGED_ID = "percentCharged";
    private static final String LINE_ITEM_COST_ID = "lineItemCost";
    private static final String ITEM_QUANTITY_ID = "quantity";
    private static final String COST_SHARE_PREFIX = "document.budget.budgetCostShare";
    private static final String UNRECOVERED_FA_PREFIX = "document.budget.budgetUnrecoveredFandA";
    private static final String ACCOUNT_ID_ID = "ACCOUNT_ID";
    private static final String AMOUNT_ID_ID = "AMOUNT_ID";
    private static final String DEFAULT_JOB_CODE = "AA023";
    private static final String DEFAULT_SALARY_AMOUNT = "100000";
    private static final String DEFAULT_PI_NAME = "Nicholas Majors";
    private static final String DEFAULT_JOB_CODE_NAME = "Faculty Salaries Non-Tenured - On";
    private static final String DEFAULT_PERCENT_CHARGED = "100";
    private static final String DEFAULT_PERCENT_EFFORT = "100";
    private static final String DEFAULT_LINE_ITEM_DESC1 = "Equipment - Not MTDC";
    private static final String DEFAULT_LINE_ITEM_QUANTITY1 = "1";
    private static final String DEFAULT_LINE_ITEM_DESC2 = "Travel";
    private static final String DEFAULT_LINE_ITEM_QUANTITY2 = null;
    private static final String DEFAULT_LINE_ITEM_AMT = "1000";
    private static final String ADD_NEW_PERSON_BUTTON = "addPersonnelLineItem.budgetCategoryTypeCodeP";
    private static final String ADD_BUDGET_LINE_ITEM_BUTTON = "addBudgetLineItem.budgetCategoryTypeCode";
    private static final String RETURN_TO_PROPOSAL_BUTTON = "methodToCall.returnToProposal";
    private static final String RETURN_TO_AWARD_BUTTON = "methodToCall.returnToAward";
    private static final String POST_BUDGET_BUTTON = "methodToCall.postAwardBudget";
    private static BudgetSeleniumHelper helper;
    private Map<Integer, String> lineItemTypeIdxToTypeCode = new HashMap<Integer, String>();

    public static BudgetSeleniumHelper instance(WebDriver driver) {
        if (helper == null) {
            helper = new BudgetSeleniumHelper(driver);
        }
        return helper;
    }

    private BudgetSeleniumHelper(WebDriver driver) {
        super(driver);
        this.lineItemTypeIdxToTypeCode.put(0, "E");
        this.lineItemTypeIdxToTypeCode.put(1, "T");
        this.lineItemTypeIdxToTypeCode.put(2, "T");
        this.lineItemTypeIdxToTypeCode.put(3, "O");
    }

    public void clickBudgetVersionsTab() {
        this.click(VERSIONS_LINK_NAME);
    }

    public void clickBudgetParametersTab() {
        this.click(PARAMETERS_LINK_NAME);
    }

    public void clickBudgetRatesTab() {
        this.click(RATES_LINK_NAME);
    }

    public void clickBudgetSummaryTab() {
        this.click(SUMMARY_LINK_NAME);
    }

    public void clickBudgetPersonnelTab() {
        this.click(PERSONNEL_LINK_NAME);
    }

    public void clickBudgetNonPersonnelTab() {
        this.click(NON_PERSONNEL_LINK_NAME);
    }

    public void clickBudgetDistributionAndIncomeTab() {
        this.click(DISTRIBUTION_AND_INCOME_LINK_NAME);
    }

    public void clickBudgetModularBudgetTab() {
        this.click(MODULAR_BUDGET_LINK_NAME);
    }

    public void clickBudgetActionsTab() {
        this.click(ACTIONS_LINK_NAME);
    }

    public void returnToProposal() {
        this.click(RETURN_TO_PROPOSAL_BUTTON);
    }

    public void returnToAward() {
        this.click(RETURN_TO_AWARD_BUTTON);
    }

    public void addPersonnel() {
        this.clickBudgetPersonnelTab();
        this.clickYesAnswer();
        this.setPersonDetails(0, DEFAULT_JOB_CODE, DEFAULT_SALARY_AMOUNT);
        this.clickBudgetPersonnelTab();
        this.clickExpandAll();
        this.addPersonnelDetail(DEFAULT_PI_NAME, DEFAULT_JOB_CODE, DEFAULT_JOB_CODE_NAME);
        this.setPersonPercents(0, 0, 0, "100", "100");
    }

    public void addNonPersonnel() {
        this.clickBudgetNonPersonnelTab();
        this.addLineItem(0, DEFAULT_LINE_ITEM_DESC1, DEFAULT_LINE_ITEM_QUANTITY1, DEFAULT_LINE_ITEM_AMT);
        this.addLineItem(1, DEFAULT_LINE_ITEM_DESC2, DEFAULT_LINE_ITEM_QUANTITY2, DEFAULT_LINE_ITEM_AMT);
        this.saveDocument();
    }

    public void setRate(int index, String rate) {
        this.set("document.budget.budgetRates[" + index + "]." + APPLICABLE_RATE_ID, rate);
    }

    public void addPerson(String personId) {
        this.multiLookup(NEW_PERSON_TAG, PERSON_ID_ID, personId);
    }

    public void addRolodex(String rolodexId) {
        this.multiLookup(NEW_ROLODEX_TAG, ROLODEX_ID_ID, rolodexId);
    }

    public void setPersonDetails(int personIndex, String jobCode, String calculationBase) {
        String personPrefix = "document.budget.budgetPersons[" + personIndex + "].";
        this.set(personPrefix + PERSON_JOB_CODE_ID, jobCode);
        this.set(personPrefix + PERSON_SALARY_ID, calculationBase);
    }

    public void addPersonnelDetail(String personName, String jobCode, String jobCodeName) {
        this.set(NEW_PERSON_ID, personName + " - " + jobCode);
        this.set(NEW_COST_ELEMENT_ID, jobCodeName);
        this.click(ADD_NEW_PERSON_BUTTON);
    }

    public void setPersonPercents(int budgetPeriod, int lineItem, int detailsIdx, String percentEffort, String percentCharged) {
        String prefix = "document.budget.budgetPeriod[" + budgetPeriod + "]." + BUDGET_LINE_ITEM_PREFIX + "[" + lineItem + "]." + PERSONNEL_DETAILS_PREFIX + "[" + detailsIdx + "].";
        this.set(prefix + PERCENT_EFFORT_ID, percentEffort);
        this.set(prefix + PERCENT_CHARGED_ID, percentCharged);
    }

    public void addLineItem(Integer itemTypeIdx, String itemDescription, String quantity, String amount) {
        this.clickExpandAll();
        String prefix = "newBudgetLineItems[" + itemTypeIdx + "].";
        this.set(prefix + COST_ELEMENT_ID, itemDescription);
        this.set(prefix + LINE_ITEM_COST_ID, amount);
        this.set(prefix + ITEM_QUANTITY_ID, quantity);
        this.click(ADD_BUDGET_LINE_ITEM_BUTTON + this.lineItemTypeIdxToTypeCode.get(itemTypeIdx));
    }

    public void populateCostShare(int index, String account, String amount) {
        String prefix = "document.budget.budgetCostShare[" + index + "].";
        this.set(prefix + ACCOUNT_ID_ID, account);
        if (amount != null) {
            this.set(prefix + AMOUNT_ID_ID, amount);
        }
    }

    public void populateUnrecoveredFandA(int index, String account, String amount) {
        String prefix = "document.budget.budgetUnrecoveredFandA[" + index + "].";
        this.set(prefix + ACCOUNT_ID_ID, account);
        if (amount != null) {
            this.set(prefix + AMOUNT_ID_ID, amount);
        }
    }

    public void postBudget() {
        this.click(POST_BUDGET_BUTTON);
    }
}

