/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.web;

import java.util.Collection;
import java.util.LinkedHashMap;
import org.apache.commons.lang.math.NumberUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.web.MaintenanceDocumentSeleniumHelper;
import org.kuali.kra.budget.core.CostElement;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;
import org.kuali.rice.kns.document.MaintenanceDocumentBase;

public class CostElementMaintenanceDocumentSeleniumTest
extends KcSeleniumTestBase {
    private static final String DOCUMENT_TITLE = "Object Code";
    private static final String MAINTENANCE_DOCUMENT_TITLE = "Kuali :: Cost Element Maintenance Document";
    private static final String COST_ELEMENT_ID = "costElement";
    private static final String BUDGET_CATEGORY_CODE_ID = "budgetCategoryCode";
    private static final String DESCRIPTION_ID = "description";
    private static final String ON_OFF_CAMPUS_FLAG_ID = "onOffCampusFlag";
    private static final String ACTIVE_ID = "active";
    private static final String CREATE_DOCUMENT_DESCRIPTION = "Cost Element - Test Create";
    private static final String CREATE_DESCRIPTION = "Test Create Cost Element";
    private static final boolean CREATE_ON_OFF_CAMPUS_FLAG = false;
    private static final String EDIT_DOCUMENT_DESCRIPTION = "Cost Element - Test Edit";
    private static final String EDIT_DESCRIPTION_1 = "Test Edit Cost Element (Before)";
    private static final String EDIT_DESCRIPTION_2 = "Test Edit Cost Element (After)";
    private static final boolean EDIT_ON_OFF_CAMPUS_FLAG_1 = false;
    private static final boolean EDIT_ON_OFF_CAMPUS_FLAG_2 = true;
    private static final String COPY_DOCUMENT_DESCRIPTION = "Cost Element - Test Copy";
    private static final String COPY_DESCRIPTION_1 = "Test Copy Cost Element (Before)";
    private static final String COPY_DESCRIPTION_2 = "Test Copy Cost Element (After)";
    private static final boolean COPY_ON_OFF_CAMPUS_FLAG_1 = false;
    private static final boolean COPY_ON_OFF_CAMPUS_FLAG_2 = true;
    private static final String DEFAULT_BUDGET_CATEGORY_CODE = "3";
    private static final boolean DEFAULT_ACTIVE = true;
    private MaintenanceDocumentSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = MaintenanceDocumentSeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testCreateCostElement() throws Exception {
        String costElementCode = this.getNewCostElementCode();
        String documentNumber = this.createNewMaintenanceDocument(CREATE_DOCUMENT_DESCRIPTION, costElementCode, CREATE_DESCRIPTION, false);
        this.verifyExistingMaintenanceDocument(documentNumber, costElementCode, CREATE_DESCRIPTION, false);
    }

    @Test
    public void testEditCostElement() throws Exception {
        String costElementCode = this.getNewCostElementCode();
        this.createNewMaintenanceDocument(EDIT_DOCUMENT_DESCRIPTION, costElementCode, EDIT_DESCRIPTION_1, false);
        LinkedHashMap<String, String> searchValues = new LinkedHashMap<String, String>();
        searchValues.put(COST_ELEMENT_ID, costElementCode);
        String documentNumber = this.helper.editMaintenanceDocument(DOCUMENT_TITLE, CostElement.class.getName(), searchValues, MAINTENANCE_DOCUMENT_TITLE);
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put(DESCRIPTION_ID, EDIT_DESCRIPTION_2);
        fieldValues.put(ON_OFF_CAMPUS_FLAG_ID, String.valueOf(true));
        this.helper.populateMaintenanceDocument(EDIT_DOCUMENT_DESCRIPTION, fieldValues);
        this.helper.routeDocument();
        this.helper.assertRoute();
        this.verifyExistingMaintenanceDocument(documentNumber, costElementCode, EDIT_DESCRIPTION_2, true);
    }

    @Test
    public void testCopyCostElement() throws Exception {
        String costElementCode1 = this.getNewCostElementCode();
        this.createNewMaintenanceDocument(COPY_DOCUMENT_DESCRIPTION, costElementCode1, COPY_DESCRIPTION_1, false);
        LinkedHashMap<String, String> searchValues = new LinkedHashMap<String, String>();
        searchValues.put(COST_ELEMENT_ID, costElementCode1);
        String documentNumber = this.helper.copyMaintenanceDocument(DOCUMENT_TITLE, CostElement.class.getName(), searchValues, MAINTENANCE_DOCUMENT_TITLE);
        String costElementCode2 = this.getNewCostElementCode();
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put(COST_ELEMENT_ID, costElementCode2);
        fieldValues.put(DESCRIPTION_ID, COPY_DESCRIPTION_2);
        fieldValues.put(ON_OFF_CAMPUS_FLAG_ID, String.valueOf(true));
        this.helper.populateMaintenanceDocument(COPY_DOCUMENT_DESCRIPTION, fieldValues);
        this.helper.routeDocument();
        this.helper.assertRoute();
        this.verifyExistingMaintenanceDocument(documentNumber, costElementCode2, COPY_DESCRIPTION_2, true);
    }

    private String createNewMaintenanceDocument(String documentDescription, String costElementCode, String description, boolean onOffCampusFlag) {
        String documentNumber = this.helper.createMaintenanceDocument(DOCUMENT_TITLE, CostElement.class.getName(), MAINTENANCE_DOCUMENT_TITLE);
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put(COST_ELEMENT_ID, costElementCode);
        fieldValues.put(BUDGET_CATEGORY_CODE_ID, DEFAULT_BUDGET_CATEGORY_CODE);
        fieldValues.put(DESCRIPTION_ID, description);
        fieldValues.put(ON_OFF_CAMPUS_FLAG_ID, String.valueOf(onOffCampusFlag));
        fieldValues.put(ACTIVE_ID, String.valueOf(true));
        this.helper.populateMaintenanceDocument(documentDescription, fieldValues);
        this.helper.routeDocument();
        this.helper.assertRoute();
        return documentNumber;
    }

    private void verifyExistingMaintenanceDocument(String documentNumber, String costElementCode, String description, boolean onOffCampusFlag) throws Exception {
        MaintenanceDocumentBase document = (MaintenanceDocumentBase)this.getDocumentService().getByDocumentHeaderId(documentNumber);
        CostElementMaintenanceDocumentSeleniumTest.assertNotNull((Object)document.getDocumentNumber());
        CostElementMaintenanceDocumentSeleniumTest.assertNotNull((Object)document.getDocumentHeader());
        CostElementMaintenanceDocumentSeleniumTest.assertEquals((Object)documentNumber, (Object)document.getDocumentHeader().getDocumentNumber());
        CostElement costElement = (CostElement)document.getNewMaintainableObject().getDataObject();
        CostElementMaintenanceDocumentSeleniumTest.assertEquals((Object)costElementCode, (Object)costElement.getCostElement());
        CostElementMaintenanceDocumentSeleniumTest.assertEquals((Object)DEFAULT_BUDGET_CATEGORY_CODE, (Object)costElement.getBudgetCategoryCode());
        CostElementMaintenanceDocumentSeleniumTest.assertEquals((Object)description, (Object)costElement.getDescription());
        CostElementMaintenanceDocumentSeleniumTest.assertEquals((Object)onOffCampusFlag, (Object)costElement.getOnOffCampusFlag());
        CostElementMaintenanceDocumentSeleniumTest.assertEquals((Object)true, (Object)costElement.isActive());
    }

    private String getNewCostElementCode() {
        int maxCostElementCode = 1;
        Collection costElements = this.getBusinessObjectService().findAll(CostElement.class);
        for (CostElement costElement : costElements) {
            int costElementCode = NumberUtils.toInt((String)costElement.getCostElement(), (int)1);
            if (costElementCode <= maxCostElementCode) continue;
            maxCostElementCode = costElementCode;
        }
        return String.valueOf(maxCostElementCode + 1);
    }
}

