/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.web;

import java.util.Collection;
import java.util.LinkedHashMap;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.web.MaintenanceDocumentSeleniumHelper;
import org.kuali.kra.budget.calculator.ValidCalcType;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;
import org.kuali.rice.kns.document.MaintenanceDocumentBase;

public class ValidCalcTypeMaintenanceDocumentSeleniumTest
extends KcSeleniumTestBase {
    private static final String DOCUMENT_TITLE = "Valid Calculation Type";
    private static final String MAINTENANCE_DOCUMENT_TITLE = "Kuali :: Valid Calc Types Maintenance Document";
    private static final String CALC_TYPE_ID_ID = "calcTypeId";
    private static final String DEPENDENT_SEQ_NUMBER_ID = "dependentSeqNumber";
    private static final String RATE_CLASS_TYPE_ID = "rateClassType";
    private static final String DEPENDENT_RATE_CLASS_TYPE_ID = "dependentRateClassType";
    private static final String RATE_CLASS_CODE_ID = "rateClassCode";
    private static final String RATE_TYPE_CODE_ID = "rateTypeCode";
    private static final String CREATE_DOCUMENT_DESCRIPTION = "Valid Calculation Type - Test Create";
    private static final String CREATE_DEPENDENT_RATE_CLASS_TYPE = "X";
    private static final String CREATE_RATE_CLASS_CODE = "12";
    private static final String CREATE_RATE_TYPE_CODE = "1";
    private static final String EDIT_DOCUMENT_DESCRIPTION = "Valid Calculation Type - Test Edit";
    private static final String EDIT_DEPENDENT_RATE_CLASS_TYPE_1 = "X";
    private static final String EDIT_DEPENDENT_RATE_CLASS_TYPE_2 = "Y";
    private static final String EDIT_RATE_CLASS_CODE_1 = "12";
    private static final String EDIT_RATE_CLASS_CODE_2 = "5";
    private static final String EDIT_RATE_TYPE_CODE_1 = "1";
    private static final String EDIT_RATE_TYPE_CODE_2 = "3";
    private static final String COPY_DOCUMENT_DESCRIPTION = "Valid Calculation Type - Test Copy";
    private static final String COPY_DEPENDENT_RATE_CLASS_TYPE_1 = "X";
    private static final String COPY_DEPENDENT_RATE_CLASS_TYPE_2 = "Y";
    private static final String COPY_RATE_CLASS_CODE_1 = "12";
    private static final String COPY_RATE_CLASS_CODE_2 = "5";
    private static final String COPY_RATE_TYPE_CODE_1 = "1";
    private static final String COPY_RATE_TYPE_CODE_2 = "3";
    private static final int DEFAULT_DEPENDENT_SEQ_NUMBER = 1;
    private static final String DEFAULT_RATE_CLASS_TYPE = "E";
    private MaintenanceDocumentSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = MaintenanceDocumentSeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testCreateValidCalcType() throws Exception {
        String calcTypeId = this.getNewCalcTypeId();
        String documentNumber = this.createNewMaintenanceDocument(CREATE_DOCUMENT_DESCRIPTION, calcTypeId, "X", "12", "1");
        this.verifyExistingMaintenanceDocument(documentNumber, calcTypeId, "X", "12", "1");
    }

    @Test
    public void testEditValidCalcType() throws Exception {
        String calcTypeId = this.getNewCalcTypeId();
        this.createNewMaintenanceDocument(EDIT_DOCUMENT_DESCRIPTION, calcTypeId, "X", "12", "1");
        LinkedHashMap<String, String> searchValues = new LinkedHashMap<String, String>();
        searchValues.put(CALC_TYPE_ID_ID, calcTypeId);
        String documentNumber = this.helper.editMaintenanceDocument(DOCUMENT_TITLE, ValidCalcType.class.getName(), searchValues, MAINTENANCE_DOCUMENT_TITLE);
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put(DEPENDENT_RATE_CLASS_TYPE_ID, "Y");
        fieldValues.put(RATE_CLASS_CODE_ID, "5");
        fieldValues.put(RATE_TYPE_CODE_ID, "3");
        this.helper.populateMaintenanceDocument(EDIT_DOCUMENT_DESCRIPTION, fieldValues);
        this.helper.routeDocument();
        this.helper.assertRoute();
        this.verifyExistingMaintenanceDocument(documentNumber, calcTypeId, "Y", "5", "3");
    }

    @Test
    public void testCopyValidCalcType() throws Exception {
        String calcTypeId1 = this.getNewCalcTypeId();
        this.createNewMaintenanceDocument(COPY_DOCUMENT_DESCRIPTION, calcTypeId1, "X", "12", "1");
        LinkedHashMap<String, String> searchValues = new LinkedHashMap<String, String>();
        searchValues.put(CALC_TYPE_ID_ID, calcTypeId1);
        String documentNumber = this.helper.copyMaintenanceDocument(DOCUMENT_TITLE, ValidCalcType.class.getName(), searchValues, MAINTENANCE_DOCUMENT_TITLE);
        String calcTypeId2 = this.getNewCalcTypeId();
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put(CALC_TYPE_ID_ID, calcTypeId2);
        fieldValues.put(DEPENDENT_SEQ_NUMBER_ID, String.valueOf(1));
        fieldValues.put(RATE_CLASS_TYPE_ID, DEFAULT_RATE_CLASS_TYPE);
        fieldValues.put(DEPENDENT_RATE_CLASS_TYPE_ID, "Y");
        fieldValues.put(RATE_CLASS_CODE_ID, "5");
        fieldValues.put(RATE_TYPE_CODE_ID, "3");
        this.helper.populateMaintenanceDocument(COPY_DOCUMENT_DESCRIPTION, fieldValues);
        this.helper.routeDocument();
        this.helper.assertRoute();
        this.verifyExistingMaintenanceDocument(documentNumber, calcTypeId2, "Y", "5", "3");
    }

    private String createNewMaintenanceDocument(String documentDescription, String calcTypeId, String dependentRateClassType, String rateClassCode, String rateTypeCode) {
        String documentNumber = this.helper.createMaintenanceDocument(DOCUMENT_TITLE, ValidCalcType.class.getName(), MAINTENANCE_DOCUMENT_TITLE);
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put(CALC_TYPE_ID_ID, calcTypeId);
        fieldValues.put(DEPENDENT_SEQ_NUMBER_ID, String.valueOf(1));
        fieldValues.put(RATE_CLASS_TYPE_ID, DEFAULT_RATE_CLASS_TYPE);
        fieldValues.put(DEPENDENT_RATE_CLASS_TYPE_ID, dependentRateClassType);
        fieldValues.put(RATE_CLASS_CODE_ID, rateClassCode);
        fieldValues.put(RATE_TYPE_CODE_ID, rateTypeCode);
        this.helper.populateMaintenanceDocument(documentDescription, fieldValues);
        this.helper.routeDocument();
        this.helper.assertRoute();
        return documentNumber;
    }

    private void verifyExistingMaintenanceDocument(String documentNumber, String calcTypeId, String dependentRateClassType, String rateClassCode, String rateTypeCode) throws Exception {
        MaintenanceDocumentBase document = (MaintenanceDocumentBase)this.getDocumentService().getByDocumentHeaderId(documentNumber);
        ValidCalcTypeMaintenanceDocumentSeleniumTest.assertNotNull((Object)document.getDocumentNumber());
        ValidCalcTypeMaintenanceDocumentSeleniumTest.assertNotNull((Object)document.getDocumentHeader());
        ValidCalcTypeMaintenanceDocumentSeleniumTest.assertEquals((Object)documentNumber, (Object)document.getDocumentHeader().getDocumentNumber());
        ValidCalcType validCalcType = (ValidCalcType)document.getNewMaintainableObject().getDataObject();
        ValidCalcTypeMaintenanceDocumentSeleniumTest.assertEquals((Object)calcTypeId, (Object)validCalcType.getCalcTypeId());
        ValidCalcTypeMaintenanceDocumentSeleniumTest.assertEquals((Object)1, (Object)validCalcType.getDependentSeqNumber());
        ValidCalcTypeMaintenanceDocumentSeleniumTest.assertEquals((Object)DEFAULT_RATE_CLASS_TYPE, (Object)validCalcType.getRateClassType());
        ValidCalcTypeMaintenanceDocumentSeleniumTest.assertEquals((Object)dependentRateClassType, (Object)validCalcType.getDependentRateClassType());
        ValidCalcTypeMaintenanceDocumentSeleniumTest.assertEquals((Object)rateClassCode, (Object)validCalcType.getRateClassCode());
        ValidCalcTypeMaintenanceDocumentSeleniumTest.assertEquals((Object)rateTypeCode, (Object)validCalcType.getRateTypeCode());
    }

    private String getNewCalcTypeId() {
        int maxCalcTypeId = 1;
        Collection validCalcTypes = this.getBusinessObjectService().findAll(ValidCalcType.class);
        for (ValidCalcType validCalcType : validCalcTypes) {
            int activityTypeCode = Integer.valueOf(validCalcType.getCalcTypeId());
            if (activityTypeCode <= maxCalcTypeId) continue;
            maxCalcTypeId = activityTypeCode;
        }
        return String.valueOf(maxCalcTypeId + 1);
    }
}

