/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.kra.coi.CoiDiscDetail;
import org.kuali.kra.coi.CoiDisclProject;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.coi.CoiDisclosureDocument;
import org.kuali.kra.coi.CoiDisclosureHistory;
import org.kuali.kra.coi.actions.CoiDisclosureActionServiceImpl;
import org.kuali.kra.coi.personfinancialentity.PersonFinIntDisclosure;
import org.kuali.kra.service.impl.adapters.BusinessObjectServiceAdapter;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class CoiDisclosureActionServiceTest
extends KcUnitTestBase {
    private static final String PERSON_ID = "10000000001";
    private static final String ROLE_ID = "COIR";
    private static final String ENTITY_NUMBER = "1";
    private static final String ENTITY_NUMBER_2 = "2";
    private static final String ENTITY_NAME_1 = "Entity 1";
    private static final String ENTITY_NAME_2 = "Entity 2";
    Mockery context = new JUnit4Mockery();
    private CoiDisclosure coiDisclosure1;
    private CoiDisclosureHistory coiDisclosureHistory;

    @Test
    public void testApproveDisclosures() throws Exception {
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        CoiDisclosureActionServiceImpl coiDisclosureActionService = new CoiDisclosureActionServiceImpl();
        coiDisclosureActionService = new CoiDisclosureActionServiceImpl();
        PersonFinIntDisclosure personFinIntDisclosure = this.createPersonFinIntDisclosure(PERSON_ID, ENTITY_NUMBER, ENTITY_NAME_1);
        PersonFinIntDisclosure personFinIntDisclosure1 = this.createPersonFinIntDisclosure(PERSON_ID, ENTITY_NUMBER_2, ENTITY_NAME_2);
        this.coiDisclosure1 = this.getCoiDisclosure(1);
        this.coiDisclosure1.setCoiDisclosureId(Long.valueOf(1L));
        this.coiDisclosure1.setCurrentDisclosure(true);
        CoiDisclProject coiDisclProject1 = this.createNewCoiDisclProject(this.coiDisclosure1);
        coiDisclProject1.getCoiDiscDetails().add(this.createNewCoiDiscDetail("11", personFinIntDisclosure, ENTITY_NUMBER_2, 1));
        this.coiDisclosure1.getCoiDisclProjects().add(coiDisclProject1);
        CoiDisclosure coiDisclosure2 = this.getCoiDisclosure(2);
        coiDisclosure2.setCoiDisclosureId(Long.valueOf(2L));
        CoiDisclProject coiDisclProject2 = this.createNewCoiDisclProject(coiDisclosure2);
        coiDisclProject2.getCoiDiscDetails().add(this.createNewCoiDiscDetail("14", personFinIntDisclosure1, "12", 2));
        coiDisclosure2.getCoiDisclProjects().add(coiDisclProject2);
        ArrayList<CoiDisclosure> coiDisclosures = new ArrayList<CoiDisclosure>();
        ArrayList<Object> disclosures = new ArrayList<Object>();
        coiDisclosures.add(this.coiDisclosure1);
        disclosures.add(coiDisclosure2);
        disclosures.add(this.coiDisclosure1);
        disclosures.add(this.createDisclosureHistory(coiDisclosure2));
        coiDisclosureActionService.setBusinessObjectService((BusinessObjectService)new MockBusinessObjectService());
        coiDisclosureActionService.approveDisclosure(coiDisclosure2, "210");
        Assert.assertFalse((boolean)this.coiDisclosure1.isCurrentDisclosure());
        Assert.assertTrue((boolean)coiDisclosure2.isCurrentDisclosure());
        Assert.assertEquals((Object)coiDisclosure2.getDisclosureStatusCode(), (Object)"3");
        Assert.assertEquals((long)((CoiDisclProject)coiDisclosure2.getCoiDisclProjects().get(0)).getCoiDiscDetails().size(), (long)2L);
        Assert.assertEquals((Object)this.coiDisclosureHistory.getDisclosureStatus(), (Object)"3");
    }

    private CoiDisclosureHistory createDisclosureHistory(CoiDisclosure coiDisclosure) {
        CoiDisclosureHistory coiDisclosureHistory = new CoiDisclosureHistory();
        coiDisclosureHistory.setCoiDisclosureId(coiDisclosure.getCoiDisclosureId());
        coiDisclosureHistory.setCoiDisclosureNumber(coiDisclosure.getCoiDisclosureNumber());
        coiDisclosureHistory.setSequenceNumber(coiDisclosure.getSequenceNumber());
        coiDisclosureHistory.setDisclosureDispositionStatus(coiDisclosure.getDisclosureDispositionCode());
        coiDisclosureHistory.setDisclosureStatus("3");
        return coiDisclosureHistory;
    }

    private CoiDisclosure getCoiDisclosure(Integer sequenceNumber) {
        CoiDisclosureDocument coiDisclosureDocument = new CoiDisclosureDocument();
        CoiDisclosure coiDisclosure = new CoiDisclosure();
        coiDisclosure.setCoiDisclosureNumber(ENTITY_NUMBER);
        coiDisclosure.setSequenceNumber(sequenceNumber);
        coiDisclosure.setCoiDisclProjects(new ArrayList());
        coiDisclosure.setCoiDisclosureDocument(coiDisclosureDocument);
        coiDisclosure.setCoiDisclProjects(new ArrayList());
        coiDisclosureDocument.setCoiDisclosure(coiDisclosure);
        return coiDisclosure;
    }

    private CoiDiscDetail createNewCoiDiscDetail(String moduleCode, PersonFinIntDisclosure personFinIntDisclosure, String projectType, Integer sequenceNumber) {
        CoiDiscDetail disclosureDetail = new CoiDiscDetail(personFinIntDisclosure);
        disclosureDetail.setModuleItemKey(moduleCode + "-" + sequenceNumber);
        disclosureDetail.setProjectIdFk(moduleCode + "-" + sequenceNumber);
        disclosureDetail.setModuleCode(moduleCode);
        disclosureDetail.setCoiDisclosureNumber(ENTITY_NUMBER);
        disclosureDetail.setSequenceNumber(sequenceNumber);
        disclosureDetail.setProjectType(projectType);
        disclosureDetail.setDescription("Sample Description");
        return disclosureDetail;
    }

    private PersonFinIntDisclosure createPersonFinIntDisclosure(String personId, String entityNumber, String entityName) {
        PersonFinIntDisclosure personFinIntDisclosure = new PersonFinIntDisclosure();
        personFinIntDisclosure.setPersonId(personId);
        personFinIntDisclosure.setStatusCode(Integer.valueOf(1));
        personFinIntDisclosure.setCurrentFlag(true);
        personFinIntDisclosure.setEntityNumber(entityNumber);
        personFinIntDisclosure.setEntityName(entityName);
        return personFinIntDisclosure;
    }

    private CoiDisclProject createNewCoiDisclProject(CoiDisclosure coiDisclosure) {
        CoiDisclProject coiDisclProject = new CoiDisclProject();
        coiDisclProject.setCoiDisclosure(coiDisclosure);
        coiDisclProject.setCoiDisclosureId(coiDisclosure.getCoiDisclosureId());
        coiDisclProject.setCoiDisclosureNumber(coiDisclosure.getCoiDisclosureNumber());
        coiDisclProject.setCoiDiscDetails(new ArrayList());
        coiDisclProject.setDisclosureDispositionCode("100");
        coiDisclProject.setDisclosureStatusCode(ENTITY_NUMBER);
        return coiDisclProject;
    }

    public class MockBusinessObjectService
    extends BusinessObjectServiceAdapter {
        public Collection findMatching(Class clazz, Map fieldValues) {
            ArrayList<CoiDisclosure> coiDisclosures = new ArrayList<CoiDisclosure>();
            coiDisclosures.add(CoiDisclosureActionServiceTest.this.coiDisclosure1);
            return coiDisclosures;
        }

        @Override
        public List<? extends PersistableBusinessObject> save(List<? extends PersistableBusinessObject> businessObjects) {
            CoiDisclosureActionServiceTest.this.coiDisclosureHistory = (CoiDisclosureHistory)businessObjects.get(2);
            return businessObjects;
        }
    }
}

