/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.disclosure;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.kra.SequenceOwner;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.coi.CoiDiscDetail;
import org.kuali.kra.coi.CoiDisclProject;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.coi.CoiDisclosureHistory;
import org.kuali.kra.coi.DisclosureReporter;
import org.kuali.kra.coi.DisclosureReporterUnit;
import org.kuali.kra.coi.disclosure.CoiDisclosureServiceImpl;
import org.kuali.kra.coi.disclosure.DisclosurePerson;
import org.kuali.kra.coi.disclosure.DisclosurePersonUnit;
import org.kuali.kra.coi.disclosure.MasterDisclosureBean;
import org.kuali.kra.coi.personfinancialentity.FinancialEntityService;
import org.kuali.kra.coi.personfinancialentity.PersonFinIntDisclosure;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.personnel.ProtocolPerson;
import org.kuali.kra.irb.protocol.funding.ProtocolFundingSource;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.service.VersioningService;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class CoiDisclosureServiceTest
extends KcUnitTestBase {
    private static final String PERSON_ID = "10000000001";
    private static final String ROLE_ID = "COIR";
    private static final String UNIT_NUMBER = "000001";
    private static final String UNIT_NAME = "University";
    private static final String BL_UNIT_NUMBER = "BL-BL";
    private static final String BL_UNIT_NAME = "Bloomington";
    private static final String ENTITY_NUMBER = "1";
    private static final String ENTITY_NUMBER_2 = "2";
    private static final String ENTITY_NAME_1 = "Entity 1";
    private static final String ENTITY_NAME_2 = "Entity 2";
    private static final String PROJECT_ID = "100";
    Mockery context = new JUnit4Mockery();

    @Test
    public void testGetDisclosureReporter() throws Exception {
        CoiDisclosureServiceImpl coiDisclosureService = new CoiDisclosureServiceImpl();
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        DisclosurePerson reporter = new DisclosurePerson();
        reporter.setPersonId(PERSON_ID);
        reporter.setPersonRoleId(ROLE_ID);
        reporter.setCoiDisclosureId(Long.valueOf(1L));
        reporter.setDisclosurePersonUnits(new ArrayList());
        DisclosurePersonUnit disclosurePersonUnit = new DisclosurePersonUnit(){

            public String getUnitName() {
                return CoiDisclosureServiceTest.UNIT_NAME;
            }
        };
        disclosurePersonUnit.setUnitNumber(UNIT_NUMBER);
        disclosurePersonUnit.setUnitName(UNIT_NAME);
        disclosurePersonUnit.setLeadUnitFlag(true);
        reporter.getDisclosurePersonUnits().add(disclosurePersonUnit);
        final ArrayList<DisclosurePerson> reporters = new ArrayList<DisclosurePerson>();
        reporters.add(reporter);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, Object> fieldValues = new HashMap<String, Object>();
                fieldValues.put("personId", CoiDisclosureServiceTest.PERSON_ID);
                fieldValues.put("personRoleId", CoiDisclosureServiceTest.ROLE_ID);
                fieldValues.put("coiDisclosureId", 1L);
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(DisclosurePerson.class, fieldValues);
                this.will(2.returnValue((Object)reporters));
            }
        });
        coiDisclosureService.setBusinessObjectService(businessObjectService);
        DisclosurePerson disclosureReporter = coiDisclosureService.getDisclosureReporter(PERSON_ID, Long.valueOf(1L));
        Assert.assertEquals((Object)disclosureReporter.getPersonId(), (Object)PERSON_ID);
        Assert.assertEquals((Object)disclosureReporter.getPersonRoleId(), (Object)ROLE_ID);
        Assert.assertEquals((Object)disclosureReporter.getCoiDisclosureId().toString(), (Object)ENTITY_NUMBER);
    }

    @Test
    public void testAddDisclosureReporterUnit() throws Exception {
        CoiDisclosureServiceImpl coiDisclosureService = new CoiDisclosureServiceImpl();
        BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        DisclosurePerson reporter = new DisclosurePerson();
        reporter.setPersonId(PERSON_ID);
        reporter.setPersonRoleId(ROLE_ID);
        reporter.setCoiDisclosureId(Long.valueOf(1L));
        reporter.setDisclosurePersonUnits(new ArrayList());
        DisclosurePersonUnit disclosurePersonUnit = new DisclosurePersonUnit(){

            public String getUnitName() {
                return CoiDisclosureServiceTest.UNIT_NAME;
            }
        };
        disclosurePersonUnit.setUnitNumber(UNIT_NUMBER);
        disclosurePersonUnit.setUnitName(UNIT_NAME);
        disclosurePersonUnit.setLeadUnitFlag(true);
        reporter.getDisclosurePersonUnits().add(disclosurePersonUnit);
        ArrayList<DisclosurePerson> reporters = new ArrayList<DisclosurePerson>();
        reporters.add(reporter);
        DisclosurePersonUnit newUnit = new DisclosurePersonUnit(){

            public String getUnitName() {
                return CoiDisclosureServiceTest.BL_UNIT_NAME;
            }
        };
        newUnit.setUnitNumber(BL_UNIT_NUMBER);
        newUnit.setUnitName(BL_UNIT_NAME);
        newUnit.setLeadUnitFlag(true);
        coiDisclosureService.setBusinessObjectService(businessObjectService);
        coiDisclosureService.addDisclosureReporterUnit((DisclosureReporter)reporter, (DisclosureReporterUnit)newUnit);
        Assert.assertEquals((long)reporter.getDisclosurePersonUnits().size(), (long)2L);
        Assert.assertEquals((Object)((DisclosurePersonUnit)reporter.getDisclosurePersonUnits().get(0)).getUnitName(), (Object)UNIT_NAME);
        Assert.assertEquals((Object)((DisclosurePersonUnit)reporter.getDisclosurePersonUnits().get(0)).getUnitNumber(), (Object)UNIT_NUMBER);
        Assert.assertFalse((boolean)((DisclosurePersonUnit)reporter.getDisclosurePersonUnits().get(0)).isLeadUnitFlag());
        Assert.assertEquals((Object)((DisclosurePersonUnit)reporter.getDisclosurePersonUnits().get(1)).getUnitName(), (Object)BL_UNIT_NAME);
        Assert.assertEquals((Object)((DisclosurePersonUnit)reporter.getDisclosurePersonUnits().get(1)).getUnitNumber(), (Object)BL_UNIT_NUMBER);
        Assert.assertTrue((boolean)((DisclosurePersonUnit)reporter.getDisclosurePersonUnits().get(1)).isLeadUnitFlag());
    }

    @Test
    public void testDeleteDisclosureReporterUnit() throws Exception {
        CoiDisclosureServiceImpl coiDisclosureService = new CoiDisclosureServiceImpl();
        BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        DisclosurePerson reporter = new DisclosurePerson();
        reporter.setPersonId(PERSON_ID);
        reporter.setPersonRoleId(ROLE_ID);
        reporter.setCoiDisclosureId(Long.valueOf(1L));
        reporter.setDisclosurePersonUnits(new ArrayList());
        DisclosurePersonUnit disclosurePersonUnit = new DisclosurePersonUnit(){

            public String getUnitName() {
                return CoiDisclosureServiceTest.UNIT_NAME;
            }
        };
        disclosurePersonUnit.setUnitNumber(UNIT_NUMBER);
        disclosurePersonUnit.setUnitName(UNIT_NAME);
        disclosurePersonUnit.setLeadUnitFlag(false);
        reporter.getDisclosurePersonUnits().add(disclosurePersonUnit);
        ArrayList<DisclosurePerson> reporters = new ArrayList<DisclosurePerson>();
        reporters.add(reporter);
        DisclosurePersonUnit unit1 = new DisclosurePersonUnit(){

            public String getUnitName() {
                return CoiDisclosureServiceTest.BL_UNIT_NAME;
            }
        };
        unit1.setUnitNumber(BL_UNIT_NUMBER);
        unit1.setUnitName(BL_UNIT_NAME);
        unit1.setLeadUnitFlag(true);
        reporter.getDisclosurePersonUnits().add(unit1);
        coiDisclosureService.setBusinessObjectService(businessObjectService);
        coiDisclosureService.deleteDisclosureReporterUnit((DisclosureReporter)reporter, reporter.getDisclosurePersonUnits(), 1);
        Assert.assertEquals((long)reporter.getDisclosurePersonUnits().size(), (long)1L);
        Assert.assertEquals((Object)((DisclosurePersonUnit)reporter.getDisclosurePersonUnits().get(0)).getUnitName(), (Object)UNIT_NAME);
        Assert.assertEquals((Object)((DisclosurePersonUnit)reporter.getDisclosurePersonUnits().get(0)).getUnitNumber(), (Object)UNIT_NUMBER);
        Assert.assertTrue((boolean)((DisclosurePersonUnit)reporter.getDisclosurePersonUnits().get(0)).isLeadUnitFlag());
    }

    @Test
    public void testResetLeadUnit() throws Exception {
        CoiDisclosureServiceImpl coiDisclosureService = new CoiDisclosureServiceImpl();
        BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        DisclosurePerson reporter = new DisclosurePerson();
        reporter.setPersonId(PERSON_ID);
        reporter.setPersonRoleId(ROLE_ID);
        reporter.setCoiDisclosureId(Long.valueOf(1L));
        reporter.setDisclosurePersonUnits(new ArrayList());
        DisclosurePersonUnit disclosurePersonUnit = new DisclosurePersonUnit(){

            public String getUnitName() {
                return CoiDisclosureServiceTest.UNIT_NAME;
            }
        };
        disclosurePersonUnit.setUnitNumber(UNIT_NUMBER);
        disclosurePersonUnit.setUnitName(UNIT_NAME);
        disclosurePersonUnit.setLeadUnitFlag(false);
        reporter.getDisclosurePersonUnits().add(disclosurePersonUnit);
        ArrayList<DisclosurePerson> reporters = new ArrayList<DisclosurePerson>();
        reporters.add(reporter);
        DisclosurePersonUnit unit1 = new DisclosurePersonUnit(){

            public String getUnitName() {
                return CoiDisclosureServiceTest.BL_UNIT_NAME;
            }
        };
        unit1.setUnitNumber(BL_UNIT_NUMBER);
        unit1.setUnitName(BL_UNIT_NAME);
        unit1.setLeadUnitFlag(true);
        reporter.getDisclosurePersonUnits().add(unit1);
        reporter.setSelectedUnit(0);
        coiDisclosureService.setBusinessObjectService(businessObjectService);
        coiDisclosureService.resetLeadUnit((DisclosureReporter)reporter);
        Assert.assertEquals((long)reporter.getDisclosurePersonUnits().size(), (long)2L);
        Assert.assertEquals((Object)((DisclosurePersonUnit)reporter.getDisclosurePersonUnits().get(0)).getUnitName(), (Object)UNIT_NAME);
        Assert.assertEquals((Object)((DisclosurePersonUnit)reporter.getDisclosurePersonUnits().get(0)).getUnitNumber(), (Object)UNIT_NUMBER);
        Assert.assertTrue((boolean)((DisclosurePersonUnit)reporter.getDisclosurePersonUnits().get(0)).isLeadUnitFlag());
        Assert.assertEquals((Object)((DisclosurePersonUnit)reporter.getDisclosurePersonUnits().get(1)).getUnitName(), (Object)BL_UNIT_NAME);
        Assert.assertEquals((Object)((DisclosurePersonUnit)reporter.getDisclosurePersonUnits().get(1)).getUnitNumber(), (Object)BL_UNIT_NUMBER);
        Assert.assertFalse((boolean)((DisclosurePersonUnit)reporter.getDisclosurePersonUnits().get(1)).isLeadUnitFlag());
    }

    @Test
    public void testinitializeAnnualDisclosureDetails() throws Exception {
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        CoiDisclosureServiceImpl coiDisclosureService = new CoiDisclosureServiceImpl();
        BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        final FinancialEntityService financialEntityService = (FinancialEntityService)this.context.mock(FinancialEntityService.class);
        PersonFinIntDisclosure personFinIntDisclosure = this.createPersonFinIntDisclosure(PERSON_ID, ENTITY_NUMBER, ENTITY_NAME_1);
        final ArrayList<PersonFinIntDisclosure> activeEntities = new ArrayList<PersonFinIntDisclosure>();
        activeEntities.add(personFinIntDisclosure);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((FinancialEntityService)this.one(financialEntityService)).getFinancialEntities(CoiDisclosureServiceTest.PERSON_ID, true);
                this.will(9.returnValue((Object)activeEntities));
            }
        });
        this.getEmptyAwardPersons(businessObjectService);
        this.getEmptyIPPersons(businessObjectService);
        this.getEmptyProtocolPersons(businessObjectService);
        this.getProposalPersons(businessObjectService);
        coiDisclosureService.setBusinessObjectService(businessObjectService);
        CoiDisclosure coiDisclosure = new CoiDisclosure(){

            public void initCoiDisclosureNumber() {
                this.setCoiDisclosureNumber(CoiDisclosureServiceTest.ENTITY_NUMBER);
            }

            public DisclosurePerson getDisclosureReporter() {
                DisclosurePerson reporter = new DisclosurePerson();
                reporter.setPersonId(CoiDisclosureServiceTest.PERSON_ID);
                reporter.setPersonRoleId(CoiDisclosureServiceTest.ROLE_ID);
                reporter.setCoiDisclosureId(Long.valueOf(1L));
                return reporter;
            }
        };
        coiDisclosure.setEventTypeCode("14");
        coiDisclosureService.setBusinessObjectService(businessObjectService);
        coiDisclosureService.setFinancialEntityService(financialEntityService);
        coiDisclosureService.initializeDisclosureDetails(coiDisclosure);
        Assert.assertEquals((long)((CoiDisclProject)coiDisclosure.getCoiDisclProjects().get(0)).getCoiDiscDetails().size(), (long)1L);
        Assert.assertEquals((Object)((CoiDiscDetail)((CoiDisclProject)coiDisclosure.getCoiDisclProjects().get(0)).getCoiDiscDetails().get(0)).getEntityNumber(), (Object)ENTITY_NUMBER);
    }

    private void getProposalPersons(final BusinessObjectService businessObjectService) {
        final ArrayList<ProposalPerson> proposalPersons = new ArrayList<ProposalPerson>();
        ProposalPerson proposalPerson = new ProposalPerson();
        proposalPerson.setPersonId(PERSON_ID);
        DevelopmentProposal proposal = new DevelopmentProposal();
        proposal.setProposalNumber(ENTITY_NUMBER);
        proposal.setSponsorCode("000340");
        proposal.setProposalTypeCode(ENTITY_NUMBER);
        proposalPerson.setDevelopmentProposal(proposal);
        proposalPersons.add(proposalPerson);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("personId", CoiDisclosureServiceTest.PERSON_ID);
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(ProposalPerson.class, fieldValues);
                this.will(11.returnValue((Object)proposalPersons));
            }
        });
    }

    private void getEmptyProtocolPersons(final BusinessObjectService businessObjectService) {
        final ArrayList protocolPersons = new ArrayList();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("personId", CoiDisclosureServiceTest.PERSON_ID);
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(ProtocolPerson.class, fieldValues);
                this.will(12.returnValue((Object)protocolPersons));
            }
        });
    }

    private void getEmptyAwardPersons(final BusinessObjectService businessObjectService) {
        final ArrayList awardPersons = new ArrayList();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("personId", CoiDisclosureServiceTest.PERSON_ID);
                ((BusinessObjectService)this.one(businessObjectService)).findMatchingOrderBy(AwardPerson.class, fieldValues, "awardNumber", true);
                this.will(13.returnValue((Object)awardPersons));
            }
        });
    }

    private void getEmptyIPPersons(final BusinessObjectService businessObjectService) {
        final ArrayList proposalPersons = new ArrayList();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("personId", CoiDisclosureServiceTest.PERSON_ID);
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(InstitutionalProposalPerson.class, fieldValues);
                this.will(14.returnValue((Object)proposalPersons));
            }
        });
    }

    @Test
    public void testUpdateDisclosureDetails() throws Exception {
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        CoiDisclosureServiceImpl coiDisclosureService = new CoiDisclosureServiceImpl();
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        final FinancialEntityService financialEntityService = (FinancialEntityService)this.context.mock(FinancialEntityService.class);
        PersonFinIntDisclosure personFinIntDisclosure = this.createPersonFinIntDisclosure(PERSON_ID, ENTITY_NUMBER, ENTITY_NAME_1);
        PersonFinIntDisclosure personFinIntDisclosure1 = this.createPersonFinIntDisclosure(PERSON_ID, ENTITY_NUMBER_2, ENTITY_NAME_2);
        final ArrayList<PersonFinIntDisclosure> activeEntities = new ArrayList<PersonFinIntDisclosure>();
        activeEntities.add(personFinIntDisclosure);
        activeEntities.add(personFinIntDisclosure1);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((FinancialEntityService)this.one(financialEntityService)).getFinancialEntities(CoiDisclosureServiceTest.PERSON_ID, true);
                this.will(15.returnValue((Object)activeEntities));
            }
        });
        final DevelopmentProposal proposal = new DevelopmentProposal();
        proposal.setProposalNumber(PROJECT_ID);
        proposal.setSponsorCode("000340");
        proposal.setProposalTypeCode(ENTITY_NUMBER);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> primaryKeys = new HashMap<String, String>();
                primaryKeys.put("proposalNumber", CoiDisclosureServiceTest.PROJECT_ID);
                ((BusinessObjectService)this.one(businessObjectService)).findByPrimaryKey(DevelopmentProposal.class, primaryKeys);
                this.will(16.returnValue((Object)proposal));
            }
        });
        coiDisclosureService.setBusinessObjectService(businessObjectService);
        coiDisclosureService.setFinancialEntityService(financialEntityService);
        CoiDisclosure coiDisclosure = new CoiDisclosure(){

            public void initCoiDisclosureNumber() {
                this.setCoiDisclosureNumber(CoiDisclosureServiceTest.ENTITY_NUMBER);
            }

            public DisclosurePerson getDisclosureReporter() {
                DisclosurePerson reporter = new DisclosurePerson();
                reporter.setPersonId(CoiDisclosureServiceTest.PERSON_ID);
                reporter.setPersonRoleId(CoiDisclosureServiceTest.ROLE_ID);
                reporter.setCoiDisclosureId(Long.valueOf(1L));
                return reporter;
            }
        };
        coiDisclosure.setEventTypeCode(ENTITY_NUMBER_2);
        coiDisclosure.setCoiDisclProjects(new ArrayList());
        CoiDisclProject coiDisclProject = this.createCoiDIsclProject(coiDisclosure.getCoiDisclosureId());
        coiDisclProject.setDisclosureEventType(ENTITY_NUMBER_2);
        coiDisclosure.getCoiDisclProjects().add(coiDisclProject);
        coiDisclProject.setCoiDiscDetails(new ArrayList());
        coiDisclosure.setPersonId(PERSON_ID);
        coiDisclProject.getCoiDiscDetails().add(this.createNewCoiDiscDetail("11", personFinIntDisclosure, ENTITY_NUMBER_2));
        coiDisclosureService.setBusinessObjectService(businessObjectService);
        coiDisclosureService.setFinancialEntityService(financialEntityService);
        Assert.assertEquals((long)((CoiDisclProject)coiDisclosure.getCoiDisclProjects().get(0)).getCoiDiscDetails().size(), (long)2L);
        Assert.assertEquals((Object)((CoiDiscDetail)((CoiDisclProject)coiDisclosure.getCoiDisclProjects().get(0)).getCoiDiscDetails().get(0)).getEntityNumber(), (Object)ENTITY_NUMBER);
        Assert.assertEquals((Object)((CoiDiscDetail)((CoiDisclProject)coiDisclosure.getCoiDisclProjects().get(0)).getCoiDiscDetails().get(1)).getEntityNumber(), (Object)ENTITY_NUMBER_2);
    }

    private CoiDiscDetail createNewCoiDiscDetail(String moduleCode, PersonFinIntDisclosure personFinIntDisclosure, String projectType) {
        CoiDiscDetail disclosureDetail = new CoiDiscDetail(personFinIntDisclosure);
        disclosureDetail.setModuleItemKey(PROJECT_ID);
        disclosureDetail.setModuleCode(moduleCode);
        disclosureDetail.setCoiDisclosureNumber(ENTITY_NUMBER);
        disclosureDetail.setSequenceNumber(Integer.valueOf(1));
        disclosureDetail.setProjectType(projectType);
        disclosureDetail.setDescription("Sample Description");
        return disclosureDetail;
    }

    @Test
    public void testinitializeDisclosureDetails() throws Exception {
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        CoiDisclosureServiceImpl coiDisclosureService = new CoiDisclosureServiceImpl();
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        final FinancialEntityService financialEntityService = (FinancialEntityService)this.context.mock(FinancialEntityService.class);
        PersonFinIntDisclosure personFinIntDisclosure = this.createPersonFinIntDisclosure(PERSON_ID, ENTITY_NUMBER, ENTITY_NAME_1);
        final ArrayList<PersonFinIntDisclosure> activeEntities = new ArrayList<PersonFinIntDisclosure>();
        activeEntities.add(personFinIntDisclosure);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((FinancialEntityService)this.one(financialEntityService)).getFinancialEntities(CoiDisclosureServiceTest.PERSON_ID, true);
                this.will(18.returnValue((Object)activeEntities));
            }
        });
        final DevelopmentProposal proposal = new DevelopmentProposal();
        proposal.setProposalNumber(PROJECT_ID);
        proposal.setSponsorCode("000340");
        proposal.setProposalTypeCode(ENTITY_NUMBER);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> primaryKeys = new HashMap<String, String>();
                primaryKeys.put("proposalNumber", CoiDisclosureServiceTest.PROJECT_ID);
                ((BusinessObjectService)this.one(businessObjectService)).findByPrimaryKey(DevelopmentProposal.class, primaryKeys);
                this.will(19.returnValue((Object)proposal));
            }
        });
        coiDisclosureService.setBusinessObjectService(businessObjectService);
        coiDisclosureService.setFinancialEntityService(financialEntityService);
        CoiDisclosure coiDisclosure = new CoiDisclosure(){

            public void initCoiDisclosureNumber() {
                this.setCoiDisclosureNumber(CoiDisclosureServiceTest.ENTITY_NUMBER);
            }

            public DisclosurePerson getDisclosureReporter() {
                DisclosurePerson reporter = new DisclosurePerson();
                reporter.setPersonId(CoiDisclosureServiceTest.PERSON_ID);
                reporter.setPersonRoleId(CoiDisclosureServiceTest.ROLE_ID);
                reporter.setCoiDisclosureId(Long.valueOf(1L));
                return reporter;
            }
        };
        coiDisclosure.setEventTypeCode(ENTITY_NUMBER_2);
        coiDisclosureService.setBusinessObjectService(businessObjectService);
        coiDisclosureService.setFinancialEntityService(financialEntityService);
        coiDisclosureService.initializeDisclosureProject(coiDisclosure, PROJECT_ID);
        Assert.assertEquals((long)((CoiDisclProject)coiDisclosure.getCoiDisclProjects().get(0)).getCoiDiscDetails().size(), (long)1L);
        Assert.assertEquals((Object)((CoiDiscDetail)((CoiDisclProject)coiDisclosure.getCoiDisclProjects().get(0)).getCoiDiscDetails().get(0)).getEntityNumber(), (Object)ENTITY_NUMBER);
        Assert.assertEquals((Object)((CoiDiscDetail)((CoiDisclProject)coiDisclosure.getCoiDisclProjects().get(0)).getCoiDiscDetails().get(0)).getProjectType(), (Object)ENTITY_NUMBER_2);
    }

    @Test
    public void testUpdateManualDisclosureDetails() throws Exception {
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        CoiDisclosureServiceImpl coiDisclosureService = new CoiDisclosureServiceImpl();
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        final FinancialEntityService financialEntityService = (FinancialEntityService)this.context.mock(FinancialEntityService.class);
        PersonFinIntDisclosure personFinIntDisclosure = this.createPersonFinIntDisclosure(PERSON_ID, ENTITY_NUMBER, ENTITY_NAME_1);
        PersonFinIntDisclosure personFinIntDisclosure1 = this.createPersonFinIntDisclosure(PERSON_ID, ENTITY_NUMBER_2, ENTITY_NAME_2);
        final ArrayList<PersonFinIntDisclosure> activeEntities = new ArrayList<PersonFinIntDisclosure>();
        activeEntities.add(personFinIntDisclosure);
        activeEntities.add(personFinIntDisclosure1);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((FinancialEntityService)this.one(financialEntityService)).getFinancialEntities(CoiDisclosureServiceTest.PERSON_ID, true);
                this.will(21.returnValue((Object)activeEntities));
            }
        });
        final CoiDisclProject coiDisclProject = new CoiDisclProject();
        coiDisclProject.setCoiDisclosureId(Long.valueOf(1L));
        coiDisclProject.setCoiProjectId(PROJECT_ID);
        CoiDiscDetail coiDisDetail = this.createNewCoiDiscDetail("14", personFinIntDisclosure, "12");
        CoiDisclosure coiDisclosure = new CoiDisclosure(){

            public void initCoiDisclosureNumber() {
                this.setCoiDisclosureNumber(CoiDisclosureServiceTest.ENTITY_NUMBER);
            }

            public DisclosurePerson getDisclosureReporter() {
                DisclosurePerson reporter = new DisclosurePerson();
                reporter.setPersonId(CoiDisclosureServiceTest.PERSON_ID);
                reporter.setPersonRoleId(CoiDisclosureServiceTest.ROLE_ID);
                reporter.setCoiDisclosureId(Long.valueOf(1L));
                return reporter;
            }
        };
        coiDisclosure.setEventTypeCode("12");
        coiDisclosure.setCoiDisclProjects(new ArrayList());
        coiDisclosure.getCoiDisclProjects().add(coiDisclProject);
        ((CoiDisclProject)coiDisclosure.getCoiDisclProjects().get(0)).setCoiDiscDetails(new ArrayList());
        ((CoiDisclProject)coiDisclosure.getCoiDisclProjects().get(0)).getCoiDiscDetails().add(coiDisDetail);
        coiDisclProject.setCoiDisclosure(coiDisclosure);
        coiDisclosure.setPersonId(PERSON_ID);
        coiDisDetail.setPersonFinIntDisclosure(personFinIntDisclosure);
        final ArrayList<CoiDiscDetail> coiDisDetails = new ArrayList<CoiDiscDetail>();
        coiDisDetails.add(coiDisDetail);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, Object> fieldValues = new HashMap<String, Object>();
                fieldValues.put("coiDisclosureId", coiDisclProject.getCoiDisclosureId());
                fieldValues.put("moduleCode", "14");
                fieldValues.put("moduleItemKey", coiDisclProject.getShortTextField1());
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(CoiDiscDetail.class, fieldValues);
                this.will(23.returnValue((Object)coiDisDetails));
            }
        });
        coiDisclosureService.setBusinessObjectService(businessObjectService);
        coiDisclosureService.setFinancialEntityService(financialEntityService);
        coiDisclosureService.updateDisclosureDetails(coiDisclProject);
        Assert.assertEquals((long)coiDisclProject.getCoiDiscDetails().size(), (long)2L);
        Assert.assertEquals((Object)((CoiDiscDetail)coiDisclProject.getCoiDiscDetails().get(0)).getEntityNumber(), (Object)ENTITY_NUMBER);
        Assert.assertEquals((Object)((CoiDiscDetail)coiDisclProject.getCoiDiscDetails().get(1)).getEntityNumber(), (Object)ENTITY_NUMBER_2);
    }

    @Test
    public void testSetManualDisclDetailsForSave() throws Exception {
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        CoiDisclosureServiceImpl coiDisclosureService = new CoiDisclosureServiceImpl();
        PersonFinIntDisclosure personFinIntDisclosure = this.createPersonFinIntDisclosure(PERSON_ID, ENTITY_NUMBER, ENTITY_NAME_1);
        PersonFinIntDisclosure personFinIntDisclosure1 = this.createPersonFinIntDisclosure(PERSON_ID, ENTITY_NUMBER_2, ENTITY_NAME_2);
        CoiDisclProject coiDisclProject = new CoiDisclProject();
        coiDisclProject.setCoiDisclosureId(Long.valueOf(1L));
        coiDisclProject.setCoiProjectId(PROJECT_ID);
        CoiDiscDetail coiDisDetail = this.createNewCoiDiscDetail("14", personFinIntDisclosure, "12");
        CoiDiscDetail coiDisDetail1 = this.createNewCoiDiscDetail("14", personFinIntDisclosure1, "12");
        CoiDisclosure coiDisclosure = new CoiDisclosure(){

            public void initCoiDisclosureNumber() {
                this.setCoiDisclosureNumber(CoiDisclosureServiceTest.ENTITY_NUMBER);
            }

            public DisclosurePerson getDisclosureReporter() {
                DisclosurePerson reporter = new DisclosurePerson();
                reporter.setPersonId(CoiDisclosureServiceTest.PERSON_ID);
                reporter.setPersonRoleId(CoiDisclosureServiceTest.ROLE_ID);
                reporter.setCoiDisclosureId(Long.valueOf(1L));
                return reporter;
            }
        };
        coiDisclosure.setEventTypeCode("12");
        coiDisclProject.setCoiDisclosure(coiDisclosure);
        ArrayList<CoiDiscDetail> coiDisDetails = new ArrayList<CoiDiscDetail>();
        coiDisDetails.add(coiDisDetail);
        coiDisDetails.add(coiDisDetail1);
        coiDisclProject.setCoiDiscDetails(coiDisDetails);
        coiDisclosure.setCoiDisclProjects(new ArrayList());
        coiDisclosure.getCoiDisclProjects().add(coiDisclProject);
        Assert.assertEquals((long)((CoiDisclProject)coiDisclosure.getCoiDisclProjects().get(0)).getCoiDiscDetails().size(), (long)2L);
        Assert.assertEquals((Object)((CoiDiscDetail)((CoiDisclProject)coiDisclosure.getCoiDisclProjects().get(0)).getCoiDiscDetails().get(0)).getEntityNumber(), (Object)ENTITY_NUMBER);
        Assert.assertEquals((Object)((CoiDiscDetail)((CoiDisclProject)coiDisclosure.getCoiDisclProjects().get(0)).getCoiDiscDetails().get(1)).getEntityNumber(), (Object)ENTITY_NUMBER_2);
    }

    private PersonFinIntDisclosure createPersonFinIntDisclosure(String personId, String entityNumber, String entityName) {
        PersonFinIntDisclosure personFinIntDisclosure = new PersonFinIntDisclosure();
        personFinIntDisclosure.setPersonId(personId);
        personFinIntDisclosure.setStatusCode(Integer.valueOf(1));
        personFinIntDisclosure.setCurrentFlag(true);
        personFinIntDisclosure.setEntityNumber(entityNumber);
        personFinIntDisclosure.setEntityName(entityName);
        return personFinIntDisclosure;
    }

    @Test
    public void testSetAnnualDisclDetailsForSave() throws Exception {
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        CoiDisclosureServiceImpl coiDisclosureService = new CoiDisclosureServiceImpl();
        PersonFinIntDisclosure personFinIntDisclosure = this.createPersonFinIntDisclosure(PERSON_ID, ENTITY_NUMBER, ENTITY_NAME_1);
        PersonFinIntDisclosure personFinIntDisclosure1 = this.createPersonFinIntDisclosure(PERSON_ID, ENTITY_NUMBER_2, ENTITY_NAME_2);
        CoiDisclProject coiDisclProject = new CoiDisclProject();
        coiDisclProject.setDisclosureEventType(ENTITY_NUMBER_2);
        CoiDiscDetail coiDisDetail = this.createNewCoiDiscDetail("13", personFinIntDisclosure, ENTITY_NUMBER_2);
        CoiDiscDetail coiDisDetail1 = this.createNewCoiDiscDetail("13", personFinIntDisclosure1, ENTITY_NUMBER_2);
        CoiDisclosure coiDisclosure = new CoiDisclosure(){

            public void initCoiDisclosureNumber() {
                this.setCoiDisclosureNumber(CoiDisclosureServiceTest.ENTITY_NUMBER);
            }

            public DisclosurePerson getDisclosureReporter() {
                DisclosurePerson reporter = new DisclosurePerson();
                reporter.setPersonId(CoiDisclosureServiceTest.PERSON_ID);
                reporter.setPersonRoleId(CoiDisclosureServiceTest.ROLE_ID);
                reporter.setCoiDisclosureId(Long.valueOf(1L));
                return reporter;
            }
        };
        coiDisclosure.setEventTypeCode("14");
        ArrayList<CoiDisclProject> coiDisclProjects = new ArrayList<CoiDisclProject>();
        ArrayList<CoiDiscDetail> coiDisDetails = new ArrayList<CoiDiscDetail>();
        coiDisDetails.add(coiDisDetail);
        coiDisDetails.add(coiDisDetail1);
        coiDisclProject.setCoiDiscDetails(coiDisDetails);
        coiDisclProjects.add(coiDisclProject);
        coiDisclosure.setCoiDisclProjects(coiDisclProjects);
        Assert.assertEquals((long)((CoiDisclProject)coiDisclosure.getCoiDisclProjects().get(0)).getCoiDiscDetails().size(), (long)2L);
        Assert.assertEquals((Object)((CoiDiscDetail)((CoiDisclProject)coiDisclosure.getCoiDisclProjects().get(0)).getCoiDiscDetails().get(0)).getEntityNumber(), (Object)ENTITY_NUMBER);
        Assert.assertEquals((Object)((CoiDiscDetail)((CoiDisclProject)coiDisclosure.getCoiDisclProjects().get(0)).getCoiDiscDetails().get(1)).getEntityNumber(), (Object)ENTITY_NUMBER_2);
    }

    @Test
    public void testVersionDisclosures() throws Exception {
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        CoiDisclosureServiceImpl coiDisclosureService = new CoiDisclosureServiceImpl();
        final VersioningService versioningService = (VersioningService)this.context.mock(VersioningService.class);
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        CoiDisclosure coiDisclosure1 = this.getCoiDisclosure(1);
        final CoiDisclosure coiDisclosure2 = this.getCoiDisclosure(2);
        final CoiDisclosure coiDisclosure3 = this.getCoiDisclosure(3);
        final ArrayList<CoiDisclosure> coiDisclosures = new ArrayList<CoiDisclosure>();
        coiDisclosures.add(coiDisclosure2);
        coiDisclosures.add(coiDisclosure1);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((VersioningService)this.one(versioningService)).createNewVersion((SequenceOwner)coiDisclosure2);
                this.will(26.returnValue((Object)coiDisclosure3));
            }
        });
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("personId", GlobalVariables.getUserSession().getPrincipalId());
                ((BusinessObjectService)this.one(businessObjectService)).findMatchingOrderBy(CoiDisclosure.class, fieldValues, "sequenceNumber", false);
                this.will(27.returnValue((Object)coiDisclosures));
            }
        });
        coiDisclosureService.setBusinessObjectService(businessObjectService);
        coiDisclosureService.setVersioningService(versioningService);
        CoiDisclosure newCoiDisclosure = coiDisclosureService.versionCoiDisclosure();
        Assert.assertEquals((Object)newCoiDisclosure.getSequenceNumber(), (Object)new Integer(3));
    }

    private CoiDisclosure getCoiDisclosure(Integer sequenceNumber) {
        CoiDisclosure coiDisclosure = new CoiDisclosure(){

            public void initCoiDisclosureNumber() {
                this.setCoiDisclosureNumber(CoiDisclosureServiceTest.ENTITY_NUMBER);
            }

            public DisclosurePerson getDisclosureReporter() {
                DisclosurePerson reporter = new DisclosurePerson();
                reporter.setPersonId(CoiDisclosureServiceTest.PERSON_ID);
                reporter.setPersonRoleId(CoiDisclosureServiceTest.ROLE_ID);
                reporter.setCoiDisclosureId(Long.valueOf(1L));
                return reporter;
            }
        };
        coiDisclosure.setCoiDisclosureNumber(ENTITY_NUMBER);
        coiDisclosure.setSequenceNumber(sequenceNumber);
        return coiDisclosure;
    }

    @Test
    public void testGetProposals() throws Exception {
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        CoiDisclosureServiceImpl coiDisclosureService = new CoiDisclosureServiceImpl();
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        final ArrayList<ProposalPerson> proposalPersons = new ArrayList<ProposalPerson>();
        ProposalPerson proposalPerson = new ProposalPerson();
        proposalPerson.setPersonId(PERSON_ID);
        DevelopmentProposal proposal = new DevelopmentProposal();
        proposal.setProposalNumber(ENTITY_NUMBER);
        proposal.setSponsorCode("000340");
        proposal.setProposalTypeCode(ENTITY_NUMBER);
        proposalPerson.setDevelopmentProposal(proposal);
        proposalPersons.add(proposalPerson);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("personId", CoiDisclosureServiceTest.PERSON_ID);
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(ProposalPerson.class, fieldValues);
                this.will(29.returnValue((Object)proposalPersons));
            }
        });
        ArrayList proposals = new ArrayList();
        coiDisclosureService.setBusinessObjectService(businessObjectService);
        List retValues = coiDisclosureService.getProposals(PERSON_ID);
        Assert.assertEquals((long)retValues.size(), (long)1L);
        Assert.assertEquals((Object)((DevelopmentProposal)retValues.get(0)).getProposalNumber(), (Object)ENTITY_NUMBER);
    }

    @Test
    public void testGetProtocols() throws Exception {
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        CoiDisclosureServiceImpl coiDisclosureService = new CoiDisclosureServiceImpl();
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        final ArrayList<ProtocolPerson> persons = new ArrayList<ProtocolPerson>();
        ProtocolPerson person = new ProtocolPerson();
        person.setPersonId(PERSON_ID);
        Protocol protocol = new Protocol();
        protocol.setProtocolNumber(ENTITY_NUMBER);
        protocol.setProtocolStatusCode(PROJECT_ID);
        protocol.setActive(true);
        ProtocolFundingSource fundingSource = new ProtocolFundingSource();
        fundingSource.setFundingSourceTypeCode(ENTITY_NUMBER);
        fundingSource.setFundingSourceNumber("000340");
        protocol.setProtocolFundingSources(new ArrayList());
        protocol.getProtocolFundingSources().add(fundingSource);
        person.setProtocol((ProtocolBase)protocol);
        persons.add(person);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("personId", CoiDisclosureServiceTest.PERSON_ID);
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(ProtocolPerson.class, fieldValues);
                this.will(30.returnValue((Object)persons));
            }
        });
        ArrayList protocols = new ArrayList();
        coiDisclosureService.setBusinessObjectService(businessObjectService);
        List retValues = coiDisclosureService.getProtocols(PERSON_ID);
        Assert.assertEquals((long)retValues.size(), (long)1L);
        Assert.assertEquals((Object)((Protocol)retValues.get(0)).getProtocolNumber(), (Object)ENTITY_NUMBER);
    }

    @Test
    public void testGetAwards() throws Exception {
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        CoiDisclosureServiceImpl coiDisclosureService = new CoiDisclosureServiceImpl();
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        final ArrayList<AwardPerson> awardPersons = new ArrayList<AwardPerson>();
        AwardPerson awardPerson = new AwardPerson();
        awardPerson.setPersonId(PERSON_ID);
        Award award = new Award();
        award.setAwardNumber(ENTITY_NUMBER);
        award.setAwardId(Long.valueOf(1L));
        award.setSponsorCode("000340");
        award.setStatusCode(Integer.valueOf(1));
        awardPerson.setAward(award);
        awardPersons.add(awardPerson);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("personId", CoiDisclosureServiceTest.PERSON_ID);
                ((BusinessObjectService)this.one(businessObjectService)).findMatchingOrderBy(AwardPerson.class, fieldValues, "awardNumber", true);
                this.will(31.returnValue((Object)awardPersons));
            }
        });
        final ArrayList<Award> awards = new ArrayList<Award>();
        awards.add(award);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> values = new HashMap<String, String>();
                values.put("awardNumber", CoiDisclosureServiceTest.ENTITY_NUMBER);
                ((BusinessObjectService)this.one(businessObjectService)).findMatchingOrderBy(Award.class, values, "sequenceNumber", false);
                this.will(32.returnValue((Object)awards));
            }
        });
        ArrayList proposals = new ArrayList();
        coiDisclosureService.setBusinessObjectService(businessObjectService);
        List retValues = coiDisclosureService.getAwards(PERSON_ID);
        Assert.assertEquals((long)retValues.size(), (long)1L);
        Assert.assertEquals((Object)((Award)retValues.get(0)).getAwardNumber(), (Object)ENTITY_NUMBER);
    }

    @Test
    public void testGetMasterDisclosureDetail() throws Exception {
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        CoiDisclosureServiceImpl coiDisclosureService = new CoiDisclosureServiceImpl();
        PersonFinIntDisclosure personFinIntDisclosure = this.createPersonFinIntDisclosure(PERSON_ID, ENTITY_NUMBER, ENTITY_NAME_1);
        PersonFinIntDisclosure personFinIntDisclosure1 = this.createPersonFinIntDisclosure(PERSON_ID, ENTITY_NUMBER_2, ENTITY_NAME_2);
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        CoiDisclosure coiDisclosure0 = this.createCoiDisclosure();
        CoiDiscDetail coiDisDetail0 = this.createNewCoiDiscDetail("14", personFinIntDisclosure, "12");
        coiDisDetail0.setModuleItemKey(ENTITY_NUMBER);
        coiDisDetail0.setCoiDiscDetailId(Long.valueOf(1L));
        ArrayList<CoiDiscDetail> coiDisDetails0 = new ArrayList<CoiDiscDetail>();
        coiDisDetails0.add(coiDisDetail0);
        ArrayList<CoiDisclProject> coiDisclProjects0 = new ArrayList<CoiDisclProject>();
        CoiDisclProject coiDisclProject0 = this.createCoiDIsclProject(3L);
        coiDisclProject0.setCoiDiscDetails(coiDisDetails0);
        coiDisclProjects0.add(coiDisclProject0);
        coiDisclosure0.setCoiDisclProjects(coiDisclProjects0);
        CoiDiscDetail coiDisDetail = this.createNewCoiDiscDetail("14", personFinIntDisclosure, "12");
        coiDisDetail.setModuleItemKey(ENTITY_NUMBER);
        coiDisDetail.setCoiDiscDetailId(Long.valueOf(1L));
        coiDisDetail.setCopiedCoiDiscDetailId(Long.valueOf(1L));
        coiDisDetail.setOriginalCoiDisclosureId(Long.valueOf(1L));
        CoiDiscDetail coiDisDetail1 = this.createNewCoiDiscDetail("14", personFinIntDisclosure1, "11");
        coiDisDetail1.setCoiDiscDetailId(Long.valueOf(2L));
        coiDisDetail1.setModuleItemKey(ENTITY_NUMBER_2);
        CoiDisclosure coiDisclosure = this.createCoiDisclosure();
        coiDisclosure.setCoiDisclosureId(Long.valueOf(2L));
        coiDisclosure.setEventTypeCode(ENTITY_NUMBER);
        ArrayList<CoiDiscDetail> coiDisDetails = new ArrayList<CoiDiscDetail>();
        coiDisDetails.add(coiDisDetail);
        coiDisDetails.add(coiDisDetail1);
        final ArrayList<CoiDisclProject> coiDisclProjects = new ArrayList<CoiDisclProject>();
        CoiDisclProject coiDisclProject = this.createCoiDIsclProject(1L);
        coiDisclProject.setCoiDiscDetails(coiDisDetails);
        coiDisclProjects.add(coiDisclProject);
        final ArrayList<CoiDisclProject> coiDisclProjects1 = new ArrayList<CoiDisclProject>();
        CoiDisclProject coiDisclProject1 = this.createCoiDIsclProject(2L);
        coiDisclProject1.setCoiDiscDetails(coiDisDetails);
        coiDisclProjects1.add(coiDisclProject1);
        final ArrayList<CoiDisclosureHistory> histories = new ArrayList<CoiDisclosureHistory>();
        CoiDisclosureHistory history1 = this.createCoidisclosureHistory(1L, 1);
        CoiDisclosureHistory history2 = this.createCoidisclosureHistory(2L, 2);
        history1.setCoiDisclosure(coiDisclosure0);
        history2.setCoiDisclosure(coiDisclosure);
        histories.add(history1);
        histories.add(history2);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("coiDisclosureNumber", CoiDisclosureServiceTest.ENTITY_NUMBER);
                fieldValues.put("coiProjectId", CoiDisclosureServiceTest.ENTITY_NUMBER);
                ((BusinessObjectService)this.atLeast(1).of((Object)businessObjectService)).findMatching(CoiDisclProject.class, fieldValues);
                this.will(33.returnValue((Object)coiDisclProjects));
                HashMap<String, String> fieldValues1 = new HashMap<String, String>();
                fieldValues1.put("coiDisclosureNumber", CoiDisclosureServiceTest.ENTITY_NUMBER);
                fieldValues1.put("coiProjectId", CoiDisclosureServiceTest.ENTITY_NUMBER_2);
                ((BusinessObjectService)this.atLeast(1).of((Object)businessObjectService)).findMatching(CoiDisclProject.class, fieldValues1);
                this.will(33.returnValue((Object)coiDisclProjects1));
                HashMap<String, String> fieldValues2 = new HashMap<String, String>();
                fieldValues2.put("coiDisclosureNumber", CoiDisclosureServiceTest.ENTITY_NUMBER);
                fieldValues2.put("disclosureStatus", "3");
                ((BusinessObjectService)this.one(businessObjectService)).findMatchingOrderBy(CoiDisclosureHistory.class, fieldValues2, "sequenceNumber", true);
                this.will(33.returnValue((Object)histories));
            }
        });
        coiDisclosureService.setBusinessObjectService(businessObjectService);
        MasterDisclosureBean masterDisclosureBean = coiDisclosureService.getMasterDisclosureDetail(coiDisclosure);
        Assert.assertEquals((long)((CoiDisclProject)coiDisclosure.getCoiDisclProjects().get(0)).getCoiDiscDetails().size(), (long)2L);
        Assert.assertEquals((long)masterDisclosureBean.getAllProjects().size(), (long)2L);
        Assert.assertEquals((long)masterDisclosureBean.getManualAwardProjects().size(), (long)1L);
        Assert.assertEquals((long)masterDisclosureBean.getManualProposalProjects().size(), (long)1L);
    }

    private CoiDisclProject createCoiDIsclProject(Long coiDisclosureId) {
        CoiDisclProject coiDisclProject = new CoiDisclProject();
        coiDisclProject.setCoiDisclosureId(coiDisclosureId);
        coiDisclProject.setCoiDisclosureNumber(ENTITY_NUMBER);
        coiDisclProject.setCoiProjectId(ENTITY_NUMBER);
        coiDisclProject.setCoiProjectTitle("Test Title");
        coiDisclProject.setModuleItemKey(ENTITY_NUMBER);
        coiDisclProject.setDisclosureDispositionCode(PROJECT_ID);
        coiDisclProject.setDisclosureStatusCode(ENTITY_NUMBER);
        return coiDisclProject;
    }

    private CoiDisclosure createCoiDisclosure() {
        CoiDisclosure coiDisclosure = new CoiDisclosure(){

            public void initCoiDisclosureNumber() {
                this.setCoiDisclosureNumber(CoiDisclosureServiceTest.ENTITY_NUMBER);
            }

            public DisclosurePerson getDisclosureReporter() {
                DisclosurePerson reporter = new DisclosurePerson();
                reporter.setPersonId(CoiDisclosureServiceTest.PERSON_ID);
                reporter.setPersonRoleId(CoiDisclosureServiceTest.ROLE_ID);
                reporter.setCoiDisclosureId(Long.valueOf(1L));
                return reporter;
            }
        };
        return coiDisclosure;
    }

    private CoiDisclosureHistory createCoidisclosureHistory(Long coiDisclosureId, Integer sequenceNumber) {
        CoiDisclosureHistory history = new CoiDisclosureHistory(){

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        history.setCoiDisclosureId(coiDisclosureId);
        history.setCoiDisclosureHistoryId(coiDisclosureId);
        history.setCoiDisclosureNumber(ENTITY_NUMBER);
        history.setSequenceNumber(sequenceNumber);
        history.setDisclosureStatus("3");
        history.setDisclosureDispositionStatus("240");
        history.setUpdateTimestamp(new Timestamp(new Date().getTime()));
        return history;
    }
}

