/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.personfinancialentity;

import java.util.Collections;
import java.util.HashMap;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.coi.personfinancialentity.FinEntitiesDataGroup;
import org.kuali.kra.coi.personfinancialentity.FinEntitiesDataGroupMaintenanceDocumentRule;
import org.kuali.kra.maintenance.MaintenanceRuleTestBase;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class FinEntitiesDataGroupMaintenanceDocumentRuleTest
extends MaintenanceRuleTestBase {
    private static final String GROUP_SORT_ID_FIELD_NAME = "dataGroupSortId";
    private static final String GROUP_NAME_FIELD_NAME = "dataGroupName";
    private static final Integer GROUP_ID_1 = 1;
    private static final Integer GROUP_ID_2 = 2;
    private static final Integer SORT_ID_1 = 1;
    private static final String GROUP_NAME = "Test";
    private FinEntitiesDataGroupMaintenanceDocumentRule rule;
    private Mockery context = new JUnit4Mockery();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rule = new FinEntitiesDataGroupMaintenanceDocumentRule();
        this.rule.setBusinessObjectService(this.getMockBusinessObjectService());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.rule = null;
        super.tearDown();
    }

    @Test
    public void testUniqueOK() throws Exception {
        MaintenanceDocument finEntitiesDataGroupMaintenanceDocument = this.getFinEntitiesDataGroupMaintenanceDocument(GROUP_ID_1, GROUP_NAME, SORT_ID_1);
        FinEntitiesDataGroupMaintenanceDocumentRuleTest.assertTrue((boolean)this.rule.processCustomRouteDocumentBusinessRules(finEntitiesDataGroupMaintenanceDocument));
        FinEntitiesDataGroupMaintenanceDocumentRuleTest.assertTrue((boolean)this.rule.processCustomApproveDocumentBusinessRules(finEntitiesDataGroupMaintenanceDocument));
    }

    @Test
    public void testUniqueNotOK() throws Exception {
        MaintenanceDocument finEntitiesDataGroupMaintenanceDocument = this.getFinEntitiesDataGroupMaintenanceDocument(GROUP_ID_2, GROUP_NAME, SORT_ID_1);
        FinEntitiesDataGroupMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomRouteDocumentBusinessRules(finEntitiesDataGroupMaintenanceDocument));
        FinEntitiesDataGroupMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomApproveDocumentBusinessRules(finEntitiesDataGroupMaintenanceDocument));
    }

    private MaintenanceDocument getFinEntitiesDataGroupMaintenanceDocument(Integer finEntitiesDataGroupId, String groupName, Integer sortId) throws Exception {
        FinEntitiesDataGroup finEntitiesDataGroup = new FinEntitiesDataGroup();
        finEntitiesDataGroup.setDataGroupId(finEntitiesDataGroupId);
        finEntitiesDataGroup.setDataGroupName(groupName);
        finEntitiesDataGroup.setDataGroupSortId(sortId);
        return this.newMaintDoc((PersistableBusinessObject)finEntitiesDataGroup);
    }

    private BusinessObjectService getMockBusinessObjectService() {
        final BusinessObjectService service = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, Integer> fieldValues1 = new HashMap<String, Integer>();
                fieldValues1.put(FinEntitiesDataGroupMaintenanceDocumentRuleTest.GROUP_SORT_ID_FIELD_NAME, SORT_ID_1);
                FinEntitiesDataGroup finEntitiesDataGroup = new FinEntitiesDataGroup();
                finEntitiesDataGroup.setDataGroupId(GROUP_ID_1);
                ((BusinessObjectService)this.allowing(service)).findMatching(FinEntitiesDataGroup.class, fieldValues1);
                this.will(1.returnValue(Collections.singleton(finEntitiesDataGroup)));
            }
        });
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put(FinEntitiesDataGroupMaintenanceDocumentRuleTest.GROUP_NAME_FIELD_NAME, FinEntitiesDataGroupMaintenanceDocumentRuleTest.GROUP_NAME);
                FinEntitiesDataGroup finEntitiesDataGroup = new FinEntitiesDataGroup();
                finEntitiesDataGroup.setDataGroupId(GROUP_ID_1);
                ((BusinessObjectService)this.allowing(service)).findMatching(FinEntitiesDataGroup.class, fieldValues);
                this.will(2.returnValue(Collections.singleton(finEntitiesDataGroup)));
            }
        });
        return service;
    }
}

