/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.personfinancialentity;

import java.util.Collections;
import java.util.HashMap;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.coi.personfinancialentity.FinEntitiesDataGroup;
import org.kuali.kra.coi.personfinancialentity.FinEntitiesDataMatrix;
import org.kuali.kra.coi.personfinancialentity.FinEntitiesDataMatrixMaintenanceDocumentRule;
import org.kuali.kra.maintenance.MaintenanceRuleTestBase;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class FinEntitiesDataMatrixMaintenanceDocumentRuleTest
extends MaintenanceRuleTestBase {
    private static final String COLUMN_SORT_ID_FIELD_NAME = "columnSortId";
    private static final String GROUP_ID_FIELD_NAME = "dataGroupId";
    private static final Integer GROUP_ID_1 = 1;
    private static final Integer GROUP_ID_2 = 2;
    private static final Integer SORT_ID_1 = 1;
    private static final String COLUMN_NAME = "Test";
    private static final String COLUMN_NAME_1 = "Test1";
    private FinEntitiesDataMatrixMaintenanceDocumentRule rule;
    private Mockery context = new JUnit4Mockery();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rule = new FinEntitiesDataMatrixMaintenanceDocumentRule();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.rule = null;
        super.tearDown();
    }

    @Test
    public void testUniqueOK() throws Exception {
        MaintenanceDocument finEntitiesDataMatrixMaintenanceDocument = this.getFinEntitiesDataMatrixMaintenanceDocument(COLUMN_NAME, SORT_ID_1, GROUP_ID_1);
        this.rule.setBusinessObjectService(this.getMockBusinessObjectService());
        FinEntitiesDataMatrixMaintenanceDocumentRuleTest.assertTrue((boolean)this.rule.processCustomRouteDocumentBusinessRules(finEntitiesDataMatrixMaintenanceDocument));
        FinEntitiesDataMatrixMaintenanceDocumentRuleTest.assertTrue((boolean)this.rule.processCustomApproveDocumentBusinessRules(finEntitiesDataMatrixMaintenanceDocument));
    }

    @Test
    public void testUniqueNotOK() throws Exception {
        this.rule.setBusinessObjectService(this.getMockBusinessObjectService1());
        MaintenanceDocument finEntitiesDataMatrixMaintenanceDocument = this.getFinEntitiesDataMatrixMaintenanceDocument(COLUMN_NAME_1, SORT_ID_1, GROUP_ID_1);
        FinEntitiesDataMatrixMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomRouteDocumentBusinessRules(finEntitiesDataMatrixMaintenanceDocument));
        FinEntitiesDataMatrixMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomApproveDocumentBusinessRules(finEntitiesDataMatrixMaintenanceDocument));
    }

    private MaintenanceDocument getFinEntitiesDataMatrixMaintenanceDocument(String columnName, Integer sortId, Integer groupId) throws Exception {
        FinEntitiesDataMatrix finEntitiesDataMatrix = new FinEntitiesDataMatrix();
        finEntitiesDataMatrix.setColumnName(columnName);
        finEntitiesDataMatrix.setColumnSortId(sortId);
        finEntitiesDataMatrix.setDataGroupId(groupId);
        return this.newMaintDoc((PersistableBusinessObject)finEntitiesDataMatrix);
    }

    private BusinessObjectService getMockBusinessObjectService() {
        final BusinessObjectService service = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, Integer> fieldValues1 = new HashMap<String, Integer>();
                fieldValues1.put(FinEntitiesDataMatrixMaintenanceDocumentRuleTest.COLUMN_SORT_ID_FIELD_NAME, SORT_ID_1);
                FinEntitiesDataMatrix finEntitiesDataMatrix = new FinEntitiesDataMatrix();
                finEntitiesDataMatrix.setColumnName(FinEntitiesDataMatrixMaintenanceDocumentRuleTest.COLUMN_NAME);
                finEntitiesDataMatrix.setDataGroupId(GROUP_ID_1);
                ((BusinessObjectService)this.allowing(service)).findMatching(FinEntitiesDataMatrix.class, fieldValues1);
                this.will(1.returnValue(Collections.singleton(finEntitiesDataMatrix)));
            }
        });
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, Integer> fieldValues = new HashMap<String, Integer>();
                fieldValues.put(FinEntitiesDataMatrixMaintenanceDocumentRuleTest.GROUP_ID_FIELD_NAME, GROUP_ID_1);
                ((BusinessObjectService)this.allowing(service)).countMatching(FinEntitiesDataGroup.class, fieldValues);
                this.will(2.returnValue((Object)1));
            }
        });
        return service;
    }

    private BusinessObjectService getMockBusinessObjectService1() {
        final BusinessObjectService service = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, Integer> fieldValues1 = new HashMap<String, Integer>();
                fieldValues1.put(FinEntitiesDataMatrixMaintenanceDocumentRuleTest.COLUMN_SORT_ID_FIELD_NAME, SORT_ID_1);
                FinEntitiesDataMatrix finEntitiesDataMatrix = new FinEntitiesDataMatrix();
                finEntitiesDataMatrix.setColumnName(FinEntitiesDataMatrixMaintenanceDocumentRuleTest.COLUMN_NAME);
                finEntitiesDataMatrix.setDataGroupId(GROUP_ID_1);
                ((BusinessObjectService)this.allowing(service)).findMatching(FinEntitiesDataMatrix.class, fieldValues1);
                this.will(3.returnValue(Collections.singleton(finEntitiesDataMatrix)));
            }
        });
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, Integer> fieldValues = new HashMap<String, Integer>();
                fieldValues.put(FinEntitiesDataMatrixMaintenanceDocumentRuleTest.GROUP_ID_FIELD_NAME, GROUP_ID_1);
                ((BusinessObjectService)this.allowing(service)).countMatching(FinEntitiesDataGroup.class, fieldValues);
                this.will(4.returnValue((Object)0));
            }
        });
        return service;
    }
}

