/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.personfinancialentity;

import java.util.Collections;
import java.util.HashMap;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.coi.personfinancialentity.FinIntEntityRelType;
import org.kuali.kra.coi.personfinancialentity.FinIntEntityRelTypeMaintenanceDocumentRule;
import org.kuali.kra.maintenance.MaintenanceRuleTestBase;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class FinIntEntityRelTypeMaintenanceDocumentRuleTest
extends MaintenanceRuleTestBase {
    private static final String REL_TYPE_SORT_ID_FIELD_NAME = "sortId";
    private static final String DESCRIPTION_FIELD_NAME = "description";
    private static final String CODE_1 = "1";
    private static final String CODE_2 = "2";
    private static final Integer SORT_ID_1 = 1;
    private static final String DESCRIPTION_1 = "Test1";
    private static final String DESCRIPTION_2 = "Test2";
    private FinIntEntityRelTypeMaintenanceDocumentRule rule;
    private Mockery context = new JUnit4Mockery();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rule = new FinIntEntityRelTypeMaintenanceDocumentRule();
        this.rule.setBusinessObjectService(this.getMockBusinessObjectService());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.rule = null;
        super.tearDown();
    }

    @Test
    public void testUniqueOK() throws Exception {
        MaintenanceDocument finIntEntityRelTypeMaintenanceDocument = this.getFinIntEntityRelTypeMaintenanceDocument(CODE_1, DESCRIPTION_1, SORT_ID_1);
        FinIntEntityRelTypeMaintenanceDocumentRuleTest.assertTrue((boolean)this.rule.processCustomRouteDocumentBusinessRules(finIntEntityRelTypeMaintenanceDocument));
        FinIntEntityRelTypeMaintenanceDocumentRuleTest.assertTrue((boolean)this.rule.processCustomApproveDocumentBusinessRules(finIntEntityRelTypeMaintenanceDocument));
    }

    @Test
    public void testUniqueNotOK() throws Exception {
        MaintenanceDocument finIntEntityRelTypeMaintenanceDocument = this.getFinIntEntityRelTypeMaintenanceDocument(CODE_2, DESCRIPTION_1, SORT_ID_1);
        FinIntEntityRelTypeMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomRouteDocumentBusinessRules(finIntEntityRelTypeMaintenanceDocument));
        FinIntEntityRelTypeMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomApproveDocumentBusinessRules(finIntEntityRelTypeMaintenanceDocument));
    }

    private MaintenanceDocument getFinIntEntityRelTypeMaintenanceDocument(String typeCode, String description, Integer sortId) throws Exception {
        FinIntEntityRelType finIntEntityRelType = new FinIntEntityRelType();
        finIntEntityRelType.setRelationshipTypeCode(typeCode);
        finIntEntityRelType.setDescription(description);
        finIntEntityRelType.setSortId(sortId);
        return this.newMaintDoc((PersistableBusinessObject)finIntEntityRelType);
    }

    private BusinessObjectService getMockBusinessObjectService() {
        final BusinessObjectService service = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, Integer> fieldValues1 = new HashMap<String, Integer>();
                fieldValues1.put(FinIntEntityRelTypeMaintenanceDocumentRuleTest.REL_TYPE_SORT_ID_FIELD_NAME, SORT_ID_1);
                FinIntEntityRelType finIntEntityRelType = new FinIntEntityRelType();
                finIntEntityRelType.setRelationshipTypeCode(FinIntEntityRelTypeMaintenanceDocumentRuleTest.CODE_1);
                ((BusinessObjectService)this.allowing(service)).findMatching(FinIntEntityRelType.class, fieldValues1);
                this.will(1.returnValue(Collections.singleton(finIntEntityRelType)));
            }
        });
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put(FinIntEntityRelTypeMaintenanceDocumentRuleTest.DESCRIPTION_FIELD_NAME, FinIntEntityRelTypeMaintenanceDocumentRuleTest.DESCRIPTION_1);
                FinIntEntityRelType finIntEntityRelType = new FinIntEntityRelType();
                finIntEntityRelType.setRelationshipTypeCode(FinIntEntityRelTypeMaintenanceDocumentRuleTest.CODE_1);
                ((BusinessObjectService)this.allowing(service)).findMatching(FinIntEntityRelType.class, fieldValues);
                this.will(2.returnValue(Collections.singleton(finIntEntityRelType)));
            }
        });
        return service;
    }
}

