/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.personfinancialentity;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.test.infrastructure.KcSeleniumHelper;
import org.openqa.selenium.WebDriver;

public class FinancialEntitySeleniumHelper
extends KcSeleniumHelper {
    private static FinancialEntitySeleniumHelper helper;

    public static FinancialEntitySeleniumHelper instance(WebDriver driver) {
        if (helper == null) {
            helper = new FinancialEntitySeleniumHelper(driver);
        }
        return helper;
    }

    private FinancialEntitySeleniumHelper(WebDriver driver) {
        super(driver);
    }

    public void FinancialEntityCompleteTest() {
        helper.clickResearcherTab();
        this.click("Financial Entity");
        this.click("methodToCall.editNew");
        this.click("relationDetailControl");
        this.setupFields();
        this.waitForSponsorCodeAjax();
        this.click("methodToCall.submit.new.anchor");
        this.assertNoPageErrors();
        this.click("methodToCall.editList");
        int lastEntityIndex = this.findLastEntity();
        this.click("methodToCall.editActiveFinancialEntity.line" + lastEntityIndex);
        this.set("financialEntityHelper.activeFinancialEntities[" + lastEntityIndex + "].principalBusinessActivity", "test company - v2");
        this.click("methodToCall.save.line" + lastEntityIndex + ".anchor");
        this.checkEditActionOK(lastEntityIndex);
        this.click("methodToCall.submit.line" + lastEntityIndex + ".anchor");
        this.checkEditActionOK(lastEntityIndex);
        this.click("methodToCall.inactivateFinancialEntity.line" + lastEntityIndex + ".anchor");
        this.set("reason", "deactivate");
        this.click("methodToCall.processAnswer.button0");
        this.assertNoPageErrors();
        this.click("methodToCall.activateFinancialEntity.line0.anchor");
        this.assertNoPageErrors();
    }

    private void checkEditActionOK(int lastEntityIndex) {
        this.assertNoPageErrors();
        this.assertElementContains("financialEntityHelper.activeFinancialEntities[" + lastEntityIndex + "].sponsorCode", "005770");
        this.assertElementContains("financialEntityHelper.activeFinancialEntities[" + lastEntityIndex + "].principalBusinessActivity", "test company - v2");
    }

    private void setupFields() {
        this.set("financialEntityHelper.newPersonFinancialEntity.entityName", String.valueOf(new Date().getTime()));
        this.click("financialEntityHelper.newPersonFinancialEntity.sponsorCode");
        this.set("financialEntityHelper.newPersonFinancialEntity.sponsorCode", "005770");
        this.set("financialEntityHelper.newPersonFinancialEntity.entityTypeCode", "1");
        this.set("financialEntityHelper.newPersonFinancialEntity.principalBusinessActivity", "test company");
        this.set("financialEntityHelper.newRelationDetails[0].relationshipTypeBeans[0].stringValue", "1");
        this.click("financialEntityHelper.newRelationDetails[1].relationshipTypeBeans[0].booleanValue");
    }

    private int findLastEntity() {
        int i;
        String message = "";
        for (i = 0; i < 1000; ++i) {
            try {
                message = this.get("methodToCall.editActiveFinancialEntity.line" + i);
                continue;
            }
            catch (AssertionError e) {
                return i - 1;
            }
        }
        return i;
    }

    private void waitForSponsorCodeAjax() {
        int i = 0;
        while (i++ < 10 && StringUtils.isBlank((String)this.get("financialEntityHelper.newPersonFinancialEntity.finEntityContactInfos[0].postalCode"))) {
            try {
                this.wait(500L);
            }
            catch (Exception exception) {}
        }
    }
}

