/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.personfinancialentity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.SequenceOwner;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.coi.personfinancialentity.FinEntitiesDataGroup;
import org.kuali.kra.coi.personfinancialentity.FinEntitiesDataMatrix;
import org.kuali.kra.coi.personfinancialentity.FinEntityDataMatrixBean;
import org.kuali.kra.coi.personfinancialentity.FinIntEntityRelType;
import org.kuali.kra.coi.personfinancialentity.FinancialEntityContactInfo;
import org.kuali.kra.coi.personfinancialentity.FinancialEntityReporter;
import org.kuali.kra.coi.personfinancialentity.FinancialEntityReporterUnit;
import org.kuali.kra.coi.personfinancialentity.FinancialEntityServiceImpl;
import org.kuali.kra.coi.personfinancialentity.PersonFinIntDisclDet;
import org.kuali.kra.coi.personfinancialentity.PersonFinIntDisclosure;
import org.kuali.kra.coi.personfinancialentity.RelationshipTypeBean;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.VersioningService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class FinancialEntityServiceTest {
    private static final String PERSON_ID = "10000000001";
    private static final String UNIT_NUMBER = "000001";
    private static final String UNIT_NAME = "University";
    private static final String ENTITY_NUMBER = "1";
    private static final String ENTITY_NAME_1 = "Entity 1";
    private static final String ENTITY_NAME_2 = "Entity 2";
    private static final String GROUP_NAME_1 = "Group 1";
    private static final String GROUP_NAME_2 = "Group 2";
    private static final String COLUMN_NAME_11 = "COLUMN_NAME_11";
    private static final String COLUMN_LABEL_11 = "Column 11";
    private static final String COLUMN_NAME_12 = "COLUMN_NAME_12";
    private static final String COLUMN_LABEL_12 = "Column 12";
    private static final String COLUMN_NAME_21 = "COLUMN_NAME_21";
    private static final String COLUMN_LABEL_21 = "Column 21";
    private static final String GUITYPE_DROPDOWN = "DROPDOWN";
    private static final String GUITYPE_CHECKBOX = "CHECKBOX";
    private static final String LOOKUP_ARGUIMENT = "Argument 1";
    private static final Integer SORT_ID_1 = 1;
    private static final Integer SORT_ID_2 = 2;
    private static final String COMMENT_1 = "Comment 1";
    Mockery context = new JUnit4Mockery();

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetActiveFinancialEntities() throws Exception {
        FinancialEntityServiceImpl financialEntityService = new FinancialEntityServiceImpl();
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        PersonFinIntDisclosure personFinIntDisclosure = new PersonFinIntDisclosure();
        personFinIntDisclosure.setPersonId(PERSON_ID);
        personFinIntDisclosure.setStatusCode(Integer.valueOf(1));
        personFinIntDisclosure.setCurrentFlag(true);
        personFinIntDisclosure.setEntityNumber(ENTITY_NUMBER);
        personFinIntDisclosure.setEntityName(ENTITY_NAME_1);
        final ArrayList<PersonFinIntDisclosure> activeEntities = new ArrayList<PersonFinIntDisclosure>();
        activeEntities.add(personFinIntDisclosure);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("personId", FinancialEntityServiceTest.PERSON_ID);
                fieldValues.put("statusCode", FinancialEntityServiceTest.ENTITY_NUMBER);
                fieldValues.put("currentFlag", "Y");
                ((BusinessObjectService)this.one(businessObjectService)).findMatchingOrderBy(PersonFinIntDisclosure.class, fieldValues, "entityName", true);
                this.will(1.returnValue((Object)activeEntities));
                HashMap<String, String> fieldValues1 = new HashMap<String, String>();
                fieldValues1.put("entityNumber", FinancialEntityServiceTest.ENTITY_NUMBER);
                ((BusinessObjectService)this.one(businessObjectService)).findMatchingOrderBy(PersonFinIntDisclosure.class, fieldValues1, "sequenceNumber", false);
                this.will(1.returnValue((Object)activeEntities));
            }
        });
        financialEntityService.setBusinessObjectService(businessObjectService);
        List entities = financialEntityService.getFinancialEntities(PERSON_ID, true);
        Assert.assertEquals((long)entities.size(), (long)1L);
        Assert.assertEquals((Object)((PersonFinIntDisclosure)entities.get(0)).getPersonId(), (Object)PERSON_ID);
        Assert.assertEquals((long)((PersonFinIntDisclosure)entities.get(0)).getStatusCode().intValue(), (long)1L);
        Assert.assertEquals((long)((PersonFinIntDisclosure)entities.get(0)).getVersions().size(), (long)1L);
        Assert.assertEquals((Object)((PersonFinIntDisclosure)((PersonFinIntDisclosure)entities.get(0)).getVersions().get(0)).getEntityNumber(), (Object)ENTITY_NUMBER);
        Assert.assertEquals((Object)((PersonFinIntDisclosure)entities.get(0)).isCurrentFlag(), (Object)true);
    }

    @Test
    public void testGetInactiveFinancialEntities() throws Exception {
        FinancialEntityServiceImpl financialEntityService = new FinancialEntityServiceImpl();
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        PersonFinIntDisclosure personFinIntDisclosure = new PersonFinIntDisclosure();
        personFinIntDisclosure.setPersonId(PERSON_ID);
        personFinIntDisclosure.setEntityNumber(ENTITY_NUMBER);
        personFinIntDisclosure.setStatusCode(Integer.valueOf(2));
        personFinIntDisclosure.setEntityName(ENTITY_NAME_1);
        personFinIntDisclosure.setCurrentFlag(true);
        final ArrayList<PersonFinIntDisclosure> activeEntities = new ArrayList<PersonFinIntDisclosure>();
        activeEntities.add(personFinIntDisclosure);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("personId", FinancialEntityServiceTest.PERSON_ID);
                fieldValues.put("statusCode", "2");
                fieldValues.put("currentFlag", "Y");
                ((BusinessObjectService)this.one(businessObjectService)).findMatchingOrderBy(PersonFinIntDisclosure.class, fieldValues, "entityName", true);
                this.will(2.returnValue((Object)activeEntities));
                HashMap<String, String> fieldValues1 = new HashMap<String, String>();
                fieldValues1.put("entityNumber", FinancialEntityServiceTest.ENTITY_NUMBER);
                ((BusinessObjectService)this.one(businessObjectService)).findMatchingOrderBy(PersonFinIntDisclosure.class, fieldValues1, "sequenceNumber", false);
                this.will(2.returnValue((Object)activeEntities));
            }
        });
        financialEntityService.setBusinessObjectService(businessObjectService);
        List entities = financialEntityService.getFinancialEntities(PERSON_ID, false);
        Assert.assertEquals((long)entities.size(), (long)1L);
        Assert.assertEquals((Object)((PersonFinIntDisclosure)entities.get(0)).getPersonId(), (Object)PERSON_ID);
        Assert.assertEquals((long)((PersonFinIntDisclosure)entities.get(0)).getStatusCode().intValue(), (long)2L);
        Assert.assertEquals((long)((PersonFinIntDisclosure)entities.get(0)).getVersions().size(), (long)1L);
        Assert.assertEquals((Object)((PersonFinIntDisclosure)((PersonFinIntDisclosure)entities.get(0)).getVersions().get(0)).getEntityNumber(), (Object)ENTITY_NUMBER);
        Assert.assertEquals((Object)((PersonFinIntDisclosure)entities.get(0)).isCurrentFlag(), (Object)true);
    }

    @Test
    public void testGetFinancialEntityReporter() throws Exception {
        FinancialEntityServiceImpl financialEntityService = new FinancialEntityServiceImpl();
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        FinancialEntityReporter reporter = new FinancialEntityReporter();
        reporter.setPersonId(PERSON_ID);
        reporter.setReporterRoleId("FER");
        reporter.setFinancialEntityReporterUnits(new ArrayList());
        FinancialEntityReporterUnit financialEntityReporterUnit = new FinancialEntityReporterUnit(){

            public String getUnitName() {
                return FinancialEntityServiceTest.UNIT_NAME;
            }
        };
        financialEntityReporterUnit.setUnitNumber(UNIT_NUMBER);
        financialEntityReporterUnit.setUnitName(UNIT_NAME);
        financialEntityReporterUnit.setLeadUnitFlag(true);
        reporter.getFinancialEntityReporterUnits().add(financialEntityReporterUnit);
        final ArrayList<FinancialEntityReporter> reporters = new ArrayList<FinancialEntityReporter>();
        reporters.add(reporter);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("personId", FinancialEntityServiceTest.PERSON_ID);
                fieldValues.put("reporterRoleId", "FER");
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(FinancialEntityReporter.class, fieldValues);
                this.will(4.returnValue((Object)reporters));
            }
        });
        financialEntityService.setBusinessObjectService(businessObjectService);
        FinancialEntityReporter financialEntityReporter = financialEntityService.getFinancialEntityReporter(PERSON_ID);
        Assert.assertEquals((long)financialEntityReporter.getFinancialEntityReporterUnits().size(), (long)1L);
        Assert.assertEquals((Object)financialEntityReporter.getPersonId(), (Object)PERSON_ID);
        Assert.assertEquals((Object)financialEntityReporter.getReporterRoleId(), (Object)"FER");
        Assert.assertEquals((Object)((FinancialEntityReporterUnit)financialEntityReporter.getFinancialEntityReporterUnits().get(0)).getUnitNumber(), (Object)UNIT_NUMBER);
        Assert.assertEquals((Object)((FinancialEntityReporterUnit)financialEntityReporter.getFinancialEntityReporterUnits().get(0)).getUnitName(), (Object)UNIT_NAME);
    }

    @Test
    public void testGetFinancialEntityRelationshipTypes() throws Exception {
        FinancialEntityServiceImpl financialEntityService = new FinancialEntityServiceImpl();
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        final ArrayList<FinIntEntityRelType> relationTypes = new ArrayList<FinIntEntityRelType>();
        relationTypes.add(this.getFinIntEntityRelType(ENTITY_NUMBER, 1, true));
        relationTypes.add(this.getFinIntEntityRelType("2", 2, true));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("active", "Y");
                ((BusinessObjectService)this.one(businessObjectService)).findMatchingOrderBy(FinIntEntityRelType.class, fieldValues, "sortId", true);
                this.will(5.returnValue((Object)relationTypes));
            }
        });
        financialEntityService.setBusinessObjectService(businessObjectService);
        List returnRelationTypes = financialEntityService.getFinancialEntityRelationshipTypes();
        Assert.assertEquals((long)returnRelationTypes.size(), (long)2L);
        Assert.assertEquals((Object)((FinIntEntityRelType)returnRelationTypes.get(0)).getRelationshipTypeCode(), (Object)ENTITY_NUMBER);
        Assert.assertEquals((Object)((FinIntEntityRelType)returnRelationTypes.get(0)).getSortId(), (Object)new Integer(1));
        Assert.assertEquals((Object)((FinIntEntityRelType)returnRelationTypes.get(1)).getRelationshipTypeCode(), (Object)"2");
        Assert.assertEquals((Object)((FinIntEntityRelType)returnRelationTypes.get(1)).getSortId(), (Object)new Integer(2));
    }

    @Test
    public void testGetFinancialEntityDataMatrix() throws Exception {
        FinancialEntityServiceImpl financialEntityService = new FinancialEntityServiceImpl();
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        final ArrayList<FinIntEntityRelType> relationTypes = new ArrayList<FinIntEntityRelType>();
        relationTypes.add(this.getFinIntEntityRelType(ENTITY_NUMBER, 1, true));
        relationTypes.add(this.getFinIntEntityRelType("2", 2, true));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("active", "Y");
                ((BusinessObjectService)this.one(businessObjectService)).findMatchingOrderBy(FinIntEntityRelType.class, fieldValues, "sortId", true);
                this.will(6.returnValue((Object)relationTypes));
            }
        });
        final List<FinEntitiesDataGroup> dataGroups = this.getDataGroups();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findAll(FinEntitiesDataGroup.class);
                this.will(7.returnValue((Object)dataGroups));
            }
        });
        financialEntityService.setBusinessObjectService(businessObjectService);
        List dataMatrixs = financialEntityService.getFinancialEntityDataMatrix();
        Assert.assertEquals((long)dataMatrixs.size(), (long)3L);
        Assert.assertEquals((Object)((FinEntityDataMatrixBean)dataMatrixs.get(0)).getColumnName(), (Object)COLUMN_NAME_11);
        Assert.assertEquals((Object)((FinEntityDataMatrixBean)dataMatrixs.get(1)).getColumnName(), (Object)COLUMN_NAME_12);
        Assert.assertEquals((Object)((FinEntityDataMatrixBean)dataMatrixs.get(2)).getColumnName(), (Object)COLUMN_NAME_21);
        Assert.assertEquals((Object)((FinEntityDataMatrixBean)dataMatrixs.get(0)).getColumnLabel(), (Object)COLUMN_LABEL_11);
        Assert.assertEquals((Object)((FinEntityDataMatrixBean)dataMatrixs.get(1)).getColumnLabel(), (Object)COLUMN_LABEL_12);
        Assert.assertEquals((Object)((FinEntityDataMatrixBean)dataMatrixs.get(2)).getColumnLabel(), (Object)COLUMN_LABEL_21);
        Assert.assertEquals((Object)((FinEntityDataMatrixBean)dataMatrixs.get(0)).getGuiType(), (Object)GUITYPE_DROPDOWN);
        Assert.assertEquals((Object)((FinEntityDataMatrixBean)dataMatrixs.get(1)).getGuiType(), (Object)GUITYPE_CHECKBOX);
        Assert.assertEquals((Object)((FinEntityDataMatrixBean)dataMatrixs.get(2)).getGuiType(), (Object)GUITYPE_CHECKBOX);
        Assert.assertEquals((Object)((FinEntityDataMatrixBean)dataMatrixs.get(0)).getLookupArgument(), (Object)LOOKUP_ARGUIMENT);
        Assert.assertEquals((Object)((FinEntityDataMatrixBean)dataMatrixs.get(1)).getLookupArgument(), (Object)"");
        Assert.assertEquals((Object)((FinEntityDataMatrixBean)dataMatrixs.get(2)).getLookupArgument(), (Object)"");
    }

    @Test
    public void testGetFinDisclosureDetails() throws Exception {
        FinancialEntityServiceImpl financialEntityService = new FinancialEntityServiceImpl();
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        final ArrayList<FinIntEntityRelType> relationTypes = new ArrayList<FinIntEntityRelType>();
        relationTypes.add(this.getFinIntEntityRelType(ENTITY_NUMBER, 1, true));
        relationTypes.add(this.getFinIntEntityRelType("2", 2, true));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("active", "Y");
                ((BusinessObjectService)this.one(businessObjectService)).findMatchingOrderBy(FinIntEntityRelType.class, fieldValues, "sortId", true);
                this.will(8.returnValue((Object)relationTypes));
            }
        });
        final List<FinEntitiesDataGroup> dataGroups = this.getDataGroups();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findAll(FinEntitiesDataGroup.class);
                this.will(9.returnValue((Object)dataGroups));
            }
        });
        financialEntityService.setBusinessObjectService(businessObjectService);
        List dataMatrixs = financialEntityService.getFinancialEntityDataMatrix();
        ((RelationshipTypeBean)((FinEntityDataMatrixBean)dataMatrixs.get(0)).getRelationshipTypeBeans().get(0)).setStringValue(ENTITY_NUMBER);
        ((RelationshipTypeBean)((FinEntityDataMatrixBean)dataMatrixs.get(1)).getRelationshipTypeBeans().get(1)).setBooleanValue(true);
        ((FinEntityDataMatrixBean)dataMatrixs.get(2)).setComments(COMMENT_1);
        List disclosureDetails = financialEntityService.getFinDisclosureDetails(dataMatrixs, ENTITY_NUMBER, Integer.valueOf(1));
        Assert.assertEquals((long)disclosureDetails.size(), (long)4L);
        Assert.assertEquals((Object)((PersonFinIntDisclDet)disclosureDetails.get(0)).getColumnName(), (Object)COLUMN_NAME_11);
        Assert.assertEquals((Object)((PersonFinIntDisclDet)disclosureDetails.get(1)).getColumnName(), (Object)COLUMN_NAME_12);
        Assert.assertEquals((Object)((PersonFinIntDisclDet)disclosureDetails.get(2)).getColumnName(), (Object)COLUMN_NAME_21);
        Assert.assertEquals((Object)((PersonFinIntDisclDet)disclosureDetails.get(3)).getColumnName(), (Object)COLUMN_NAME_21);
        Assert.assertEquals((Object)((PersonFinIntDisclDet)disclosureDetails.get(0)).getColumnValue(), (Object)ENTITY_NUMBER);
        Assert.assertEquals((Object)((PersonFinIntDisclDet)disclosureDetails.get(1)).getColumnValue(), (Object)ENTITY_NUMBER);
        Assert.assertEquals((Object)((PersonFinIntDisclDet)disclosureDetails.get(2)).getComments(), (Object)COMMENT_1);
        Assert.assertEquals((Object)((PersonFinIntDisclDet)disclosureDetails.get(3)).getComments(), (Object)COMMENT_1);
    }

    @Test
    public void testGetFinancialEntityDataMatrixForEdit() throws Exception {
        FinancialEntityServiceImpl financialEntityService = new FinancialEntityServiceImpl();
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        final ArrayList<FinIntEntityRelType> relationTypes = new ArrayList<FinIntEntityRelType>();
        relationTypes.add(this.getFinIntEntityRelType(ENTITY_NUMBER, 1, true));
        relationTypes.add(this.getFinIntEntityRelType("2", 2, true));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("active", "Y");
                ((BusinessObjectService)this.one(businessObjectService)).findMatchingOrderBy(FinIntEntityRelType.class, fieldValues, "sortId", true);
                this.will(10.returnValue((Object)relationTypes));
                ((BusinessObjectService)this.one(businessObjectService)).findMatchingOrderBy(FinIntEntityRelType.class, fieldValues, "sortId", true);
                this.will(10.returnValue((Object)relationTypes));
            }
        });
        final List<FinEntitiesDataGroup> dataGroups = this.getDataGroups();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findAll(FinEntitiesDataGroup.class);
                this.will(11.returnValue((Object)dataGroups));
                ((BusinessObjectService)this.one(businessObjectService)).findAll(FinEntitiesDataGroup.class);
                this.will(11.returnValue((Object)dataGroups));
            }
        });
        financialEntityService.setBusinessObjectService(businessObjectService);
        List dataMatrixs = financialEntityService.getFinancialEntityDataMatrix();
        ((RelationshipTypeBean)((FinEntityDataMatrixBean)dataMatrixs.get(0)).getRelationshipTypeBeans().get(0)).setStringValue(ENTITY_NUMBER);
        ((RelationshipTypeBean)((FinEntityDataMatrixBean)dataMatrixs.get(1)).getRelationshipTypeBeans().get(1)).setBooleanValue(true);
        ((FinEntityDataMatrixBean)dataMatrixs.get(2)).setComments(COMMENT_1);
        List disclosureDetails = financialEntityService.getFinDisclosureDetails(dataMatrixs, ENTITY_NUMBER, Integer.valueOf(1));
        List matrixBeans = financialEntityService.getFinancialEntityDataMatrixForEdit(disclosureDetails);
        Assert.assertEquals((long)matrixBeans.size(), (long)3L);
    }

    @Test
    public void testVersionPersonFinintDisclosures() throws Exception {
        FinancialEntityServiceImpl financialEntityService = new FinancialEntityServiceImpl();
        final VersioningService versioningService = (VersioningService)this.context.mock(VersioningService.class);
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        final PersonFinIntDisclosure personFinIntDisclosure = new PersonFinIntDisclosure();
        personFinIntDisclosure.setPersonId(PERSON_ID);
        personFinIntDisclosure.setEntityNumber(ENTITY_NUMBER);
        personFinIntDisclosure.setSequenceNumber(Integer.valueOf(1));
        personFinIntDisclosure.setStatusCode(Integer.valueOf(2));
        personFinIntDisclosure.setCurrentFlag(true);
        personFinIntDisclosure.setPersonFinIntDisclosureId(Long.valueOf(1L));
        ArrayList<FinancialEntityContactInfo> contactInfos = new ArrayList<FinancialEntityContactInfo>();
        FinancialEntityContactInfo contactInfo = new FinancialEntityContactInfo();
        contactInfo.setPersonFinIntDisclosureId(Long.valueOf(1L));
        contactInfo.setFinancialEntityContactInfoId(Long.valueOf(2L));
        contactInfos.add(contactInfo);
        personFinIntDisclosure.setFinEntityContactInfos(contactInfos);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                PersonFinIntDisclosure newPersonFinIntDisclosure = FinancialEntityServiceTest.this.getPersonFinancialEntityDiscl();
                ((VersioningService)this.one(versioningService)).createNewVersion((SequenceOwner)personFinIntDisclosure);
                this.will(12.returnValue((Object)newPersonFinIntDisclosure));
            }
        });
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, Long> fieldValues = new HashMap<String, Long>();
                fieldValues.put("personFinIntDisclosureId", 1L);
                ((BusinessObjectService)this.one(businessObjectService)).findByPrimaryKey(PersonFinIntDisclosure.class, fieldValues);
                this.will(13.returnValue((Object)personFinIntDisclosure));
                ((BusinessObjectService)this.one(businessObjectService)).save((PersistableBusinessObject)personFinIntDisclosure);
            }
        });
        financialEntityService.setBusinessObjectService(businessObjectService);
        financialEntityService.setVersioningService(versioningService);
        PersonFinIntDisclosure newDisclosure = financialEntityService.versionPersonFinintDisclosure(personFinIntDisclosure, new ArrayList(), new ArrayList());
        Assert.assertEquals((Object)newDisclosure.getSequenceNumber(), (Object)new Integer(2));
        Assert.assertNull((Object)((FinancialEntityContactInfo)newDisclosure.getFinEntityContactInfos().get(0)).getPersonFinIntDisclosureId());
        Assert.assertNull((Object)((FinancialEntityContactInfo)newDisclosure.getFinEntityContactInfos().get(0)).getFinancialEntityContactInfoId());
        Assert.assertTrue((boolean)newDisclosure.isCurrentFlag());
        Assert.assertFalse((boolean)personFinIntDisclosure.isCurrentFlag());
    }

    private PersonFinIntDisclosure getPersonFinancialEntityDiscl() {
        PersonFinIntDisclosure personFinIntDisclosure = new PersonFinIntDisclosure();
        personFinIntDisclosure.setPersonId(PERSON_ID);
        personFinIntDisclosure.setEntityNumber(ENTITY_NUMBER);
        personFinIntDisclosure.setSequenceNumber(Integer.valueOf(2));
        personFinIntDisclosure.setStatusCode(Integer.valueOf(2));
        personFinIntDisclosure.setCurrentFlag(true);
        ArrayList<FinancialEntityContactInfo> contactInfos = new ArrayList<FinancialEntityContactInfo>();
        FinancialEntityContactInfo contactInfo = new FinancialEntityContactInfo();
        contactInfo.setPersonFinIntDisclosureId(Long.valueOf(1L));
        contactInfo.setFinancialEntityContactInfoId(Long.valueOf(2L));
        contactInfos.add(contactInfo);
        personFinIntDisclosure.setFinEntityContactInfos(contactInfos);
        return personFinIntDisclosure;
    }

    private List<FinEntitiesDataGroup> getDataGroups() {
        ArrayList<FinEntitiesDataGroup> dataGroups = new ArrayList<FinEntitiesDataGroup>();
        FinEntitiesDataGroup dataGroup1 = new FinEntitiesDataGroup();
        dataGroup1.setDataGroupId(Integer.valueOf(1));
        dataGroup1.setDataGroupName(GROUP_NAME_1);
        dataGroup1.setDataGroupSortId(SORT_ID_1);
        dataGroup1.setFinEntitiesDataMatrixs(new ArrayList());
        dataGroup1.getFinEntitiesDataMatrixs().add(this.getFinEntitiesDataMatrix(COLUMN_NAME_11, GUITYPE_DROPDOWN, LOOKUP_ARGUIMENT, COLUMN_LABEL_11));
        dataGroup1.getFinEntitiesDataMatrixs().add(this.getFinEntitiesDataMatrix(COLUMN_NAME_12, GUITYPE_CHECKBOX, "", COLUMN_LABEL_12));
        dataGroups.add(dataGroup1);
        FinEntitiesDataGroup dataGroup2 = new FinEntitiesDataGroup();
        dataGroup2.setDataGroupId(Integer.valueOf(2));
        dataGroup2.setDataGroupSortId(SORT_ID_2);
        dataGroup2.setDataGroupName(GROUP_NAME_2);
        dataGroup2.setFinEntitiesDataMatrixs(new ArrayList());
        dataGroup2.getFinEntitiesDataMatrixs().add(this.getFinEntitiesDataMatrix(COLUMN_NAME_21, GUITYPE_CHECKBOX, "", COLUMN_LABEL_21));
        dataGroup2.getFinEntitiesDataMatrixs().add(this.getFinEntitiesDataMatrix(COLUMN_NAME_12, GUITYPE_CHECKBOX, "", COLUMN_LABEL_12));
        ((FinEntitiesDataMatrix)dataGroup2.getFinEntitiesDataMatrixs().get(1)).setActive(false);
        dataGroups.add(dataGroup2);
        return dataGroups;
    }

    private FinEntitiesDataMatrix getFinEntitiesDataMatrix(String columnName, String guiType, String lookupArgument, String columnLabel) {
        FinEntitiesDataMatrix dataMatrix = new FinEntitiesDataMatrix();
        dataMatrix.setColumnName(columnName);
        dataMatrix.setGuiType(guiType);
        dataMatrix.setLookupArgument(lookupArgument);
        dataMatrix.setColumnLabel(columnLabel);
        dataMatrix.setActive(true);
        return dataMatrix;
    }

    private FinIntEntityRelType getFinIntEntityRelType(String code, Integer sortId, boolean active) {
        FinIntEntityRelType finIntEntityRelType = new FinIntEntityRelType();
        finIntEntityRelType.setRelationshipTypeCode(code);
        finIntEntityRelType.setSortId(sortId);
        finIntEntityRelType.setActive(active);
        finIntEntityRelType.setDescription("Description" + code);
        return finIntEntityRelType;
    }

    private KcPersonService getMockKcPersonService() {
        final KcPersonService kcPersonService = (KcPersonService)this.context.mock(KcPersonService.class);
        final KcPerson kcPerson = new KcPerson(){

            public String getUserName() {
                return "quickstart";
            }

            public Unit getUnit() {
                Unit unit = new Unit();
                unit.setUnitNumber(FinancialEntityServiceTest.UNIT_NUMBER);
                unit.setUnitName(FinancialEntityServiceTest.UNIT_NAME);
                return unit;
            }
        };
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((KcPersonService)this.allowing(kcPersonService)).getKcPersonByPersonId(FinancialEntityServiceTest.PERSON_ID);
                this.will(15.returnValue((Object)kcPerson));
            }
        });
        return kcPersonService;
    }
}

