/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.SequenceOwner;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeMembership;
import org.kuali.kra.committee.bo.CommitteeMembershipExpertise;
import org.kuali.kra.committee.bo.CommitteeResearchArea;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipRole;
import org.kuali.kra.common.committee.bo.CommitteeResearchAreaBase;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.protocol.location.ProtocolLocationService;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.protocol.location.ProtocolLocationBase;
import org.kuali.kra.service.VersioningService;
import org.kuali.kra.service.impl.VersioningServiceImpl;

public class CommitteeVersioningTest
implements Serializable {
    private transient VersioningService versioningService;
    private Committee originalCommittee;

    @Before
    public void setUp() {
        this.versioningService = new VersioningServiceImpl();
        this.originalCommittee = this.createCommittee("Test", "The Verion Test Committee");
    }

    @After
    public void tearDown() {
        this.versioningService = null;
        this.originalCommittee = null;
    }

    @Test
    public void testCommitteeVersioning() throws Exception {
        Committee versionedCommittee = (Committee)this.versioningService.createNewVersion((SequenceOwner)this.originalCommittee);
        this.verifyVersioning(this.originalCommittee, versionedCommittee);
    }

    @Test
    public void testCommitteeResearchAreaVersioning() throws Exception {
        this.originalCommittee.getCommitteeResearchAreas().add(this.createCommitteeResearchArea("RA74"));
        this.originalCommittee.getCommitteeResearchAreas().add(this.createCommitteeResearchArea("RA34"));
        this.originalCommittee.getCommitteeResearchAreas().add(this.createCommitteeResearchArea("RA86"));
        Committee versionedCommittee = (Committee)this.versioningService.createNewVersion((SequenceOwner)this.originalCommittee);
        this.verifyVersioning(this.originalCommittee, versionedCommittee);
    }

    @Test
    public void testCommitteeMembershipVersioning() throws Exception {
        this.originalCommittee.getCommitteeMemberships().add(this.createCommitteeMembership("John Doe"));
        CommitteeMembership committeeMember2 = this.createCommitteeMembership("Sahra White");
        committeeMember2.getMembershipRoles().add(this.createCommitteeMembershipRole("Chair"));
        committeeMember2.getMembershipRoles().add(this.createCommitteeMembershipRole("Member"));
        committeeMember2.getMembershipExpertise().add(this.createCommitteeMembershipExpertise("E439"));
        committeeMember2.getMembershipExpertise().add(this.createCommitteeMembershipExpertise("E295"));
        committeeMember2.getMembershipExpertise().add(this.createCommitteeMembershipExpertise("E571"));
        this.originalCommittee.getCommitteeMemberships().add(committeeMember2);
        CommitteeMembership committeeMember3 = this.createCommitteeMembership("Bob Tester");
        committeeMember3.getMembershipRoles().add(this.createCommitteeMembershipRole("Vice Chair"));
        committeeMember3.getMembershipRoles().add(this.createCommitteeMembershipRole("Member"));
        committeeMember3.getMembershipRoles().add(this.createCommitteeMembershipRole("IRB Administrator"));
        committeeMember3.getMembershipExpertise().add(this.createCommitteeMembershipExpertise("E555"));
        committeeMember3.getMembershipExpertise().add(this.createCommitteeMembershipExpertise("E183"));
        this.originalCommittee.getCommitteeMemberships().add(committeeMember3);
        Committee versionedCommittee = (Committee)this.versioningService.createNewVersion((SequenceOwner)this.originalCommittee);
        this.verifyVersioning(this.originalCommittee, versionedCommittee);
    }

    @Test
    public void testCommitteeScheduleVersioning() throws Exception {
        this.originalCommittee.getCommitteeSchedules().add(this.createCommitteeSchedule("2009-12-25"));
        ((CommitteeSchedule)this.originalCommittee.getCommitteeSchedules().get(0)).setCommittee(this.originalCommittee);
        Committee versionedCommittee = (Committee)this.versioningService.createNewVersion((SequenceOwner)this.originalCommittee);
        this.verifyVersioning(this.originalCommittee, versionedCommittee);
    }

    private Committee createCommittee(String committeeId, String committeeName) {
        Committee committee = new Committee();
        committee.setCommitteeId(committeeId);
        committee.setCommitteeName(committeeName);
        return committee;
    }

    private CommitteeResearchArea createCommitteeResearchArea(String researchAreaCode) {
        CommitteeResearchArea committeeResearchArea = new CommitteeResearchArea();
        committeeResearchArea.setResearchAreaCode(researchAreaCode);
        return committeeResearchArea;
    }

    private CommitteeMembership createCommitteeMembership(String name) {
        CommitteeMembership committeeMembership = new CommitteeMembership();
        committeeMembership.setPersonName(name);
        return committeeMembership;
    }

    private CommitteeMembershipRole createCommitteeMembershipRole(String membershipRoleCode) {
        CommitteeMembershipRole committeeMembershipRole = new CommitteeMembershipRole();
        committeeMembershipRole.setMembershipRoleCode(membershipRoleCode);
        return committeeMembershipRole;
    }

    private CommitteeMembershipExpertise createCommitteeMembershipExpertise(String researchAreaCode) {
        CommitteeMembershipExpertise committeeMembershipExpertise = new CommitteeMembershipExpertise();
        committeeMembershipExpertise.setResearchAreaCode(researchAreaCode);
        return committeeMembershipExpertise;
    }

    private CommitteeSchedule createCommitteeSchedule(String date) {
        CommitteeSchedule committeeSchedule = new CommitteeSchedule();
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(this.createProtocol());
        committeeSchedule.setProtocols(protocols);
        committeeSchedule.setScheduledDate(Date.valueOf(date));
        committeeSchedule.setTime(Timestamp.valueOf(date + " 00:00:00"));
        return committeeSchedule;
    }

    private Protocol createProtocol() {
        Protocol p = new Protocol(){
            private static final long serialVersionUID = 1L;

            public void refreshReferenceObject(String referenceObjectName) {
            }

            protected ProtocolLocationService getProtocolLocationService() {
                return new ProtocolLocationService(){

                    public void addDefaultProtocolLocation(ProtocolBase protocol) {
                    }

                    public void addProtocolLocation(ProtocolBase protocol, ProtocolLocationBase protocolLocation) {
                    }

                    public void clearProtocolLocationAddress(ProtocolBase protocol, int lineNumber) {
                    }
                };
            }
        };
        p.setProtocolNumber("1001");
        p.setSequenceNumber(Integer.valueOf(1));
        p.setProtocolId(Long.valueOf(1L));
        return p;
    }

    private void verifyVersioning(Committee originalCommittee, Committee versionedCommittee) {
        Assert.assertEquals((Object)originalCommittee.getCommitteeId(), (Object)versionedCommittee.getCommitteeId());
        Assert.assertEquals((Object)originalCommittee.getCommitteeName(), (Object)versionedCommittee.getCommitteeName());
        Integer expectedSequenceNumber = originalCommittee.getSequenceNumber() + 1;
        Assert.assertEquals((Object)expectedSequenceNumber, (Object)versionedCommittee.getSequenceNumber());
        Assert.assertEquals((long)originalCommittee.getCommitteeResearchAreas().size(), (long)versionedCommittee.getCommitteeResearchAreas().size());
        ArrayList<String> versionedResearchAreaCodes = new ArrayList<String>();
        for (CommitteeResearchAreaBase versionedResearchArea : versionedCommittee.getCommitteeResearchAreas()) {
            versionedResearchAreaCodes.add(versionedResearchArea.getResearchAreaCode());
        }
        for (CommitteeResearchAreaBase originalResearchArea : originalCommittee.getCommitteeResearchAreas()) {
            Assert.assertTrue((boolean)versionedResearchAreaCodes.contains(originalResearchArea.getResearchAreaCode()));
        }
        Assert.assertEquals((long)originalCommittee.getCommitteeMemberships().size(), (long)versionedCommittee.getCommitteeMemberships().size());
        HashMap<String, Integer> versionedMembershipMapping = new HashMap<String, Integer>();
        for (CommitteeMembershipBase versionedMembership : versionedCommittee.getCommitteeMemberships()) {
            versionedMembershipMapping.put(versionedMembership.getPersonName(), versionedCommittee.getCommitteeMemberships().indexOf(versionedMembership));
        }
        for (CommitteeMembershipBase originalMembership : originalCommittee.getCommitteeMemberships()) {
            Assert.assertTrue((boolean)versionedMembershipMapping.containsKey(originalMembership.getPersonName()));
            Integer index = (Integer)versionedMembershipMapping.get(originalMembership.getPersonName());
            this.verifyMembershipRoleExpertiseVersioning((CommitteeMembership)originalMembership, (CommitteeMembership)versionedCommittee.getCommitteeMemberships().get(index));
        }
        Assert.assertEquals((long)originalCommittee.getCommitteeSchedules().size(), (long)versionedCommittee.getCommitteeSchedules().size());
        ArrayList<Date> versionedScheduledDates = new ArrayList<Date>();
        for (CommitteeSchedule versionedSchedule : versionedCommittee.getCommitteeSchedules()) {
            versionedScheduledDates.add(versionedSchedule.getScheduledDate());
        }
        for (CommitteeSchedule originalSchedule : originalCommittee.getCommitteeSchedules()) {
            Assert.assertTrue((boolean)versionedScheduledDates.contains(originalSchedule.getScheduledDate()));
        }
        if (originalCommittee.getCommitteeSchedules().size() > 0) {
            Assert.assertEquals((long)((CommitteeSchedule)originalCommittee.getCommitteeSchedules().get(0)).getProtocols().size(), (long)((CommitteeSchedule)versionedCommittee.getCommitteeSchedules().get(0)).getProtocols().size());
            Protocol pRef = (Protocol)((CommitteeSchedule)originalCommittee.getCommitteeSchedules().get(0)).getProtocols().get(0);
            Protocol pCheck = (Protocol)((CommitteeSchedule)versionedCommittee.getCommitteeSchedules().get(0)).getProtocols().get(0);
            Assert.assertTrue((pRef != pCheck ? 1 : 0) != 0);
            Assert.assertEquals((Object)pRef.getProtocolId(), (Object)pCheck.getProtocolId());
        }
    }

    private void verifyMembershipRoleExpertiseVersioning(CommitteeMembership originalMembership, CommitteeMembership versionedMembership) {
        Assert.assertEquals((long)originalMembership.getMembershipRoles().size(), (long)versionedMembership.getMembershipRoles().size());
        Assert.assertEquals((long)originalMembership.getMembershipExpertise().size(), (long)versionedMembership.getMembershipExpertise().size());
        ArrayList<String> versionedRoleCodes = new ArrayList<String>();
        for (CommitteeMembershipRole versionedMembershipRole : versionedMembership.getMembershipRoles()) {
            versionedRoleCodes.add(versionedMembershipRole.getMembershipRoleCode());
        }
        for (CommitteeMembershipRole originalRoleCode : originalMembership.getMembershipRoles()) {
            Assert.assertTrue((boolean)versionedRoleCodes.contains(originalRoleCode.getMembershipRoleCode()));
        }
    }
}

