/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.authorizers;

import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.document.CommitteeDocument;
import org.kuali.kra.committee.document.authorizer.CommitteeActionAuthorizer;
import org.kuali.kra.committee.service.CommitteeService;
import org.kuali.kra.committee.test.CommitteeFactory;
import org.kuali.kra.common.committee.document.authorization.CommitteeTaskBase;
import org.kuali.kra.common.committee.service.CommitteeServiceBase;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.service.impl.mocks.KraAuthorizationServiceMock;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.GlobalVariables;

public class CommitteeActionAuthorizerTest
extends KcUnitTestBase {
    private static final String USERNAME = "quickstart";
    private static final String COMMITTEE_ID = "Actn Auth Test";
    private CommitteeDocument committeeDocument;
    private Mockery context = new JUnit4Mockery();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setUserSession((UserSession)new UserSession(USERNAME));
        this.committeeDocument = CommitteeFactory.createCommitteeDocument(COMMITTEE_ID);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        GlobalVariables.setUserSession(null);
        super.tearDown();
    }

    @Test
    public void testPerformActionsPermission() throws WorkflowException {
        CommitteeActionAuthorizer authorizer = new CommitteeActionAuthorizer();
        final Committee committee = (Committee)this.committeeDocument.getCommittee();
        final CommitteeService committeeService = (CommitteeService)this.context.mock(CommitteeService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CommitteeService)this.allowing(committeeService)).getCommitteeById(CommitteeActionAuthorizerTest.COMMITTEE_ID);
                this.will(1.returnValue((Object)committee));
            }
        });
        authorizer.setCommitteeService((CommitteeServiceBase)committeeService);
        KraAuthorizationServiceMock kraAuthorizationService = new KraAuthorizationServiceMock(true);
        authorizer.setKraAuthorizationService((KraAuthorizationService)kraAuthorizationService);
        this.committeeDocument.getDocumentHeader().getWorkflowDocument().route("");
        CommitteeTaskBase<Committee> task = new CommitteeTaskBase<Committee>("committee", "performCommitteeActions", (Committee)this.committeeDocument.getCommittee()){};
        CommitteeActionAuthorizerTest.assertEquals((Object)true, (Object)authorizer.isAuthorized(USERNAME, (CommitteeTaskBase)task));
    }

    @Test
    public void testNoPerformActionsPermissionBasedOnPermission() throws WorkflowException {
        CommitteeActionAuthorizer authorizer = new CommitteeActionAuthorizer();
        final Committee committee = (Committee)this.committeeDocument.getCommittee();
        final CommitteeService committeeService = (CommitteeService)this.context.mock(CommitteeService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CommitteeService)this.allowing(committeeService)).getCommitteeById(CommitteeActionAuthorizerTest.COMMITTEE_ID);
                this.will(3.returnValue((Object)committee));
            }
        });
        authorizer.setCommitteeService((CommitteeServiceBase)committeeService);
        KraAuthorizationServiceMock kraAuthorizationService = new KraAuthorizationServiceMock(false);
        authorizer.setKraAuthorizationService((KraAuthorizationService)kraAuthorizationService);
        this.committeeDocument.getDocumentHeader().getWorkflowDocument().route("");
        CommitteeTaskBase<Committee> task = new CommitteeTaskBase<Committee>("committee", "performCommitteeActions", (Committee)this.committeeDocument.getCommittee()){};
        CommitteeActionAuthorizerTest.assertEquals((Object)false, (Object)authorizer.isAuthorized(USERNAME, (CommitteeTaskBase)task));
    }

    @Test
    public void testNoPerformActionsPermissionBasedOnDocumentStatus() throws WorkflowException {
        CommitteeActionAuthorizer authorizer = new CommitteeActionAuthorizer();
        final Committee committee = (Committee)this.committeeDocument.getCommittee();
        final CommitteeService committeeService = (CommitteeService)this.context.mock(CommitteeService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CommitteeService)this.allowing(committeeService)).getCommitteeById(CommitteeActionAuthorizerTest.COMMITTEE_ID);
                this.will(5.returnValue((Object)committee));
            }
        });
        authorizer.setCommitteeService((CommitteeServiceBase)committeeService);
        KraAuthorizationServiceMock kraAuthorizationService = new KraAuthorizationServiceMock(true);
        authorizer.setKraAuthorizationService((KraAuthorizationService)kraAuthorizationService);
        CommitteeTaskBase<Committee> task = new CommitteeTaskBase<Committee>("committee", "performCommitteeActions", (Committee)this.committeeDocument.getCommittee()){};
        CommitteeActionAuthorizerTest.assertEquals((Object)false, (Object)authorizer.isAuthorized(USERNAME, (CommitteeTaskBase)task));
    }

    @Test
    public void testNoPerformActionsPermissionBasedOnVersion() throws WorkflowException {
        CommitteeActionAuthorizer authorizer = new CommitteeActionAuthorizer();
        final Committee committee = new Committee();
        committee.setId(Long.valueOf(1L));
        final CommitteeService committeeService = (CommitteeService)this.context.mock(CommitteeService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CommitteeService)this.allowing(committeeService)).getCommitteeById(CommitteeActionAuthorizerTest.COMMITTEE_ID);
                this.will(7.returnValue((Object)committee));
            }
        });
        authorizer.setCommitteeService((CommitteeServiceBase)committeeService);
        KraAuthorizationServiceMock kraAuthorizationService = new KraAuthorizationServiceMock(true);
        authorizer.setKraAuthorizationService((KraAuthorizationService)kraAuthorizationService);
        this.committeeDocument.getDocumentHeader().getWorkflowDocument().route("");
        CommitteeTaskBase<Committee> task = new CommitteeTaskBase<Committee>("committee", "performCommitteeActions", (Committee)this.committeeDocument.getCommittee()){};
        CommitteeActionAuthorizerTest.assertEquals((Object)false, (Object)authorizer.isAuthorized(USERNAME, (CommitteeTaskBase)task));
    }
}

