/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.authorizers;

import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kra.authorization.ApplicationTask;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.authorizer.CreateCommitteeAuthorizer;
import org.kuali.kra.service.UnitAuthorizationService;

@RunWith(value=JMock.class)
public class CreateCommitteeAuthorizerTest {
    private static final String USERNAME = "quickstart";
    private Mockery context = new JUnit4Mockery();

    @Test
    public void testHasPermission() {
        CreateCommitteeAuthorizer authorizer = new CreateCommitteeAuthorizer();
        final UnitAuthorizationService unitAuthorizationService = (UnitAuthorizationService)this.context.mock(UnitAuthorizationService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((UnitAuthorizationService)this.one(unitAuthorizationService)).hasPermission(CreateCommitteeAuthorizerTest.USERNAME, "KC-PROTOCOL", "Create CommitteeDocument");
                this.will(1.returnValue((Object)true));
            }
        });
        authorizer.setUnitAuthorizationService(unitAuthorizationService);
        ApplicationTask task = new ApplicationTask("addCommittee");
        Assert.assertEquals((Object)true, (Object)authorizer.isAuthorized(USERNAME, (Task)task));
    }

    @Test
    public void testDoesNotHavePermission() {
        CreateCommitteeAuthorizer authorizer = new CreateCommitteeAuthorizer();
        final UnitAuthorizationService unitAuthorizationService = (UnitAuthorizationService)this.context.mock(UnitAuthorizationService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((UnitAuthorizationService)this.one(unitAuthorizationService)).hasPermission(CreateCommitteeAuthorizerTest.USERNAME, "KC-PROTOCOL", "Create CommitteeDocument");
                this.will(2.returnValue((Object)false));
            }
        });
        authorizer.setUnitAuthorizationService(unitAuthorizationService);
        ApplicationTask task = new ApplicationTask("addCommittee");
        Assert.assertEquals((Object)false, (Object)authorizer.isAuthorized(USERNAME, (Task)task));
    }
}

