/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.authorizers;

import org.junit.Assert;
import org.junit.Test;
import org.kuali.kra.committee.authorizers.UnitAuthorizationServiceMock;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.document.CommitteeDocument;
import org.kuali.kra.committee.document.authorizer.ModifyCommitteeAuthorizer;
import org.kuali.kra.common.committee.document.authorization.CommitteeTaskBase;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.service.UnitAuthorizationService;
import org.kuali.kra.service.impl.mocks.KraAuthorizationServiceMock;
import org.kuali.rice.kew.api.exception.WorkflowException;

public class ModifyCommitteeAuthorizerTest {
    private static final String USERNAME = "quickstart";

    @Test
    public void testCreatePermission() throws WorkflowException {
        ModifyCommitteeAuthorizer authorizer = new ModifyCommitteeAuthorizer();
        UnitAuthorizationServiceMock unitAuthorizationService = new UnitAuthorizationServiceMock(true);
        authorizer.setUnitAuthorizationService((UnitAuthorizationService)unitAuthorizationService);
        Committee committee = this.createCommittee(null, false);
        CommitteeTaskBase<Committee> task = new CommitteeTaskBase<Committee>("committee", "modifyCommittee", committee){};
        Assert.assertEquals((Object)true, (Object)authorizer.isAuthorized(USERNAME, (CommitteeTaskBase)task));
    }

    @Test
    public void testNotCreatePermission() throws WorkflowException {
        ModifyCommitteeAuthorizer authorizer = new ModifyCommitteeAuthorizer();
        UnitAuthorizationServiceMock unitAuthorizationService = new UnitAuthorizationServiceMock(false);
        authorizer.setUnitAuthorizationService((UnitAuthorizationService)unitAuthorizationService);
        Committee committee = this.createCommittee(null, false);
        CommitteeTaskBase<Committee> task = new CommitteeTaskBase<Committee>("committee", "modifyCommittee", committee){};
        Assert.assertEquals((Object)false, (Object)authorizer.isAuthorized(USERNAME, (CommitteeTaskBase)task));
    }

    @Test
    public void testModifyPermission() throws WorkflowException {
        ModifyCommitteeAuthorizer authorizer = new ModifyCommitteeAuthorizer();
        Committee committee = this.createCommittee(1L, false);
        UnitAuthorizationServiceMock unitAuthorizationService = new UnitAuthorizationServiceMock(true);
        authorizer.setUnitAuthorizationService((UnitAuthorizationService)unitAuthorizationService);
        KraAuthorizationServiceMock kraAuthorizationService = new KraAuthorizationServiceMock(true);
        authorizer.setKraAuthorizationService((KraAuthorizationService)kraAuthorizationService);
        CommitteeTaskBase<Committee> task = new CommitteeTaskBase<Committee>("committee", "modifyCommittee", committee){};
        Assert.assertEquals((Object)true, (Object)authorizer.isAuthorized(USERNAME, (CommitteeTaskBase)task));
    }

    @Test
    public void testNotModifyPermission() throws WorkflowException {
        ModifyCommitteeAuthorizer authorizer = new ModifyCommitteeAuthorizer();
        Committee committee = this.createCommittee(1L, false);
        UnitAuthorizationServiceMock unitAuthorizationService = new UnitAuthorizationServiceMock(true);
        authorizer.setUnitAuthorizationService((UnitAuthorizationService)unitAuthorizationService);
        KraAuthorizationServiceMock kraAuthorizationService = new KraAuthorizationServiceMock(false);
        authorizer.setKraAuthorizationService((KraAuthorizationService)kraAuthorizationService);
        CommitteeTaskBase<Committee> task = new CommitteeTaskBase<Committee>("committee", "modifyCommittee", committee){};
        Assert.assertEquals((Object)false, (Object)authorizer.isAuthorized(USERNAME, (CommitteeTaskBase)task));
    }

    @Test
    public void testViewOnly() throws WorkflowException {
        ModifyCommitteeAuthorizer authorizer = new ModifyCommitteeAuthorizer();
        Committee committee = this.createCommittee(1L, true);
        UnitAuthorizationServiceMock unitAuthorizationService = new UnitAuthorizationServiceMock(true);
        authorizer.setUnitAuthorizationService((UnitAuthorizationService)unitAuthorizationService);
        KraAuthorizationServiceMock kraAuthorizationService = new KraAuthorizationServiceMock(true);
        authorizer.setKraAuthorizationService((KraAuthorizationService)kraAuthorizationService);
        CommitteeTaskBase<Committee> task = new CommitteeTaskBase<Committee>("committee", "modifyCommittee", committee){};
        Assert.assertEquals((Object)false, (Object)authorizer.isAuthorized(USERNAME, (CommitteeTaskBase)task));
    }

    private Committee createCommittee(Long id, boolean viewOnly) throws WorkflowException {
        CommitteeDocument doc = new CommitteeDocument();
        ((Committee)doc.getCommittee()).setId(id);
        ((Committee)doc.getCommittee()).setCommitteeId("Committee Test");
        doc.setViewOnly(viewOnly);
        return (Committee)doc.getCommittee();
    }
}

