/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.bo;

import java.sql.Date;
import java.util.Calendar;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.kra.committee.bo.CommitteeMembership;

public class CommitteeMembershipTest {
    @Test
    public void testIsRepresentingPerson() {
        CommitteeMembership cm1 = new CommitteeMembership();
        cm1.setPersonId("person1");
        CommitteeMembership cm2 = new CommitteeMembership();
        cm2.setPersonId("person2");
        CommitteeMembership nullPersonIdMember = new CommitteeMembership();
        nullPersonIdMember.setPersonId(null);
        Assert.assertTrue((boolean)cm1.isRepresentingPerson("person1"));
        Assert.assertTrue((boolean)cm2.isRepresentingPerson("person2"));
        Assert.assertFalse((boolean)cm1.isRepresentingPerson("person2"));
        Assert.assertFalse((boolean)cm2.isRepresentingPerson(null));
        Assert.assertFalse((boolean)nullPersonIdMember.isRepresentingPerson(null));
    }

    @Test
    public void testHasTermEnded() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date dateToday = new Date(cal.getTime().getTime());
        cal.add(5, 1);
        Date dateTomorrow = new Date(cal.getTime().getTime());
        cal.add(5, -2);
        Date dateYesterday = new Date(cal.getTime().getTime());
        CommitteeMembership cm = new CommitteeMembership();
        cm.setTermEndDate(dateYesterday);
        Assert.assertTrue((boolean)cm.hasTermEnded());
        cm.setTermEndDate(dateToday);
        Assert.assertFalse((boolean)cm.hasTermEnded());
        cm.setTermEndDate(dateTomorrow);
        Assert.assertFalse((boolean)cm.hasTermEnded());
        cm.setTermEndDate(null);
        Assert.assertTrue((boolean)cm.hasTermEnded());
    }
}

