/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.bo;

import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.time.DateUtils;
import org.junit.Test;
import org.kuali.kra.committee.bo.BoAttributeTestBase;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeMembership;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.common.committee.web.struts.form.schedule.Time12HrFmt;

public class CommitteeScheduleTest
extends BoAttributeTestBase<CommitteeSchedule> {
    private static final int ATTRIBUTE_COUNT = 31;
    private static final java.sql.Date date = new java.sql.Date(new Date().getTime());
    private static final Timestamp timestamp = new Timestamp(new Date().getTime());
    private static final String FIELD_ID = "id";
    private static final Long FIELD_ID_VALUE = 1L;
    private static final String FIELD_SCHEDULEID = "scheduleId";
    private static final String FIELD_SCHEDULEID_VALUE = "1";
    private static final String FIELD_SCHEDULEDDATE = "scheduledDate";
    private static final java.sql.Date FIELD_SCHEDULEDDATE_VALUE = date;
    private static final String FIELD_PLACE = "place";
    private static final String FIELD_PLACE_VALUE = "Davis 103";
    private static final String FIELD_TIME = "time";
    private static Timestamp FIELD_TIME_VALUE;
    private static final String FIELD_PROTOCOLSUBDEADLINE = "protocolSubDeadline";
    private static final java.sql.Date FIELD_PROTOCOLSUBDEADLINE_VALUE;
    private static final String FIELD_SCHEDULESTATUSCODE = "scheduleStatusCode";
    private static final Integer FIELD_SCHEDULESTATUSCODE_VALUE;
    private static final String FIELD_MEETINGDATE = "meetingDate";
    private static final java.sql.Date FIELD_MEETINGDATE_VALUE;
    private static final String FIELD_STARTTIME = "startTime";
    private static final Timestamp FIELD_STARTTIME_VALUE;
    private static final String FIELD_ENDTIME = "endTime";
    private static final Timestamp FIELD_ENDTIME_VALUE;
    private static final String FIELD_AGENDAPRODREVDATE = "agendaProdRevDate";
    private static final java.sql.Date FIELD_AGENDAPRODREVDATE_VALUE;
    private static final String FIELD_MAXPROTOCOLS = "maxProtocols";
    private static final Integer FIELD_MAXPROTOCOLS_VALUE;
    private static final String FIELD_COMMONTS = "comments";
    private static final String FIELD_COMMONTS_VALUE = "Some comment to test should go here";
    private static final String FIELD_AVAILABLE_TO_REVIEWERS = "availableToReviewers";
    private static final boolean FIELD_AVAILABLE_TO_REVIEWERS_VALUE = true;
    private static CommitteeSchedule cm;

    public CommitteeScheduleTest() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        super(31, cm);
    }

    @Override
    protected Map getFieldMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(FIELD_ID, FIELD_ID_VALUE);
        map.put(FIELD_SCHEDULEID, FIELD_SCHEDULEID_VALUE);
        map.put(FIELD_SCHEDULEDDATE, FIELD_SCHEDULEDDATE_VALUE);
        map.put(FIELD_PLACE, FIELD_PLACE_VALUE);
        map.put(FIELD_TIME, FIELD_TIME_VALUE);
        map.put(FIELD_PROTOCOLSUBDEADLINE, FIELD_PROTOCOLSUBDEADLINE_VALUE);
        map.put(FIELD_SCHEDULESTATUSCODE, FIELD_SCHEDULESTATUSCODE_VALUE);
        map.put(FIELD_MEETINGDATE, FIELD_MEETINGDATE_VALUE);
        map.put(FIELD_STARTTIME, FIELD_STARTTIME_VALUE);
        map.put(FIELD_ENDTIME, FIELD_ENDTIME_VALUE);
        map.put(FIELD_AGENDAPRODREVDATE, FIELD_AGENDAPRODREVDATE_VALUE);
        map.put(FIELD_MAXPROTOCOLS, FIELD_MAXPROTOCOLS_VALUE);
        map.put(FIELD_COMMONTS, FIELD_COMMONTS_VALUE);
        map.put(FIELD_AVAILABLE_TO_REVIEWERS, true);
        return map;
    }

    @Override
    protected void boPrerequisite() {
        super.boPrerequisite();
        Date dt = new Date(0L);
        Time12HrFmt time12HrFmt = new Time12HrFmt("10:30", Time12HrFmt.MERIDIEM.AM);
        dt = DateUtils.round((Date)dt, (int)5);
        dt = DateUtils.addMinutes((Date)dt, (int)time12HrFmt.findMinutes());
        FIELD_TIME_VALUE = new Timestamp(dt.getTime());
    }

    @Override
    protected void boPostrequisite() {
        super.boPostrequisite();
        cm.setViewTime(new Time12HrFmt("10:30", Time12HrFmt.MERIDIEM.AM));
    }

    @Test
    public void testIsActiveFor() {
        CommitteeSchedule novemberSchedule = new CommitteeSchedule();
        novemberSchedule.setScheduledDate(java.sql.Date.valueOf("2011-11-25"));
        CommitteeSchedule decemberSchedule = new CommitteeSchedule();
        decemberSchedule.setScheduledDate(java.sql.Date.valueOf("2011-12-25"));
        CommitteeMembership novemberMember = new CommitteeMembership(){

            public boolean isActive(java.sql.Date date) {
                return date.equals(java.sql.Date.valueOf("2011-11-25"));
            }
        };
        novemberMember.setPersonId("novemberPerson");
        CommitteeMembership decemberMember = new CommitteeMembership(){

            public boolean isActive(java.sql.Date date) {
                return date.equals(java.sql.Date.valueOf("2011-12-25"));
            }
        };
        decemberMember.setPersonId("decemberPerson");
        CommitteeMembership novemberDecemberMember = new CommitteeMembership(){

            public boolean isActive(java.sql.Date date) {
                return date.equals(java.sql.Date.valueOf("2011-12-25")) || date.equals(java.sql.Date.valueOf("2011-11-25"));
            }
        };
        novemberDecemberMember.setPersonId("novemberDecemberPerson");
        CommitteeMembership neitherNovemberNorDecemberMember = new CommitteeMembership(){

            public boolean isActive(java.sql.Date date) {
                return !date.equals(java.sql.Date.valueOf("2011-12-25")) && !date.equals(java.sql.Date.valueOf("2011-11-25"));
            }
        };
        neitherNovemberNorDecemberMember.setPersonId("neitherNovemberNorDecemberPerson");
        Committee committee = new Committee();
        committee.getCommitteeMemberships().add(novemberMember);
        committee.getCommitteeMemberships().add(decemberMember);
        committee.getCommitteeMemberships().add(novemberDecemberMember);
        committee.getCommitteeMemberships().add(neitherNovemberNorDecemberMember);
        decemberSchedule.setCommittee(committee);
        novemberSchedule.setCommittee(committee);
        CommitteeScheduleTest.assertTrue((boolean)novemberSchedule.isActiveFor("novemberPerson"));
        CommitteeScheduleTest.assertTrue((boolean)decemberSchedule.isActiveFor("decemberPerson"));
        CommitteeScheduleTest.assertFalse((boolean)novemberSchedule.isActiveFor("decemberPerson"));
        CommitteeScheduleTest.assertFalse((boolean)decemberSchedule.isActiveFor("novemberPerson"));
        CommitteeScheduleTest.assertTrue((boolean)decemberSchedule.isActiveFor("novemberDecemberPerson"));
        CommitteeScheduleTest.assertTrue((boolean)novemberSchedule.isActiveFor("novemberDecemberPerson"));
        CommitteeScheduleTest.assertFalse((boolean)novemberSchedule.isActiveFor("neitherNovemberNorDecemberPerson"));
        CommitteeScheduleTest.assertFalse((boolean)decemberSchedule.isActiveFor("neitherNovemberNorDecemberPerson"));
        CommitteeScheduleTest.assertFalse((boolean)novemberSchedule.isActiveFor(null));
        decemberSchedule.setCommittee(null);
        CommitteeScheduleTest.assertFalse((boolean)decemberSchedule.isActiveFor("decemberPerson"));
        decemberSchedule.setCommittee(committee);
        CommitteeScheduleTest.assertTrue((boolean)decemberSchedule.isActiveFor("decemberPerson"));
    }

    static {
        FIELD_PROTOCOLSUBDEADLINE_VALUE = date;
        FIELD_SCHEDULESTATUSCODE_VALUE = 1;
        FIELD_MEETINGDATE_VALUE = date;
        FIELD_STARTTIME_VALUE = timestamp;
        FIELD_ENDTIME_VALUE = timestamp;
        FIELD_AGENDAPRODREVDATE_VALUE = date;
        FIELD_MAXPROTOCOLS_VALUE = 1;
        cm = new CommitteeSchedule();
    }
}

