/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.lookup.keyvalue;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.lookup.keyvalue.CommitteeIdIdPairValuesFinder;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.rice.core.api.util.ConcreteKeyValue;

public class CommitteeIdIdPairValuesFinderTest {
    private final String CMT_1_ID = "c1";
    private final String CMT_2_ID = "c2";
    private final String CMT_3_ID = "c3";
    private final String CMT_4_ID = "c4";

    @Test
    public void testGetKeyValues() {
        Committee committee1 = new Committee();
        committee1.setCommitteeId(this.CMT_1_ID);
        Committee committee2 = new Committee();
        committee2.setCommitteeId(this.CMT_2_ID);
        Committee committee3 = new Committee();
        committee3.setCommitteeId(this.CMT_3_ID);
        Committee committee4 = new Committee();
        committee4.setCommitteeId(this.CMT_4_ID);
        final ArrayList<Committee> activeCommittees = new ArrayList<Committee>();
        activeCommittees.add(committee1);
        activeCommittees.add(committee2);
        activeCommittees.add(committee3);
        activeCommittees.add(committee4);
        ConcreteKeyValue klp0 = new ConcreteKeyValue("", "select");
        ConcreteKeyValue klp1 = new ConcreteKeyValue("c1", "c1");
        ConcreteKeyValue klp2 = new ConcreteKeyValue("c2", "c2");
        ConcreteKeyValue klp3 = new ConcreteKeyValue("c3", "c3");
        ConcreteKeyValue klp4 = new ConcreteKeyValue("c4", "c4");
        CommitteeIdIdPairValuesFinder finder = new CommitteeIdIdPairValuesFinder(){

            public List<CommitteeBase> getActiveCommittees() {
                return activeCommittees;
            }
        };
        List results = finder.getKeyValues();
        Assert.assertEquals((int)5, (int)results.size());
        Assert.assertTrue((boolean)results.contains(klp0));
        Assert.assertTrue((boolean)results.contains(klp1));
        Assert.assertTrue((boolean)results.contains(klp2));
        Assert.assertTrue((boolean)results.contains(klp3));
        Assert.assertTrue((boolean)results.contains(klp4));
    }
}

