/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.rules;

import java.sql.Date;
import org.junit.Test;
import org.kuali.kra.committee.rule.event.CommitteeActionGenerateBatchCorrespondenceEvent;
import org.kuali.kra.committee.rules.CommitteeActionGenerateBatchCorrespondenceRule;
import org.kuali.kra.rules.TemplateRuleTest;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;

public class CommitteeActionGenerateBatchCorrespondenceRuleTest
extends KcUnitTestBase {
    @Test
    public void testTrue() {
        new TemplateRuleTest<CommitteeActionGenerateBatchCorrespondenceEvent, CommitteeActionGenerateBatchCorrespondenceRule>(){

            @Override
            protected void prerequisite() {
                String batchCorrespondenceTypeCode = "1";
                Date startDate = Date.valueOf("2010-01-01");
                Date endDate = Date.valueOf("2010-12-31");
                String committeeId = "Committee1";
                this.event = new CommitteeActionGenerateBatchCorrespondenceEvent("", null, batchCorrespondenceTypeCode, startDate, endDate, committeeId);
                this.rule = new CommitteeActionGenerateBatchCorrespondenceRule();
                this.expectedReturnValue = true;
            }
        };
    }

    @Test
    public void testFalseMissingBatchCorrespondence() {
        new TemplateRuleTest<CommitteeActionGenerateBatchCorrespondenceEvent, CommitteeActionGenerateBatchCorrespondenceRule>(){

            @Override
            protected void prerequisite() {
                String batchCorrespondenceTypeCode = null;
                Date startDate = Date.valueOf("2010-01-01");
                Date endDate = Date.valueOf("2010-12-31");
                String committeeId = "Committee1";
                this.event = new CommitteeActionGenerateBatchCorrespondenceEvent("", null, batchCorrespondenceTypeCode, startDate, endDate, committeeId);
                this.rule = new CommitteeActionGenerateBatchCorrespondenceRule();
                this.expectedReturnValue = false;
            }
        };
    }

    @Test
    public void testFalseMissingStartDate() {
        new TemplateRuleTest<CommitteeActionGenerateBatchCorrespondenceEvent, CommitteeActionGenerateBatchCorrespondenceRule>(){

            @Override
            protected void prerequisite() {
                String batchCorrespondenceTypeCode = "1";
                Date startDate = null;
                Date endDate = Date.valueOf("2010-12-31");
                String committeeId = "Committee1";
                this.event = new CommitteeActionGenerateBatchCorrespondenceEvent("", null, batchCorrespondenceTypeCode, startDate, endDate, committeeId);
                this.rule = new CommitteeActionGenerateBatchCorrespondenceRule();
                this.expectedReturnValue = false;
            }
        };
    }

    @Test
    public void testFalseMissingEndDate() {
        new TemplateRuleTest<CommitteeActionGenerateBatchCorrespondenceEvent, CommitteeActionGenerateBatchCorrespondenceRule>(){

            @Override
            protected void prerequisite() {
                String batchCorrespondenceTypeCode = "1";
                Date startDate = Date.valueOf("2010-01-01");
                Date endDate = null;
                String committeeId = "Committee1";
                this.event = new CommitteeActionGenerateBatchCorrespondenceEvent("", null, batchCorrespondenceTypeCode, startDate, endDate, committeeId);
                this.rule = new CommitteeActionGenerateBatchCorrespondenceRule();
                this.expectedReturnValue = false;
            }
        };
    }

    @Test
    public void testFalseEndDateBeforeStartDate() {
        new TemplateRuleTest<CommitteeActionGenerateBatchCorrespondenceEvent, CommitteeActionGenerateBatchCorrespondenceRule>(){

            @Override
            protected void prerequisite() {
                String batchCorrespondenceTypeCode = "1";
                Date startDate = Date.valueOf("2010-12-31");
                Date endDate = Date.valueOf("2010-01-01");
                String committeeId = "Committee1";
                this.event = new CommitteeActionGenerateBatchCorrespondenceEvent("", null, batchCorrespondenceTypeCode, startDate, endDate, committeeId);
                this.rule = new CommitteeActionGenerateBatchCorrespondenceRule();
                this.expectedReturnValue = false;
            }
        };
    }
}

