/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.rules;

import java.sql.Date;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeMembership;
import org.kuali.kra.committee.document.CommitteeDocument;
import org.kuali.kra.committee.rules.CommitteeRuleTestBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipRole;
import org.kuali.kra.common.committee.document.CommitteeDocumentBase;
import org.kuali.kra.common.committee.rule.event.AddCommitteeMembershipEvent;
import org.kuali.kra.common.committee.rule.event.AddCommitteeMembershipRoleEvent;
import org.kuali.kra.common.committee.rules.CommitteeMembershipRule;

public class CommitteeMembershipAddRuleTest
extends CommitteeRuleTestBase {
    private CommitteeMembershipRule rule;

    @Before
    public void setup() throws Exception {
        super.setUp();
        this.rule = new CommitteeMembershipRule();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.rule = null;
        super.tearDown();
    }

    @Test
    public void testAddCommitteeMembershipWithNoId() throws Exception {
        CommitteeMembership newCommitteeMembership = new CommitteeMembership();
        CommitteeMembershipAddRuleTest.assertFalse((boolean)this.rule.processAddCommitteeMembershipBusinessRules(this.getAddCommitteeMembershipEvent(newCommitteeMembership)));
        this.assertError("committeeHelper.newCommitteeMembership.personName", "error.committee.membership.person.not.specified");
    }

    @Test
    public void testAddCommitteeMembershipWithPersonId() throws Exception {
        CommitteeMembership newCommitteeMembership = new CommitteeMembership();
        newCommitteeMembership.setPersonId("jtester");
        newCommitteeMembership.setPersonName("jtester");
        boolean result = this.rule.processAddCommitteeMembershipBusinessRules(this.getAddCommitteeMembershipEvent(newCommitteeMembership));
        CommitteeMembershipAddRuleTest.assertTrue((boolean)result);
    }

    @Test
    public void testAddCommitteeMembershipWithRolodexId() throws Exception {
        CommitteeMembership newCommitteeMembership = new CommitteeMembership();
        newCommitteeMembership.setRolodexId(Integer.valueOf(123));
        newCommitteeMembership.setPersonName("jtester");
        boolean result = this.rule.processAddCommitteeMembershipBusinessRules(this.getAddCommitteeMembershipEvent(newCommitteeMembership));
        CommitteeMembershipAddRuleTest.assertTrue((boolean)result);
    }

    @Test
    public void testAddCommitteeMembershipWithPersonName() throws Exception {
        CommitteeMembership newCommitteeMembership = new CommitteeMembership();
        newCommitteeMembership.setPersonId("jtester");
        newCommitteeMembership.setRolodexId(Integer.valueOf(123));
        CommitteeMembershipAddRuleTest.assertFalse((boolean)this.rule.processAddCommitteeMembershipBusinessRules(this.getAddCommitteeMembershipEvent(newCommitteeMembership)));
        this.assertError("committeeHelper.newCommitteeMembership.personName", "error.committee.membership.person.no.name");
    }

    @Test
    public void testAddCommitteeMembershipRoleWithoutRole() throws Exception {
        CommitteeMembershipRole newCommitteeMembershipRole = new CommitteeMembershipRole();
        newCommitteeMembershipRole.setStartDate(Date.valueOf("2009-01-01"));
        newCommitteeMembershipRole.setEndDate(Date.valueOf("2009-01-31"));
        CommitteeMembershipAddRuleTest.assertFalse((boolean)this.rule.processAddCommitteeMembershipRoleBusinessRules(this.getAddCommitteeMembershipRoleEvent(new CommitteeMembership(), newCommitteeMembershipRole)));
        this.assertError("committeeHelper.newCommitteeMembershipRoles[0].membershipRoleCode", "error.committee.membership.role.not.specified");
    }

    @Test
    public void testAddCommitteeMembershipRoleWithoutStartDate() throws Exception {
        CommitteeMembershipRole newCommitteeMembershipRole = new CommitteeMembershipRole();
        newCommitteeMembershipRole.setMembershipRoleCode("1");
        newCommitteeMembershipRole.setEndDate(Date.valueOf("2009-01-31"));
        CommitteeMembershipAddRuleTest.assertFalse((boolean)this.rule.processAddCommitteeMembershipRoleBusinessRules(this.getAddCommitteeMembershipRoleEvent(new CommitteeMembership(), newCommitteeMembershipRole)));
        this.assertError("committeeHelper.newCommitteeMembershipRoles[0].startDate", "error.committee.membership.roleStartDate.not.specified");
    }

    @Test
    public void testAddCommitteeMembershipRoleWithoutEndDate() throws Exception {
        CommitteeMembershipRole newCommitteeMembershipRole = new CommitteeMembershipRole();
        newCommitteeMembershipRole.setMembershipRoleCode("1");
        newCommitteeMembershipRole.setStartDate(Date.valueOf("2009-01-01"));
        CommitteeMembershipAddRuleTest.assertFalse((boolean)this.rule.processAddCommitteeMembershipRoleBusinessRules(this.getAddCommitteeMembershipRoleEvent(new CommitteeMembership(), newCommitteeMembershipRole)));
        this.assertError("committeeHelper.newCommitteeMembershipRoles[0].endDate", "error.committee.membership.roleEndDate.not.specified");
    }

    @Test
    public void testAddCommitteeMembershipRoleWithEndDateBeforeStartDate() throws Exception {
        CommitteeMembershipRole newCommitteeMembershipRole = new CommitteeMembershipRole();
        newCommitteeMembershipRole.setMembershipRoleCode("1");
        newCommitteeMembershipRole.setStartDate(Date.valueOf("2009-01-31"));
        newCommitteeMembershipRole.setEndDate(Date.valueOf("2009-01-01"));
        CommitteeMembershipAddRuleTest.assertFalse((boolean)this.rule.processAddCommitteeMembershipRoleBusinessRules(this.getAddCommitteeMembershipRoleEvent(new CommitteeMembership(), newCommitteeMembershipRole)));
        this.assertError("committeeHelper.newCommitteeMembershipRoles[0].endDate", "error.committee.membership.roleEndDate.before.roleStartDate");
    }

    @Test
    public void testAddCommitteeMembershipRoleWithStartDateOutsideTerm() throws Exception {
        CommitteeMembership committeeMembership = new CommitteeMembership();
        committeeMembership.setTermStartDate(Date.valueOf("2009-01-10"));
        committeeMembership.setTermEndDate(Date.valueOf("2009-01-20"));
        CommitteeMembershipRole newCommitteeMembershipRole = new CommitteeMembershipRole();
        newCommitteeMembershipRole.setMembershipRoleCode("1");
        newCommitteeMembershipRole.setStartDate(Date.valueOf("2009-01-01"));
        newCommitteeMembershipRole.setEndDate(Date.valueOf("2009-01-17"));
        CommitteeMembershipAddRuleTest.assertFalse((boolean)this.rule.processAddCommitteeMembershipRoleBusinessRules(this.getAddCommitteeMembershipRoleEvent(committeeMembership, newCommitteeMembershipRole)));
        this.assertError("committeeHelper.newCommitteeMembershipRoles[0].startDate", "error.committee.membership.roleStartDate.outside.term");
    }

    @Test
    public void testAddCommitteeMembershipRoleWithEndDateOutsideTerm() throws Exception {
        CommitteeMembership committeeMembership = new CommitteeMembership();
        committeeMembership.setTermStartDate(Date.valueOf("2009-01-10"));
        committeeMembership.setTermEndDate(Date.valueOf("2009-01-20"));
        CommitteeMembershipRole newCommitteeMembershipRole = new CommitteeMembershipRole();
        newCommitteeMembershipRole.setMembershipRoleCode("1");
        newCommitteeMembershipRole.setStartDate(Date.valueOf("2009-01-15"));
        newCommitteeMembershipRole.setEndDate(Date.valueOf("2009-01-31"));
        CommitteeMembershipAddRuleTest.assertFalse((boolean)this.rule.processAddCommitteeMembershipRoleBusinessRules(this.getAddCommitteeMembershipRoleEvent(committeeMembership, newCommitteeMembershipRole)));
        this.assertError("committeeHelper.newCommitteeMembershipRoles[0].endDate", "error.committee.membership.roleEndDate.outside.term");
    }

    @Test
    public void testAddCommitteeMembershipRoleWhichOverlapsAnotherRole() throws Exception {
        CommitteeMembership committeeMembership = new CommitteeMembership();
        CommitteeMembershipRole newCommitteeMembershipRole = new CommitteeMembershipRole();
        newCommitteeMembershipRole.setMembershipRoleCode("1");
        newCommitteeMembershipRole.setStartDate(Date.valueOf("2009-01-01"));
        newCommitteeMembershipRole.setEndDate(Date.valueOf("2009-01-15"));
        committeeMembership.getMembershipRoles().add(newCommitteeMembershipRole);
        newCommitteeMembershipRole.setStartDate(Date.valueOf("2009-01-10"));
        newCommitteeMembershipRole.setEndDate(Date.valueOf("2009-01-31"));
        CommitteeMembershipAddRuleTest.assertFalse((boolean)this.rule.processAddCommitteeMembershipRoleBusinessRules(this.getAddCommitteeMembershipRoleEvent(committeeMembership, newCommitteeMembershipRole)));
        this.assertError("committeeHelper.newCommitteeMembershipRoles[0].membershipRoleCode", "error.committee.membership.role.duplicate");
    }

    @Test
    public void testAddCommitteeMembershipRoleWithNoErrors() throws Exception {
        CommitteeMembership committeeMembership = new CommitteeMembership();
        committeeMembership.setTermStartDate(Date.valueOf("2009-01-01"));
        committeeMembership.setTermEndDate(Date.valueOf("2009-01-31"));
        CommitteeMembershipRole committeeMembershipRole = new CommitteeMembershipRole();
        committeeMembershipRole.setMembershipRoleCode("1");
        committeeMembershipRole.setStartDate(Date.valueOf("2009-01-05"));
        committeeMembershipRole.setEndDate(Date.valueOf("2009-01-14"));
        committeeMembership.getMembershipRoles().add(committeeMembershipRole);
        committeeMembershipRole = new CommitteeMembershipRole();
        committeeMembershipRole.setMembershipRoleCode("2");
        committeeMembershipRole.setStartDate(Date.valueOf("2009-01-19"));
        committeeMembershipRole.setEndDate(Date.valueOf("2009-01-28"));
        committeeMembership.getMembershipRoles().add(committeeMembershipRole);
        committeeMembershipRole = new CommitteeMembershipRole();
        committeeMembershipRole.setMembershipRoleCode("1");
        committeeMembershipRole.setStartDate(Date.valueOf("2009-01-20"));
        committeeMembershipRole.setEndDate(Date.valueOf("2009-01-31"));
        CommitteeMembershipAddRuleTest.assertTrue((boolean)this.rule.processAddCommitteeMembershipRoleBusinessRules(this.getAddCommitteeMembershipRoleEvent(committeeMembership, committeeMembershipRole)));
    }

    private AddCommitteeMembershipEvent getAddCommitteeMembershipEvent(CommitteeMembership newCommitteeMembership) throws Exception {
        CommitteeDocument document = this.getNewCommitteeDocument();
        AddCommitteeMembershipEvent event = new AddCommitteeMembershipEvent("", (CommitteeDocumentBase)document, (CommitteeMembershipBase)newCommitteeMembership);
        return event;
    }

    private AddCommitteeMembershipRoleEvent getAddCommitteeMembershipRoleEvent(CommitteeMembership committeeMembership, CommitteeMembershipRole newCommitteeMembershipRole) throws Exception {
        CommitteeDocument document = this.getNewCommitteeDocument();
        ((Committee)document.getCommittee()).getCommitteeMemberships().add(committeeMembership);
        AddCommitteeMembershipRoleEvent event = new AddCommitteeMembershipRoleEvent("", (CommitteeDocumentBase)document, newCommitteeMembershipRole, 0);
        return event;
    }
}

