/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.rules;

import java.sql.Date;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeMembership;
import org.kuali.kra.committee.bo.CommitteeMembershipExpertise;
import org.kuali.kra.committee.document.CommitteeDocument;
import org.kuali.kra.committee.rules.CommitteeDocumentRule;
import org.kuali.kra.committee.rules.CommitteeRuleTestBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipExpertiseBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipRole;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class CommitteeMembershipSaveRuleTest
extends CommitteeRuleTestBase {
    private CommitteeDocumentRule rule;
    private CommitteeMembership committeeMembership;
    private static final String SEPERATOR = ".";
    private static final String INACTIVE_AREAS_OF_EXPERTISE_PREFIX = "document.committeeList[0].committeeMemberships[%1$s].areasOfExpertise.inactive";

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rule = new CommitteeDocumentRule();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.rule = null;
        super.tearDown();
    }

    @Test
    public void testSaveWithEmptyCommitteeMembership() throws Exception {
        CommitteeDocument document = this.getNewCommitteeDocument();
        this.setCommitteeProperties(document);
        this.committeeMembership = this.createMembership(null, null, null, null, null);
        this.addMembership(document, this.committeeMembership);
        boolean rulesPassed = this.rule.processSaveDocument((Document)document);
        CommitteeMembershipSaveRuleTest.assertFalse((boolean)rulesPassed);
        MessageMap errorMap = GlobalVariables.getMessageMap();
        CommitteeMembershipSaveRuleTest.assertEquals((long)5L, (long)errorMap.getErrorCount());
        CommitteeMembershipSaveRuleTest.assertTrue((boolean)errorMap.getErrorMessages().containsKey("document.committeeList[0].committeeMemberships[0].membershipTypeCode"));
        CommitteeMembershipSaveRuleTest.assertTrue((boolean)errorMap.getErrorMessages().containsKey("document.committeeList[0].committeeMemberships[0].termStartDate"));
        CommitteeMembershipSaveRuleTest.assertTrue((boolean)errorMap.getErrorMessages().containsKey("document.committeeList[0].committeeMemberships[0].termEndDate"));
        this.assertError("committeeHelper.newCommitteeMembershipRoles[0].membershipRoleCode", "error.committee.membership.role.missing");
        this.assertError("committeeHelper.newCommitteeMembershipExpertise[0].researchAreaCode", "error.committee.membership.expertise.missing");
    }

    @Test
    public void testSaveWithInvalidTermDate() throws Exception {
        CommitteeDocument document = this.getNewCommitteeDocument();
        this.setCommitteeProperties(document);
        this.committeeMembership = this.createMembership("jtester", null, "1", "2009-01-15", "2009-01-14");
        this.addRole(this.committeeMembership, "1", null, null);
        this.addExpertise(this.committeeMembership, "000001");
        this.addMembership(document, this.committeeMembership);
        boolean rulesPassed = this.rule.processSaveDocument((Document)document);
        CommitteeMembershipSaveRuleTest.assertFalse((boolean)rulesPassed);
        MessageMap errorMap = GlobalVariables.getMessageMap();
        CommitteeMembershipSaveRuleTest.assertEquals((long)3L, (long)errorMap.getErrorCount());
        this.assertError("document.committeeList[0].committeeMemberships[0].termEndDate", "error.committee.membership.termEndDate.before.termStartDate");
        CommitteeMembershipSaveRuleTest.assertTrue((boolean)errorMap.getErrorMessages().containsKey("document.committeeList[0].committeeMemberships[0].membershipRoles[0].startDate"));
        CommitteeMembershipSaveRuleTest.assertTrue((boolean)errorMap.getErrorMessages().containsKey("document.committeeList[0].committeeMemberships[0].membershipRoles[0].endDate"));
    }

    @Test
    public void testSaveWithRoleDatesOutsideTerm() throws Exception {
        CommitteeDocument document = this.getNewCommitteeDocument();
        this.setCommitteeProperties(document);
        this.committeeMembership = this.createMembership("jtester", null, "1", "2009-01-10", "2009-01-20");
        this.addRole(this.committeeMembership, "1", "2009-01-08", "2009-01-22");
        this.addExpertise(this.committeeMembership, "000001");
        this.addMembership(document, this.committeeMembership);
        boolean rulesPassed = this.rule.processSaveDocument((Document)document);
        CommitteeMembershipSaveRuleTest.assertFalse((boolean)rulesPassed);
        MessageMap errorMap = GlobalVariables.getMessageMap();
        CommitteeMembershipSaveRuleTest.assertEquals((long)2L, (long)errorMap.getErrorCount());
        this.assertError("document.committeeList[0].committeeMemberships[0].membershipRoles[0].startDate", "error.committee.membership.roleStartDate.outside.term");
        this.assertError("document.committeeList[0].committeeMemberships[0].membershipRoles[0].endDate", "error.committee.membership.roleEndDate.outside.term");
    }

    @Test
    public void testSaveWithOverlappingRoles() throws Exception {
        CommitteeDocument document = this.getNewCommitteeDocument();
        this.setCommitteeProperties(document);
        this.committeeMembership = this.createMembership("jtester", null, "1", "2009-01-10", "2009-01-20");
        this.addRole(this.committeeMembership, "1", "2009-01-14", "2009-01-15");
        this.addRole(this.committeeMembership, "1", "2009-01-15", "2009-01-16");
        this.addExpertise(this.committeeMembership, "000001");
        this.addMembership(document, this.committeeMembership);
        boolean rulesPassed = this.rule.processSaveDocument((Document)document);
        CommitteeMembershipSaveRuleTest.assertFalse((boolean)rulesPassed);
        MessageMap errorMap = GlobalVariables.getMessageMap();
        CommitteeMembershipSaveRuleTest.assertEquals((long)1L, (long)errorMap.getErrorCount());
        this.assertError("document.committeeList[0].committeeMemberships[0].membershipRoles[0].membershipRoleCode", "error.committee.membership.role.duplicate");
    }

    @Test
    public void testSaveWithOverlappingMembership() throws Exception {
        CommitteeDocument document = this.getNewCommitteeDocument();
        this.setCommitteeProperties(document);
        this.committeeMembership = this.createMembership("jtester", null, "1", "2009-01-10", "2009-01-15");
        this.addRole(this.committeeMembership, "1", "2009-01-10", "2009-01-15");
        this.addExpertise(this.committeeMembership, "000001");
        this.addMembership(document, this.committeeMembership);
        this.committeeMembership = this.createMembership("jtester", null, "1", "2009-01-10", "2009-01-15");
        this.addRole(this.committeeMembership, "1", "2009-01-10", "2009-01-15");
        this.addExpertise(this.committeeMembership, "000001");
        this.addMembership(document, this.committeeMembership);
        boolean rulesPassed = this.rule.processSaveDocument((Document)document);
        CommitteeMembershipSaveRuleTest.assertFalse((boolean)rulesPassed);
        MessageMap errorMap = GlobalVariables.getMessageMap();
        CommitteeMembershipSaveRuleTest.assertEquals((long)1L, (long)errorMap.getErrorCount());
        this.assertError("document.committeeList[0].committeeMemberships[1].termStartDate", "error.committee.membership.person.duplicate");
    }

    @Test
    public void testSaveWithInactiveAreas() throws Exception {
        CommitteeDocument document = this.getNewCommitteeDocument();
        this.setCommitteeProperties(document);
        CommitteeMembership committeeMembership0 = new CommitteeMembership();
        CommitteeMembership committeeMembership1 = new CommitteeMembership();
        CommitteeMembership committeeMembership2 = new CommitteeMembership();
        this.addMembership(document, committeeMembership0);
        this.addMembership(document, committeeMembership1);
        this.addMembership(document, committeeMembership2);
        this.addExpertise(committeeMembership0, "0");
        this.addExpertise(committeeMembership0, "1");
        ((CommitteeMembershipExpertiseBase)committeeMembership0.getMembershipExpertise().get(1)).getResearchArea().setActive(false);
        this.addExpertise(committeeMembership1, "00");
        this.addExpertise(committeeMembership1, "11");
        ((CommitteeMembershipExpertiseBase)committeeMembership1.getMembershipExpertise().get(0)).getResearchArea().setActive(false);
        this.addExpertise(committeeMembership2, "000");
        this.addExpertise(committeeMembership2, "111");
        ((CommitteeMembershipExpertiseBase)committeeMembership2.getMembershipExpertise().get(0)).getResearchArea().setActive(false);
        ((CommitteeMembershipExpertiseBase)committeeMembership2.getMembershipExpertise().get(1)).getResearchArea().setActive(false);
        boolean rulesPassed = this.rule.processSaveDocument((Document)document);
        CommitteeMembershipSaveRuleTest.assertFalse((boolean)rulesPassed);
        String errorPropertyKey0 = String.format(INACTIVE_AREAS_OF_EXPERTISE_PREFIX, 0) + SEPERATOR + "1.";
        String errorPropertyKey1 = String.format(INACTIVE_AREAS_OF_EXPERTISE_PREFIX, 1) + SEPERATOR + "0.";
        String errorPropertyKey2 = String.format(INACTIVE_AREAS_OF_EXPERTISE_PREFIX, 2) + SEPERATOR + "0.1.";
        this.assertError(errorPropertyKey0, "error.committee.membership.expertise.inactive");
        this.assertError(errorPropertyKey1, "error.committee.membership.expertise.inactive");
        this.assertError(errorPropertyKey2, "error.committee.membership.expertise.inactive");
    }

    @Test
    public void testValidSave() throws Exception {
        CommitteeDocument document = this.getNewCommitteeDocument();
        this.setCommitteeProperties(document);
        this.committeeMembership = this.createMembership("jtester", null, "1", "2009-01-01", "2009-01-10");
        this.addRole(this.committeeMembership, "1", "2009-01-01", "2009-01-10");
        this.addRole(this.committeeMembership, "2", "2009-01-01", "2009-01-10");
        this.addExpertise(this.committeeMembership, "000001");
        this.addExpertise(this.committeeMembership, "000002");
        this.addMembership(document, this.committeeMembership);
        this.committeeMembership = this.createMembership("jtester", null, "1", "2009-01-11", "2009-01-20");
        this.addRole(this.committeeMembership, "1", "2009-01-11", "2009-01-15");
        this.addRole(this.committeeMembership, "1", "2009-01-16", "2009-01-20");
        this.addExpertise(this.committeeMembership, "000001");
        this.addMembership(document, this.committeeMembership);
        this.committeeMembership = this.createMembership(null, 1, "1", "2009-01-01", "2009-01-20");
        this.addRole(this.committeeMembership, "1", "2009-01-01", "2009-01-20");
        this.addRole(this.committeeMembership, "2", "2009-01-01", "2009-01-10");
        this.addExpertise(this.committeeMembership, "000001");
        this.addMembership(document, this.committeeMembership);
        boolean rulesPassed = this.rule.processSaveDocument((Document)document);
        CommitteeMembershipSaveRuleTest.assertTrue((boolean)rulesPassed);
    }

    private CommitteeMembership createMembership(String personID, Integer rolodexID, String membershipTypeCode, String termStartDate, String termEndDate) {
        CommitteeMembership committeeMembership = new CommitteeMembership();
        committeeMembership.setPersonId(personID);
        committeeMembership.setRolodexId(rolodexID);
        committeeMembership.setMembershipTypeCode(membershipTypeCode);
        if (termStartDate != null) {
            committeeMembership.setTermStartDate(Date.valueOf(termStartDate));
        }
        if (termEndDate != null) {
            committeeMembership.setTermEndDate(Date.valueOf(termEndDate));
        }
        return committeeMembership;
    }

    private void addMembership(CommitteeDocument document, CommitteeMembership committeeMembership) {
        ((Committee)document.getCommittee()).getCommitteeMemberships().add(committeeMembership);
    }

    private void addRole(CommitteeMembership committeeMembership, String membershipRoleCode, String startDate, String endDate) {
        CommitteeMembershipRole committeeMembershipRole = new CommitteeMembershipRole();
        committeeMembershipRole.setMembershipRoleCode(membershipRoleCode);
        if (startDate != null) {
            committeeMembershipRole.setStartDate(Date.valueOf(startDate));
        }
        if (endDate != null) {
            committeeMembershipRole.setEndDate(Date.valueOf(endDate));
        }
        committeeMembership.getMembershipRoles().add(committeeMembershipRole);
    }

    private void addExpertise(CommitteeMembership committeeMembership, String researchAreaCode) {
        CommitteeMembershipExpertise committeeMembershipExpertise = new CommitteeMembershipExpertise();
        committeeMembershipExpertise.setResearchAreaCode(researchAreaCode);
        committeeMembershipExpertise.getResearchArea().setActive(true);
        committeeMembership.getMembershipExpertise().add(committeeMembershipExpertise);
    }

    @Test
    public void testCheckResearchAreasForCommitteeMember() throws Exception {
        CommitteeDocument document = this.getNewCommitteeDocument();
        this.setCommitteeProperties(document);
        CommitteeMembership committeeMembership = new CommitteeMembership();
        this.addMembership(document, committeeMembership);
        this.addExpertise(committeeMembership, "0");
        this.addExpertise(committeeMembership, "1");
        this.addExpertise(committeeMembership, "2");
        this.addExpertise(committeeMembership, "3");
        CommitteeMembershipSaveRuleTest.assertTrue((boolean)this.rule.checkResearchAreasForCommitteeMember((CommitteeMembershipBase)committeeMembership, 0));
        ((CommitteeMembershipExpertiseBase)committeeMembership.getMembershipExpertise().get(1)).getResearchArea().setActive(false);
        ((CommitteeMembershipExpertiseBase)committeeMembership.getMembershipExpertise().get(3)).getResearchArea().setActive(false);
        CommitteeMembershipSaveRuleTest.assertFalse((boolean)this.rule.checkResearchAreasForCommitteeMember((CommitteeMembershipBase)committeeMembership, 0));
        String errorPropertyKey = String.format(INACTIVE_AREAS_OF_EXPERTISE_PREFIX, 0) + SEPERATOR + "1.3.";
        this.assertError(errorPropertyKey, "error.committee.membership.expertise.inactive");
    }
}

