/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.rules;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.document.CommitteeDocument;
import org.kuali.kra.committee.rules.CommitteeDocumentRule;
import org.kuali.kra.committee.rules.CommitteeRuleTestBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class CommitteeRuleTest
extends CommitteeRuleTestBase {
    private CommitteeDocumentRule rule;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rule = new CommitteeDocumentRule();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.rule = null;
        super.tearDown();
    }

    @Test
    public void testRequiredFields() throws Exception {
        CommitteeDocument document = this.getNewCommitteeDocument();
        boolean rulesPassed = this.rule.processCustomSaveDocumentBusinessRules((Document)document);
        CommitteeRuleTest.assertFalse((boolean)rulesPassed);
        MessageMap errorMap = GlobalVariables.getMessageMap();
        CommitteeRuleTest.assertEquals((long)8L, (long)errorMap.getErrorCount());
        CommitteeRuleTest.assertTrue((boolean)errorMap.getErrorMessages().containsKey("document.documentHeader.documentDescription"));
        CommitteeRuleTest.assertTrue((boolean)errorMap.getErrorMessages().containsKey("document.committeeList[0].maxProtocols"));
        CommitteeRuleTest.assertTrue((boolean)errorMap.getErrorMessages().containsKey("document.committeeList[0].homeUnitNumber"));
        CommitteeRuleTest.assertTrue((boolean)errorMap.getErrorMessages().containsKey("document.committeeList[0].minimumMembersRequired"));
        CommitteeRuleTest.assertTrue((boolean)errorMap.getErrorMessages().containsKey("document.committeeList[0].committeeName"));
        CommitteeRuleTest.assertTrue((boolean)errorMap.getErrorMessages().containsKey("document.committeeList[0].advancedSubmissionDaysRequired"));
        CommitteeRuleTest.assertTrue((boolean)errorMap.getErrorMessages().containsKey("document.committeeList[0].committeeId"));
    }

    @Test
    public void testDuplicateIds() throws Exception {
        CommitteeDocument document = this.getNewCommitteeDocument();
        this.setCommitteeProperties(document);
        this.documentService.saveDocument((Document)document);
        String committeeId = ((Committee)document.getCommittee()).getCommitteeId();
        document = this.getNewCommitteeDocument();
        this.setCommitteeProperties(document);
        ((Committee)document.getCommittee()).setCommitteeId(committeeId);
        boolean rulesPassed = this.rule.processSaveDocument((Document)document);
        CommitteeRuleTest.assertFalse((boolean)rulesPassed);
        MessageMap errorMap = GlobalVariables.getMessageMap();
        CommitteeRuleTest.assertTrue((boolean)errorMap.containsMessageKey("error.committee.duplicateId"));
    }

    @Test
    public void testInvalidHomeUnit() throws Exception {
        CommitteeDocument document = this.getNewCommitteeDocument();
        this.setCommitteeProperties(document);
        ((Committee)document.getCommittee()).setHomeUnitNumber("xxx");
        boolean rulesPassed = this.rule.processSaveDocument((Document)document);
        CommitteeRuleTest.assertFalse((boolean)rulesPassed);
        MessageMap errorMap = GlobalVariables.getMessageMap();
        CommitteeRuleTest.assertTrue((boolean)errorMap.containsMessageKey("error.invalid.unit"));
    }
}

