/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.rules;

import java.util.Date;
import java.util.HashMap;
import org.junit.After;
import org.junit.Before;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.document.CommitteeDocument;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.springframework.util.AutoPopulatingList;

public abstract class CommitteeRuleTestBase
extends KcUnitTestBase {
    protected DocumentService documentService = null;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        KNSGlobalVariables.setAuditErrorMap(new HashMap());
        this.documentService = KRADServiceLocatorWeb.getDocumentService();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        GlobalVariables.setUserSession(null);
        GlobalVariables.setMessageMap(null);
        KNSGlobalVariables.setAuditErrorMap(null);
        this.documentService = null;
        super.tearDown();
    }

    protected void setCommitteeProperties(CommitteeDocument document) {
        Committee committee = (Committee)document.getCommittee();
        document.getDocumentHeader().setDocumentDescription("test");
        committee.setCommitteeId(new Long(new Date().getTime()).toString());
        committee.setCommitteeName("test");
        committee.setCommitteeTypeCode("1");
        committee.setHomeUnitNumber("000001");
        committee.setCommitteeDescription("description");
        committee.setMaxProtocols(Integer.valueOf(5));
        committee.setMinimumMembersRequired(Integer.valueOf(4));
        committee.setAdvancedSubmissionDaysRequired(Integer.valueOf(3));
        committee.setReviewTypeCode("1");
        committee.setScheduleDescription("schedule description");
    }

    protected CommitteeDocument getNewCommitteeDocument() throws WorkflowException {
        return (CommitteeDocument)this.documentService.getNewDocument("CommitteeDocument");
    }

    protected void assertError(String propertyKey, String errorKey) {
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages(propertyKey);
        CommitteeRuleTestBase.assertNotNull((Object)errors);
        CommitteeRuleTestBase.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        ErrorMessage message = (ErrorMessage)errors.get(0);
        CommitteeRuleTestBase.assertNotNull((Object)message);
        CommitteeRuleTestBase.assertEquals((Object)message.getErrorKey(), (Object)errorKey);
    }
}

