/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.rules;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.time.DateUtils;
import org.junit.Test;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.committee.rule.event.CommitteeScheduleDateConflictEvent;
import org.kuali.kra.committee.rule.event.CommitteeScheduleEventBase;
import org.kuali.kra.committee.rules.CommitteeScheduleDateConflictRule;
import org.kuali.kra.common.committee.web.struts.form.schedule.ScheduleData;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class CommitteeScheduleDateConflictRuleTest
extends KcUnitTestBase {
    private ScheduleData scheduleData;
    private CommitteeScheduleDateConflictEvent event;
    private CommitteeScheduleDateConflictRule rule;
    private static final java.sql.Date DATE_1 = new java.sql.Date(new Date().getTime());
    private static final java.sql.Date DATE_2 = new java.sql.Date(DateUtils.addDays((Date)new Date(), (int)1).getTime());

    @Override
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        KNSGlobalVariables.setAuditErrorMap(new HashMap());
    }

    @Test
    public void testHardErrorTrue() throws Exception {
        List<CommitteeSchedule> list = this.prerequisiteHardError();
        this.event = new CommitteeScheduleDateConflictEvent("", null, null, list, CommitteeScheduleEventBase.ErrorType.HARDERROR);
        boolean val = this.executeRule();
        CommitteeScheduleDateConflictRuleTest.assertTrue((boolean)val);
    }

    @Test
    public void testHardErrorFalse() throws Exception {
        List<CommitteeSchedule> list = this.prerequisiteHardError();
        CommitteeSchedule temp = new CommitteeSchedule();
        temp.setScheduledDate(DATE_1);
        list.add(temp);
        this.event = new CommitteeScheduleDateConflictEvent("", null, null, list, CommitteeScheduleEventBase.ErrorType.HARDERROR);
        boolean val = this.executeRule();
        CommitteeScheduleDateConflictRuleTest.assertFalse((boolean)val);
    }

    public List<CommitteeSchedule> prerequisiteHardError() {
        ArrayList<CommitteeSchedule> list = new ArrayList<CommitteeSchedule>();
        CommitteeSchedule temp = new CommitteeSchedule();
        temp.setScheduledDate(DATE_1);
        list.add(temp);
        temp = new CommitteeSchedule();
        temp.setScheduledDate(DATE_2);
        list.add(temp);
        return list;
    }

    @Test
    public void testSoftErrorTrue() throws Exception {
        this.prerequisiteSoftError();
        this.event = new CommitteeScheduleDateConflictEvent("", null, this.scheduleData, null, CommitteeScheduleEventBase.ErrorType.SOFTERROR);
        boolean val = this.executeRule();
        CommitteeScheduleDateConflictRuleTest.assertTrue((boolean)val);
    }

    @Test
    public void testSoftErrorFalse() throws Exception {
        this.prerequisiteSoftError();
        this.scheduleData.getDatesInConflict().add(DATE_1);
        this.event = new CommitteeScheduleDateConflictEvent("", null, this.scheduleData, null, CommitteeScheduleEventBase.ErrorType.SOFTERROR);
        boolean val = this.executeRule();
        CommitteeScheduleDateConflictRuleTest.assertTrue((boolean)val);
        Map map = this.rule.getSoftErrors();
        CommitteeScheduleDateConflictRuleTest.assertNotNull(map.get("datesInConflict"));
    }

    private boolean executeRule() {
        this.rule = new CommitteeScheduleDateConflictRule();
        boolean val = this.rule.processRules(this.event);
        return val;
    }

    private void prerequisiteSoftError() {
        this.scheduleData = new ScheduleData();
        this.scheduleData.setDatesInConflict(new ArrayList());
    }
}

