/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.rules;

import org.junit.Test;
import org.kuali.kra.committee.rule.event.CommitteeScheduleDayEvent;
import org.kuali.kra.committee.rule.event.CommitteeScheduleEventBase;
import org.kuali.kra.committee.rules.CommitteeScheduleDayRule;
import org.kuali.kra.common.committee.web.struts.form.schedule.MonthlyScheduleDetails;
import org.kuali.kra.common.committee.web.struts.form.schedule.ScheduleData;
import org.kuali.kra.common.committee.web.struts.form.schedule.StyleKey;
import org.kuali.kra.common.committee.web.struts.form.schedule.YearlyScheduleDetails;
import org.kuali.kra.rules.TemplateRuleTest;

public class CommitteeScheduleDayRuleTest {
    @Test
    public void testTrueMonthly() {
        new TemplateRuleTest<CommitteeScheduleDayEvent, CommitteeScheduleDayRule>(){

            @Override
            protected void prerequisite() {
                ScheduleData scheduleData = new ScheduleData();
                scheduleData.getMonthlySchedule().setDay(Integer.valueOf(31));
                scheduleData.setRecurrenceType(StyleKey.MONTHLY.toString());
                scheduleData.getMonthlySchedule().setMonthOption(MonthlyScheduleDetails.optionValues.XDAYANDXMONTH.toString());
                this.event = new CommitteeScheduleDayEvent("", null, scheduleData, null, CommitteeScheduleEventBase.ErrorType.HARDERROR);
                this.rule = new CommitteeScheduleDayRule();
                this.expectedReturnValue = true;
            }
        };
    }

    @Test
    public void testMonthly() {
        new TemplateRuleTest<CommitteeScheduleDayEvent, CommitteeScheduleDayRule>(){

            @Override
            protected void prerequisite() {
                ScheduleData scheduleData = new ScheduleData();
                scheduleData.getMonthlySchedule().setDay(Integer.valueOf(32));
                scheduleData.setRecurrenceType(StyleKey.MONTHLY.toString());
                scheduleData.getMonthlySchedule().setMonthOption(MonthlyScheduleDetails.optionValues.XDAYANDXMONTH.toString());
                this.event = new CommitteeScheduleDayEvent("", null, scheduleData, null, CommitteeScheduleEventBase.ErrorType.HARDERROR);
                this.rule = new CommitteeScheduleDayRule();
                this.expectedReturnValue = false;
            }
        };
    }

    @Test
    public void testTrueYearly() {
        new TemplateRuleTest<CommitteeScheduleDayEvent, CommitteeScheduleDayRule>(){

            @Override
            protected void prerequisite() {
                ScheduleData scheduleData = new ScheduleData();
                scheduleData.getYearlySchedule().setDay(Integer.valueOf(31));
                scheduleData.setRecurrenceType(StyleKey.YEARLY.toString());
                scheduleData.getYearlySchedule().setYearOption(YearlyScheduleDetails.yearOptionValues.XDAY.toString());
                this.event = new CommitteeScheduleDayEvent("", null, scheduleData, null, CommitteeScheduleEventBase.ErrorType.HARDERROR);
                this.rule = new CommitteeScheduleDayRule();
                this.expectedReturnValue = true;
            }
        };
    }

    @Test
    public void testFalseYearly() {
        new TemplateRuleTest<CommitteeScheduleDayEvent, CommitteeScheduleDayRule>(){

            @Override
            protected void prerequisite() {
                ScheduleData scheduleData = new ScheduleData();
                scheduleData.getYearlySchedule().setDay(Integer.valueOf(33));
                scheduleData.setRecurrenceType(StyleKey.YEARLY.toString());
                scheduleData.getYearlySchedule().setYearOption(YearlyScheduleDetails.yearOptionValues.XDAY.toString());
                this.event = new CommitteeScheduleDayEvent("", null, scheduleData, null, CommitteeScheduleEventBase.ErrorType.HARDERROR);
                this.rule = new CommitteeScheduleDayRule();
                this.expectedReturnValue = false;
            }
        };
    }
}

