/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.rules;

import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.time.DateUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.committee.document.CommitteeDocument;
import org.kuali.kra.committee.rule.event.CommitteeScheduleStartAndEndDateEvent;
import org.kuali.kra.committee.rules.CommitteeScheduleStartAndEndDateRule;
import org.kuali.kra.common.committee.web.struts.form.schedule.DailyScheduleDetails;
import org.kuali.kra.common.committee.web.struts.form.schedule.MonthlyScheduleDetails;
import org.kuali.kra.common.committee.web.struts.form.schedule.ScheduleData;
import org.kuali.kra.common.committee.web.struts.form.schedule.StyleKey;
import org.kuali.kra.common.committee.web.struts.form.schedule.WeeklyScheduleDetails;
import org.kuali.kra.common.committee.web.struts.form.schedule.YearlyScheduleDetails;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class CommitteeScheduleStartAndEndDateRuleTest {
    private CommitteeDocument document;
    private ScheduleData scheduleData;
    private CommitteeScheduleStartAndEndDateEvent event;
    public static String DAILY = "scheduleData.dailySchedule.scheduleEndDate";
    public static String WEEKLY = "scheduleData.weeklySchedule.scheduleEndDate";
    public static String MONTHLY = "scheduleData.monthlySchedule.scheduleEndDate";
    public static String YEARLY = "scheduleData.yearlySchedule.scheduleEndDate";
    public static String START_DATE = "scheduleData.scheduleEndDate";

    @Before
    public void setUp() {
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        KNSGlobalVariables.setAuditErrorMap(new HashMap());
    }

    @Test
    public void testEmptyStartDate() throws Exception {
        this.prerequisite(StyleKey.NEVER);
        this.event.getScheduleData().setScheduleStartDate(null);
        this.testAssertFalse();
    }

    @Test
    public void testNever() throws Exception {
        this.prerequisite(StyleKey.NEVER);
        this.testAssertTrue();
    }

    @Test
    public void testDailyForTrue() throws Exception {
        this.prerequisite(StyleKey.DAILY);
        this.scheduleData.setDailySchedule(new DailyScheduleDetails());
        Date dt = DateUtils.addDays((Date)new Date(), (int)1);
        this.scheduleData.getDailySchedule().setScheduleEndDate(new java.sql.Date(dt.getTime()));
        this.testAssertTrue();
    }

    @Test
    public void testDailyForFalse() throws Exception {
        this.prerequisite(StyleKey.DAILY);
        this.scheduleData.setDailySchedule(new DailyScheduleDetails());
        this.scheduleData.getDailySchedule().setScheduleEndDate(this.scheduleData.getScheduleStartDate());
        this.testAssertFalse();
    }

    @Test
    public void testWeeklyForTrue() throws Exception {
        this.prerequisite(StyleKey.WEEKLY);
        this.scheduleData.setWeeklySchedule(new WeeklyScheduleDetails());
        Date dt = DateUtils.addDays((Date)new Date(), (int)1);
        this.scheduleData.getWeeklySchedule().setScheduleEndDate(new java.sql.Date(dt.getTime()));
        this.testAssertTrue();
    }

    @Test
    public void testWeeklyForFalse() throws Exception {
        this.prerequisite(StyleKey.WEEKLY);
        this.scheduleData.setWeeklySchedule(new WeeklyScheduleDetails());
        this.scheduleData.getWeeklySchedule().setScheduleEndDate(this.scheduleData.getScheduleStartDate());
        this.testAssertFalse();
    }

    @Test
    public void testMonthlyForTrue() throws Exception {
        this.prerequisite(StyleKey.MONTHLY);
        this.scheduleData.setMonthlySchedule(new MonthlyScheduleDetails());
        Date dt = DateUtils.addDays((Date)new Date(), (int)1);
        this.scheduleData.getMonthlySchedule().setScheduleEndDate(new java.sql.Date(dt.getTime()));
        this.testAssertTrue();
    }

    @Test
    public void testMonthlyForFalse() throws Exception {
        this.prerequisite(StyleKey.MONTHLY);
        this.scheduleData.setMonthlySchedule(new MonthlyScheduleDetails());
        this.scheduleData.getMonthlySchedule().setScheduleEndDate(this.scheduleData.getScheduleStartDate());
        this.testAssertFalse();
    }

    @Test
    public void testYearlyForTrue() throws Exception {
        this.prerequisite(StyleKey.YEARLY);
        this.scheduleData.setYearlySchedule(new YearlyScheduleDetails());
        Date dt = DateUtils.addDays((Date)new Date(), (int)1);
        this.scheduleData.getYearlySchedule().setScheduleEndDate(new java.sql.Date(dt.getTime()));
        this.testAssertTrue();
    }

    @Test
    public void testYearlyForFalse() throws Exception {
        this.prerequisite(StyleKey.YEARLY);
        this.scheduleData.setYearlySchedule(new YearlyScheduleDetails());
        this.scheduleData.getYearlySchedule().setScheduleEndDate(this.scheduleData.getScheduleStartDate());
        this.testAssertFalse();
    }

    private void testAssertTrue() {
        boolean val = new CommitteeScheduleStartAndEndDateRule().processRules(this.event);
        Assert.assertTrue((boolean)val);
    }

    private void testAssertFalse() {
        boolean val = new CommitteeScheduleStartAndEndDateRule().processRules(this.event);
        Assert.assertFalse((boolean)val);
    }

    private void prerequisite(StyleKey key) {
        this.scheduleData = new ScheduleData();
        this.scheduleData.setRecurrenceType(key.toString());
        this.scheduleData.setScheduleStartDate(new java.sql.Date(new Date().getTime()));
        this.event = new CommitteeScheduleStartAndEndDateEvent("", this.document, this.scheduleData, null, null);
    }
}

