/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.rules;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.committee.rule.event.CommitteeScheduleEventBase;
import org.kuali.kra.committee.rule.event.CommitteeScheduleTimeEvent;
import org.kuali.kra.committee.rules.CommitteeScheduleTimeRule;
import org.kuali.kra.common.committee.web.struts.form.schedule.ScheduleData;
import org.kuali.kra.common.committee.web.struts.form.schedule.Time12HrFmt;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.springframework.util.AutoPopulatingList;

public class CommitteeScheduleTimeRuleTest {
    private List<CommitteeSchedule> committeeSchedules;
    private ScheduleData scheduleData;
    private CommitteeScheduleTimeEvent event;
    private CommitteeScheduleTimeRule rule;
    public static String TIME_10_10 = "10:10";
    public static String TIME_ = "";
    public static String TIME_10_100 = "10:100";
    public static String TIME_100_10 = "100:10";
    public static String TIME_0_10 = "0:10";
    public static String TIME_NON_NUMBERS = "not a number";

    @Before
    public void setUp() {
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        KNSGlobalVariables.setAuditErrorMap(new HashMap());
    }

    @Test
    public void testProcessRuleTrueWithScheduleData() {
        this.prerequisiteScheduleData();
        this.scheduleData.getTime().setTime(TIME_10_10);
        boolean val = this.executeRule();
        Assert.assertTrue((boolean)val);
    }

    @Test
    public void testProcessRuleFalseTimeBlankWithScheduleData() {
        this.prerequisiteScheduleData();
        this.scheduleData.getTime().setTime(TIME_);
        boolean val = this.executeRule();
        Assert.assertFalse((boolean)val);
        Assert.assertEquals((Object)"error.committeeSchedule.viewTime.blank()", (Object)((ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("committeeHelper.scheduleData.time.time")).get(0)).toString());
    }

    @Test
    public void testProcessRuleFalseMinutesOutOfBoundsWithScheduleData() {
        this.prerequisiteScheduleData();
        this.scheduleData.getTime().setTime(TIME_10_100);
        boolean val = this.executeRule();
        Assert.assertFalse((boolean)val);
        Assert.assertEquals((Object)("error.committeeSchedule.viewTime.formatting(" + TIME_10_100 + ", " + "mm as 0-59" + ")"), (Object)((ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("committeeHelper.scheduleData.time.time")).get(0)).toString());
    }

    @Test
    public void testProcessRuleFalseHourOutOfBoundsWithScheduleData() throws Exception {
        this.prerequisiteScheduleData();
        this.scheduleData.getTime().setTime(TIME_100_10);
        boolean val = this.executeRule();
        Assert.assertFalse((boolean)val);
        Assert.assertEquals((Object)("error.committeeSchedule.viewTime.formatting(" + TIME_100_10 + ", " + "hh as 1-12" + ")"), (Object)((ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("committeeHelper.scheduleData.time.time")).get(0)).toString());
    }

    @Test
    public void testProcessRuleFalseHourSetTo0WithScheduleData() {
        this.prerequisiteScheduleData();
        this.scheduleData.getTime().setTime(TIME_0_10);
        boolean val = this.executeRule();
        Assert.assertFalse((boolean)val);
        Assert.assertEquals((Object)("error.committeeSchedule.viewTime.formatting(" + TIME_0_10 + ", " + "hh as 1-12" + ")"), (Object)((ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("committeeHelper.scheduleData.time.time")).get(0)).toString());
    }

    @Test
    public void testProcessRuleFalseHoursMinutesSetToNonNumbersWithScheduleData() {
        this.prerequisiteScheduleData();
        this.scheduleData.getTime().setTime(TIME_NON_NUMBERS);
        boolean val = this.executeRule();
        Assert.assertFalse((boolean)val);
        Assert.assertEquals((Object)("error.committeeSchedule.viewTime.formatting(" + TIME_NON_NUMBERS + ", " + "hh:mm" + ")"), (Object)((ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("committeeHelper.scheduleData.time.time")).get(0)).toString());
    }

    @Test
    public void testProcessRuleFalseHoursMinutesSetToNonNumbersWithColonWithScheduleData() {
        this.prerequisiteScheduleData();
        this.scheduleData.getTime().setTime(TIME_NON_NUMBERS + ":" + TIME_NON_NUMBERS);
        boolean val = this.executeRule();
        Assert.assertFalse((boolean)val);
        Assert.assertEquals((Object)("error.committeeSchedule.viewTime.formatting(" + TIME_NON_NUMBERS + ":" + TIME_NON_NUMBERS + ", " + "hh as 1-12 &amp; mm as 0-59" + ")"), (Object)((ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("committeeHelper.scheduleData.time.time")).get(0)).toString());
    }

    private void prerequisiteScheduleData() {
        this.scheduleData = new ScheduleData();
        Time12HrFmt time = new Time12HrFmt(new Timestamp(new Date().getTime()));
        time.setMeridiem(Time12HrFmt.MERIDIEM.PM.toString());
        this.scheduleData.setTime(time);
        this.event = new CommitteeScheduleTimeEvent("", null, this.scheduleData, null, CommitteeScheduleEventBase.ErrorType.HARDERROR);
    }

    @Test
    public void testProcessRuleTrueWithCommitteeSchedule() throws Exception {
        this.prerequisiteCommitteeScheduleData();
        boolean val = this.executeRule();
        Assert.assertTrue((boolean)val);
        Assert.assertEquals((long)0L, (long)GlobalVariables.getMessageMap().getErrorMessages().size());
    }

    @Test
    public void testProcessRuleFalseTimeBlankWithCommitteeSchedule() {
        this.prerequisiteCommitteeScheduleData();
        this.committeeSchedules.get(0).getViewTime().setTime(TIME_);
        this.committeeSchedules.get(2).getViewTime().setTime(TIME_);
        boolean val = this.executeRule();
        Assert.assertFalse((boolean)val);
        Assert.assertEquals((long)2L, (long)GlobalVariables.getMessageMap().getErrorMessages().size());
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().getErrorMessages().containsKey("document.committeeList[0].committeeSchedules[0].viewTime.time"));
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().getErrorMessages().containsKey("document.committeeList[0].committeeSchedules[2].viewTime.time"));
        Assert.assertEquals((Object)"error.committeeSchedule.viewTime.blank()", (Object)((ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.committeeList[0].committeeSchedules[0].viewTime.time")).get(0)).toString());
        Assert.assertEquals((Object)"error.committeeSchedule.viewTime.blank()", (Object)((ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.committeeList[0].committeeSchedules[2].viewTime.time")).get(0)).toString());
    }

    @Test
    public void testProcessRuleFalseWithBlankAndMinutesOutOfBoundsWithCommitteeSchedule() {
        this.prerequisiteCommitteeScheduleData();
        this.committeeSchedules.get(1).getViewTime().setTime(TIME_);
        this.committeeSchedules.get(4).getViewTime().setTime(TIME_10_100);
        boolean val = this.executeRule();
        Assert.assertFalse((boolean)val);
        Assert.assertEquals((long)2L, (long)GlobalVariables.getMessageMap().getErrorMessages().size());
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().getErrorMessages().containsKey("document.committeeList[0].committeeSchedules[1].viewTime.time"));
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().getErrorMessages().containsKey("document.committeeList[0].committeeSchedules[4].viewTime.time"));
        Assert.assertEquals((Object)"error.committeeSchedule.viewTime.blank()", (Object)((ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.committeeList[0].committeeSchedules[1].viewTime.time")).get(0)).toString());
        Assert.assertEquals((Object)("error.committeeSchedule.viewTime.formatting(" + TIME_10_100 + ", " + "mm as 0-59" + ")"), (Object)((ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.committeeList[0].committeeSchedules[4].viewTime.time")).get(0)).toString());
    }

    @Test
    public void testProcessRuleFalseHoursOutOfBoundsAndHourSetTo0AndBlankWithCommitteeSchedule() {
        this.prerequisiteCommitteeScheduleData();
        this.committeeSchedules.get(0).getViewTime().setTime(TIME_100_10);
        this.committeeSchedules.get(2).getViewTime().setTime(TIME_0_10);
        this.committeeSchedules.get(3).getViewTime().setTime(TIME_);
        boolean val = this.executeRule();
        Assert.assertFalse((boolean)val);
        Assert.assertEquals((long)3L, (long)GlobalVariables.getMessageMap().getErrorMessages().size());
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().getErrorMessages().containsKey("document.committeeList[0].committeeSchedules[0].viewTime.time"));
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().getErrorMessages().containsKey("document.committeeList[0].committeeSchedules[2].viewTime.time"));
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().getErrorMessages().containsKey("document.committeeList[0].committeeSchedules[3].viewTime.time"));
        Assert.assertEquals((Object)("error.committeeSchedule.viewTime.formatting(" + TIME_100_10 + ", " + "hh as 1-12" + ")"), (Object)((ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.committeeList[0].committeeSchedules[0].viewTime.time")).get(0)).toString());
        Assert.assertEquals((Object)("error.committeeSchedule.viewTime.formatting(" + TIME_0_10 + ", " + "hh as 1-12" + ")"), (Object)((ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.committeeList[0].committeeSchedules[2].viewTime.time")).get(0)).toString());
        Assert.assertEquals((Object)"error.committeeSchedule.viewTime.blank()", (Object)((ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.committeeList[0].committeeSchedules[3].viewTime.time")).get(0)).toString());
    }

    @Test
    public void testProcessRuleFalseNonNumbersWithAndWithoutColonsWithCommitteeSchedule() {
        this.prerequisiteCommitteeScheduleData();
        this.committeeSchedules.get(2).getViewTime().setTime(TIME_NON_NUMBERS + ":" + TIME_NON_NUMBERS);
        this.committeeSchedules.get(4).getViewTime().setTime(TIME_NON_NUMBERS);
        boolean val = this.executeRule();
        Assert.assertFalse((boolean)val);
        Assert.assertEquals((long)2L, (long)GlobalVariables.getMessageMap().getErrorMessages().size());
        Assert.assertEquals((Object)("error.committeeSchedule.viewTime.formatting(" + TIME_NON_NUMBERS + ":" + TIME_NON_NUMBERS + ", " + "hh as 1-12 &amp; mm as 0-59" + ")"), (Object)((ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.committeeList[0].committeeSchedules[2].viewTime.time")).get(0)).toString());
        Assert.assertEquals((Object)("error.committeeSchedule.viewTime.formatting(" + TIME_NON_NUMBERS + ", " + "hh:mm" + ")"), (Object)((ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.committeeList[0].committeeSchedules[4].viewTime.time")).get(0)).toString());
    }

    private void prerequisiteCommitteeScheduleData() {
        this.committeeSchedules = new ArrayList<CommitteeSchedule>();
        this.committeeSchedules.add(new CommitteeSchedule());
        this.committeeSchedules.add(new CommitteeSchedule());
        this.committeeSchedules.add(new CommitteeSchedule());
        this.committeeSchedules.add(new CommitteeSchedule());
        this.committeeSchedules.add(new CommitteeSchedule());
        for (CommitteeSchedule schedule : this.committeeSchedules) {
            Time12HrFmt time = new Time12HrFmt(new Timestamp(new Date().getTime()));
            time.setMeridiem(Time12HrFmt.MERIDIEM.PM.toString());
            schedule.setViewTime(time);
        }
        this.event = new CommitteeScheduleTimeEvent("", null, null, this.committeeSchedules, CommitteeScheduleEventBase.ErrorType.HARDERROR);
    }

    private boolean executeRule() {
        this.rule = new CommitteeScheduleTimeRule();
        boolean val = this.rule.processRules(this.event);
        return val;
    }
}

